@extends('layouts.app')

@section('title', 'Detalhes do Funcionário - SGE')

@section('content')
<div class="row">
    <div class="col-md-10">
        <div class="card">
            <div class="card-header bg-primary-custom text-white d-flex justify-content-between align-items-center">
                <h4 class="mb-0">Detalhes do Funcionário</h4>
                <div class="btn-group btn-group-sm">
                    <a href="{{ route('admin.funcionarios-servicos.edit', $funcionarioServico) }}" class="btn btn-light">
                        <i class="bi bi-pencil"></i> Editar
                    </a>
                    <a href="{{ route('admin.funcionarios-servicos.index') }}" class="btn btn-light">
                        <i class="bi bi-arrow-left"></i> Voltar
                    </a>
                </div>
            </div>
            <div class="card-body">
                <div class="row g-3">
                    <div class="col-md-6">
                        <strong>Nome:</strong> {{ $funcionarioServico->nome }}
                    </div>
                    <div class="col-md-6">
                        <strong>Cargo:</strong> {{ $funcionarioServico->cargo }}
                    </div>
                    <div class="col-md-6">
                        <strong>Salário Base:</strong> {{ number_format($funcionarioServico->salario_base ?? 0, 2, ',', '.') }}
                    </div>
                    <div class="col-md-6">
                        <strong>Dependentes:</strong> {{ $funcionarioServico->numero_dependentes ?? 0 }}
                    </div>
                    <div class="col-md-6">
                        <strong>Telefone:</strong> {{ $funcionarioServico->telefone ?: '-' }}
                    </div>
                    <div class="col-md-6">
                        <strong>Status:</strong>
                        @if($funcionarioServico->is_active)
                            <span class="badge bg-success">Ativo</span>
                        @else
                            <span class="badge bg-danger">Inativo</span>
                        @endif
                    </div>
                    <div class="col-md-12">
                        <strong>Endereço:</strong> {{ $funcionarioServico->endereco ?: '-' }}
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

