@extends('layouts.app')

@section('title', 'Editar Administração - SGE')

@section('content')
<div class="row">
    <div class="col-md-8">
        <div class="card">
            <div class="card-header bg-primary-custom text-white py-2">
                <h5 class="mb-0">Editar Administração</h5>
            </div>
            <div class="card-body p-3">
                <form method="POST" action="{{ route('admin.funcionarios.update', $funcionario) }}">
                    @csrf
                    @method('PUT')

                    <div class="row g-2">
                        <div class="col-md-6">
                            <label for="name" class="form-label small mb-0">Nome *</label>
                            <input type="text" class="form-control form-control-sm @error('name') is-invalid @enderror" 
                                   id="name" name="name" value="{{ old('name', $funcionario->user->name) }}" required>
                            @error('name')
                                <div class="invalid-feedback small">{{ $message }}</div>
                            @enderror
                        </div>

                        <div class="col-md-6">
                            <label for="email" class="form-label small mb-0">Email *</label>
                            <input type="email" class="form-control form-control-sm @error('email') is-invalid @enderror" 
                                   id="email" name="email" value="{{ old('email', $funcionario->user->email) }}" required>
                            @error('email')
                                <div class="invalid-feedback small">{{ $message }}</div>
                            @enderror
                        </div>
                    </div>

                    <div class="row g-2 mt-1">
                        <div class="col-md-6">
                            <label for="cargo" class="form-label small mb-0">Cargo <span class="text-danger">*</span></label>
                            <input type="text" class="form-control form-control-sm @error('cargo') is-invalid @enderror"
                                   id="cargo" name="cargo" value="{{ old('cargo', $funcionario->cargo ?? '') }}" 
                                   placeholder="Ex: MANUTENÇÃO, LIMPEZA, SEGURANÇA..." required>
                            @error('cargo')
                                <div class="invalid-feedback small">{{ $message }}</div>
                            @enderror
                        </div>
                        <div class="col-md-3">
                            <label for="salario_base" class="form-label small mb-0">Salário Base</label>
                            <input type="number" step="0.01" min="0" class="form-control form-control-sm @error('salario_base') is-invalid @enderror"
                                   id="salario_base" name="salario_base" value="{{ old('salario_base', $funcionario->salario_base ?? 0) }}" placeholder="0.00">
                            @error('salario_base')
                                <div class="invalid-feedback small">{{ $message }}</div>
                            @enderror
                        </div>
                        <div class="col-md-3">
                            <label for="numero_dependentes" class="form-label small mb-0">Dependentes</label>
                            <input type="number" min="0" class="form-control form-control-sm @error('numero_dependentes') is-invalid @enderror"
                                   id="numero_dependentes" name="numero_dependentes" value="{{ old('numero_dependentes', $funcionario->numero_dependentes ?? 0) }}">
                            @error('numero_dependentes')
                                <div class="invalid-feedback small">{{ $message }}</div>
                            @enderror
                        </div>
                    </div>

                    <div class="row g-2 mt-1">
                        <div class="col-md-6">
                            <label for="telefone" class="form-label small mb-0">Telefone</label>
                            <input type="text" class="form-control form-control-sm @error('telefone') is-invalid @enderror"
                                   id="telefone" name="telefone" value="{{ old('telefone', $funcionario->telefone) }}">
                            @error('telefone')
                                <div class="invalid-feedback small">{{ $message }}</div>
                            @enderror
                        </div>
                        <div class="col-md-6">
                            <label for="endereco" class="form-label small mb-0">Endereço</label>
                            <input type="text" class="form-control form-control-sm @error('endereco') is-invalid @enderror"
                                   id="endereco" name="endereco" value="{{ old('endereco', $funcionario->endereco) }}">
                            @error('endereco')
                                <div class="invalid-feedback small">{{ $message }}</div>
                            @enderror
                        </div>
                    </div>

                    <hr class="my-3">

                    <div class="row g-2">
                        <div class="col-md-6">
                            <div class="form-check">
                                <input class="form-check-input" type="checkbox" id="gerir_alunos" name="gerir_alunos" value="1" {{ (old('gerir_alunos', $funcionario->gerir_alunos) === true || old('gerir_alunos', $funcionario->gerir_alunos) === 1) ? 'checked' : '' }}>
                                <label class="form-check-label small" for="gerir_alunos">Gerir Alunos</label>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-check">
                                <input class="form-check-input" type="checkbox" id="gerir_professores" name="gerir_professores" value="1" {{ (old('gerir_professores', $funcionario->gerir_professores) === true || old('gerir_professores', $funcionario->gerir_professores) === 1) ? 'checked' : '' }}>
                                <label class="form-check-label small" for="gerir_professores">Gerir Professores</label>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-check">
                                <input class="form-check-input" type="checkbox" id="gerir_turmas" name="gerir_turmas" value="1" {{ (old('gerir_turmas', $funcionario->gerir_turmas) === true || old('gerir_turmas', $funcionario->gerir_turmas) === 1) ? 'checked' : '' }}>
                                <label class="form-check-label small" for="gerir_turmas">Gerir Turmas</label>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-check">
                                <input class="form-check-input" type="checkbox" id="gerir_disciplinas" name="gerir_disciplinas" value="1" {{ (old('gerir_disciplinas', $funcionario->gerir_disciplinas) === true || old('gerir_disciplinas', $funcionario->gerir_disciplinas) === 1) ? 'checked' : '' }}>
                                <label class="form-check-label small" for="gerir_disciplinas">Gerir Disciplinas</label>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-check">
                                <input class="form-check-input" type="checkbox" id="gerir_mensalidades" name="gerir_mensalidades" value="1" {{ (old('gerir_mensalidades', $funcionario->gerir_mensalidades) === true || old('gerir_mensalidades', $funcionario->gerir_mensalidades) === 1) ? 'checked' : '' }}>
                                <label class="form-check-label small" for="gerir_mensalidades">Gerir Mensalidades</label>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-check">
                                <input class="form-check-input" type="checkbox" id="gerir_horarios" name="gerir_horarios" value="1" {{ (old('gerir_horarios', $funcionario->gerir_horarios) === true || old('gerir_horarios', $funcionario->gerir_horarios) === 1) ? 'checked' : '' }}>
                                <label class="form-check-label small" for="gerir_horarios">Gerir Horários</label>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-check">
                                <input class="form-check-input" type="checkbox" id="gerir_eventos" name="gerir_eventos" value="1" {{ (old('gerir_eventos', $funcionario->gerir_eventos) === true || old('gerir_eventos', $funcionario->gerir_eventos) === 1) ? 'checked' : '' }}>
                                <label class="form-check-label small" for="gerir_eventos">Gerir Eventos</label>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-check">
                                <input class="form-check-input" type="checkbox" id="gerir_planos" name="gerir_planos" value="1" {{ (old('gerir_planos', $funcionario->gerir_planos) === true || old('gerir_planos', $funcionario->gerir_planos) === 1) ? 'checked' : '' }}>
                                <label class="form-check-label small" for="gerir_planos">Gerir Planos</label>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-check">
                                <input class="form-check-input" type="checkbox" id="gerir_avaliacoes" name="gerir_avaliacoes" value="1" {{ (old('gerir_avaliacoes', $funcionario->gerir_avaliacoes) === true || old('gerir_avaliacoes', $funcionario->gerir_avaliacoes) === 1) ? 'checked' : '' }}>
                                <label class="form-check-label small" for="gerir_avaliacoes">Gerir Avaliações</label>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-check">
                                <input class="form-check-input" type="checkbox" id="gerir_inscricoes" name="gerir_inscricoes" value="1" {{ (old('gerir_inscricoes', $funcionario->gerir_inscricoes) === true || old('gerir_inscricoes', $funcionario->gerir_inscricoes) === 1) ? 'checked' : '' }}>
                                <label class="form-check-label small" for="gerir_inscricoes">Gerir Inscrições</label>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-check">
                                <input class="form-check-input" type="checkbox" id="gerir_recuperacao_senha" name="gerir_recuperacao_senha" value="1" {{ (old('gerir_recuperacao_senha', $funcionario->gerir_recuperacao_senha) === true || old('gerir_recuperacao_senha', $funcionario->gerir_recuperacao_senha) === 1) ? 'checked' : '' }}>
                                <label class="form-check-label small" for="gerir_recuperacao_senha">Recuperar Senhas (Alunos/Professores)</label>
                            </div>
                            <div class="form-check">
                                <input class="form-check-input" type="checkbox" id="gerir_pagamentos_professores" name="gerir_pagamentos_professores" value="1" {{ (old('gerir_pagamentos_professores', $funcionario->gerir_pagamentos_professores) === true || old('gerir_pagamentos_professores', $funcionario->gerir_pagamentos_professores) === 1) ? 'checked' : '' }}>
                                <label class="form-check-label small" for="gerir_pagamentos_professores">Pagamentos de Professores</label>
                            </div>
                        </div>
                    </div>

                    <div class="mt-3">
                        <button type="submit" class="btn btn-sm btn-primary-custom">Salvar</button>
                        <a href="{{ route('admin.funcionarios.index') }}" class="btn btn-sm btn-secondary">Cancelar</a>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

@endsection
