@extends('layouts.app')

@section('title', 'Detalhes da Administração - SGE')

@section('content')
<div class="row">
    <div class="col-md-10">
        <div class="card">
            <div class="card-header bg-primary-custom text-white d-flex justify-content-between align-items-center">
                <h4 class="mb-0">Detalhes da Administração</h4>
                <div>
                    <a href="{{ route('admin.funcionarios.edit', $funcionario) }}" class="btn btn-sm btn-light">
                        <i class="bi bi-pencil"></i> Editar
                    </a>
                    <a href="{{ route('admin.funcionarios.index') }}" class="btn btn-sm btn-light">
                        <i class="bi bi-arrow-left"></i> Voltar
                    </a>
                </div>
            </div>
            <div class="card-body">
                <h6 class="mb-3" style="color: #495057; border-bottom: 1px solid #dee2e6; padding-bottom: 8px;">Dados Pessoais</h6>
                
                <div class="row mb-3">
                    <div class="col-md-6">
                        <strong>Nome:</strong> {{ $funcionario->user->name }}
                    </div>
                    <div class="col-md-6">
                        <strong>Email:</strong> {{ $funcionario->user->email }}
                    </div>
                    <div class="col-md-6 mt-2">
                        <strong>Número de Funcionário:</strong> {{ $funcionario->numero_funcionario ?? '-' }}
                    </div>
                    <div class="col-md-6 mt-2">
                        <strong>Cargo:</strong> {{ $funcionario->cargo ?? '-' }}
                    </div>
                    <div class="col-md-6 mt-2">
                        <strong>Telefone:</strong> {{ $funcionario->telefone ?? '-' }}
                    </div>
                    <div class="col-md-6 mt-2">
                        <strong>Status:</strong> 
                        @if($funcionario->user->is_active)
                            <span class="badge bg-success">Activo</span>
                        @else
                            <span class="badge bg-danger">Bloqueado</span>
                        @endif
                    </div>
                    @if($funcionario->endereco)
                    <div class="col-md-12 mt-2">
                        <strong>Endereço:</strong> {{ $funcionario->endereco }}
                    </div>
                    @endif
                </div>

                <hr>

                <h6 class="mb-3" style="color: #495057; border-bottom: 1px solid #dee2e6; padding-bottom: 8px;">Permissões Ativas</h6>
                
                <div class="row">
                    @php
                        $permissoes = [
                            'gerir_alunos' => ['Gerir Alunos', 'Criar, editar e gerenciar alunos'],
                            'gerir_professores' => ['Gerir Professores', 'Criar, editar e gerenciar professores'],
                            'gerir_turmas' => ['Gerir Turmas', 'Criar e gerenciar turmas'],
                            'gerir_disciplinas' => ['Gerir Disciplinas', 'Criar e gerenciar disciplinas'],
                            'gerir_mensalidades' => ['Gerir Mensalidades', 'Gerenciar pagamentos e finanças'],
                            'gerir_horarios' => ['Gerir Horários', 'Criar e gerenciar horários de aulas'],
                            'gerir_eventos' => ['Gerir Eventos', 'Criar e gerenciar eventos escolares'],
                            'gerir_planos' => ['Gerir Planos', 'Visualizar e gerenciar planos trimestrais'],
                            'gerir_avaliacoes' => ['Gerir Avaliações', 'Visualizar e gerenciar avaliações'],
                            'gerir_inscricoes' => ['Gerir Inscrições', 'Gerenciar inscrições e renovações'],
                            'gerir_recuperacao_senha' => ['Recuperar Senhas', 'Recuperar senhas de alunos e professores'],
                            'gerir_pagamentos_professores' => ['Pagamentos de Professores', 'Gerenciar pagamentos de professores'],
                        ];
                    @endphp

                    @foreach($permissoes as $campo => $info)
                        @php
                            // Verificar explicitamente se a permissão está Activa
                            $valor = $funcionario->getAttribute($campo);
                            $estaAtiva = ($valor === true || $valor === 1 || $valor === '1');
                        @endphp
                        <div class="col-md-6 mb-2">
                            <div class="d-flex align-items-center">
                                @if($estaAtiva)
                                    <i class="bi bi-check-circle-fill text-success me-2"></i>
                                @else
                                    <i class="bi bi-x-circle text-muted me-2"></i>
                                @endif
                                <div>
                                    <strong>{{ $info[0] }}</strong>
                                    <small class="d-block text-muted">{{ $info[1] }}</small>
                                </div>
                            </div>
                        </div>
                    @endforeach
                </div>

                @if($funcionario->getPermissoesAtivas() === [])
                    <div class="alert alert-info">
                        <i class="bi bi-info-circle"></i> Este funcionário não possui permissões ativas.
                    </div>
                @endif

                <hr>

                <div class="mt-3">
                    <strong>Criado em:</strong> {{ $funcionario->created_at->format('d/m/Y H:i') }}<br>
                    <strong>Última atualização:</strong> {{ $funcionario->updated_at->format('d/m/Y H:i') }}
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

