@extends('layouts.app')

@section('title', 'Gestão - SGE')

@section('content')
<div class="row">
    <div class="col-12">
        <h2 class="mb-4">Gestão Escolar</h2>
        
        <div class="row g-4">
            <!-- Alunos -->
            <div class="col-md-6 col-lg-4">
                <div class="card h-100 shadow-sm">
                    <div class="card-body text-center">
                        <i class="bi bi-people-fill fa-3x text-primary mb-3"></i>
                        <h5 class="card-title">Alunos</h5>
                        <p class="card-text text-muted">Gerir alunos e seus dados</p>
                        <a href="{{ route('admin.alunos.index') }}" class="btn btn-primary-custom">
                            <i class="bi bi-arrow-right me-1"></i> Acessar
                        </a>
                    </div>
                </div>
            </div>

            <!-- Professores -->
            <div class="col-md-6 col-lg-4">
                <div class="card h-100 shadow-sm">
                    <div class="card-body text-center">
                        <i class="bi bi-person-badge-fill fa-3x text-primary mb-3"></i>
                        <h5 class="card-title">Professores</h5>
                        <p class="card-text text-muted">Gerir professores e seus dados</p>
                        <a href="{{ route('admin.professores.index') }}" class="btn btn-primary-custom">
                            <i class="bi bi-arrow-right me-1"></i> Acessar
                        </a>
                    </div>
                </div>
            </div>

            <!-- Turmas -->
            <div class="col-md-6 col-lg-4">
                <div class="card h-100 shadow-sm">
                    <div class="card-body text-center">
                        <i class="bi bi-collection-fill fa-3x text-primary mb-3"></i>
                        <h5 class="card-title">Turmas</h5>
                        <p class="card-text text-muted">Gerir turmas e alocações</p>
                        <a href="{{ route('admin.turmas.index') }}" class="btn btn-primary-custom">
                            <i class="bi bi-arrow-right me-1"></i> Acessar
                        </a>
                    </div>
                </div>
            </div>

            <!-- Disciplinas -->
            <div class="col-md-6 col-lg-4">
                <div class="card h-100 shadow-sm">
                    <div class="card-body text-center">
                        <i class="bi bi-book-fill fa-3x text-primary mb-3"></i>
                        <h5 class="card-title">Disciplinas</h5>
                        <p class="card-text text-muted">Gerir disciplinas e modelos de avaliação</p>
                        <a href="{{ route('admin.disciplinas.index') }}" class="btn btn-primary-custom">
                            <i class="bi bi-arrow-right me-1"></i> Acessar
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

