@extends('layouts.app')

@section('title', 'Alunos Renovados - SIGE')

@section('content')
<div class="container-fluid py-2">
    <div class="d-flex justify-content-between align-items-center mb-3">
        <h5 class="mb-0">Alunos Renovados</h5>
        <a href="{{ route('admin.inscricoes.index') }}" class="btn btn-sm btn-outline-primary">Voltar</a>
    </div>

    <div class="card mb-3">
        <div class="card-body p-2">
            <form method="GET" action="{{ route('admin.inscricoes.renovados') }}" class="row g-2">
                <div class="col-md-3">
                    <label for="ano_letivo_id" class="form-label small mb-0">Ano Lectivo</label>
                    <select class="form-select form-select-sm" id="ano_letivo_id" name="ano_letivo_id">
                        <option value="">Selecione o Ano Lectivo</option>
                        @foreach($anosLetivos as $ano)
                            <option value="{{ $ano->id }}" {{ $anoLetivoId == $ano->id ? 'selected' : '' }}>
                                @php
                                    $anoFinal = strpos($ano->ano, '/') !== false ? explode('/', $ano->ano)[1] : $ano->ano;
                                @endphp
                                {{ $anoFinal }}
                                @if($ano->ativo) (Activo) @endif
                            </option>
                        @endforeach
                    </select>
                </div>
                <div class="col-md-3">
                    <label for="search" class="form-label small mb-0">Pesquisar</label>
                    <input type="text" class="form-control form-control-sm" id="search" name="search" 
                           value="{{ request('search') }}" placeholder="Código ou Nome...">
                </div>
                <div class="col-md-2">
                    <button type="submit" class="btn btn-sm btn-primary mt-4">Filtrar</button>
                </div>
            </form>
        </div>
    </div>

    <div class="table-responsive">
        <table class="table table-sm table-bordered" style="font-size: 0.85rem; margin-bottom: 0;">
            <thead style="background-color: #f8f9fa;">
                <tr>
                    <th style="padding: 6px;">Código</th>
                    <th style="padding: 6px;">Nome</th>
                    <th style="padding: 6px;">Turma Atual</th>
                    <th style="padding: 6px;">Classe</th>
                    <th style="padding: 6px;">Status</th>
                </tr>
            </thead>
            <tbody>
                @forelse($alunos as $aluno)
                    <tr>
                        <td style="padding: 5px;">{{ $aluno->codigo_estudante }}</td>
                        <td style="padding: 5px;">{{ $aluno->user->name ?? '-' }}</td>
                        <td style="padding: 5px;">
                            @if($aluno->turmas->isNotEmpty())
                                @foreach($aluno->turmas as $turma)
                                    <span style="font-size: 0.75rem; padding: 2px 6px; background: #e7f3ff; color: #0066cc; border-radius: 3px;">{{ $turma->codigo }} - {{ $turma->nome }}</span>
                                @endforeach
                            @else
                                <span style="color: #999;">Sem turma</span>
                            @endif
                        </td>
                        <td style="padding: 5px;">
                            @if($aluno->turmas->isNotEmpty())
                                {{ $aluno->turmas->first()->codigo }}
                            @else
                                -
                            @endif
                        </td>
                        <td style="padding: 5px;">
                            @if($aluno->user && $aluno->user->is_active)
                                <span style="font-size: 0.75rem; padding: 2px 6px; background: #d4edda; color: #155724; border-radius: 3px;">Activo</span>
                            @else
                                <span style="font-size: 0.75rem; padding: 2px 6px; background: #f8d7da; color: #721c24; border-radius: 3px;">Bloqueado</span>
                            @endif
                        </td>
                    </tr>
                @empty
                    <tr>
                        <td colspan="5" class="text-center">Nenhum aluno renovado encontrado</td>
                    </tr>
                @endforelse
            </tbody>
        </table>
    </div>
</div>
@endsection

