@extends('layouts.app')

@section('title', 'Renovar Matrícula - SIGE')

@section('content')
<div class="container-fluid py-2">
    <div class="d-flex justify-content-between align-items-center mb-3">
        <h5 class="mb-0">Renovar Matrícula</h5>
        <a href="{{ route('admin.inscricoes.index') }}" class="btn btn-sm btn-secondary">
            <i class="bi bi-arrow-left"></i> Voltar
        </a>
    </div>

    @if(session('error'))
        <div class="alert alert-danger alert-dismissible fade show" role="alert">
            {{ session('error') }}
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    @endif

    <div class="card mb-3">
        <div class="card-body p-2">
            <h6 class="mb-2">Informações do Aluno</h6>
            <div class="row g-2">
                <div class="col-md-4">
                    <strong>Código:</strong> {{ $aluno->codigo_estudante ?? 'N/A' }}
                </div>
                <div class="col-md-4">
                    <strong>Nome:</strong> {{ $aluno->user->name }}
                </div>
                <div class="col-md-4">
                    <strong>Turma Anterior:</strong> 
                    @if($turmaAtual)
                        {{ $turmaAtual->codigo }} - {{ $turmaAtual->nome }}
                    @else
                        N/A
                    @endif
                </div>
                <div class="col-md-4">
                    <strong>Status:</strong>
                    @if($isAprovado)
                        <span class="badge bg-success">Aprovado</span>
                    @else
                        <span class="badge bg-danger">Reprovado</span>
                    @endif
                </div>
            </div>
        </div>
    </div>

    <div class="card">
        <div class="card-header {{ $isAprovado ? 'bg-success' : 'bg-warning' }} text-white py-2">
            <h6 class="mb-0">
                @if($isAprovado)
                    Selecionar Nova Turma ({{ $classeAtual + 1 }}ª Classe - Classe Superior)
                @else
                    Selecionar Nova Turma ({{ $classeAtual }}ª Classe - Mesma Classe)
                @endif
            </h6>
        </div>
        <div class="card-body p-3">
            @if($turmasDisponiveis->count() > 0)
                <form method="POST" action="{{ route('admin.inscricoes.renovar.processar', $aluno) }}">
                    @csrf
                    <div class="mb-3">
                        <label for="ano_letivo_id" class="form-label">Ano Letivo para Renovação <span class="text-danger">*</span></label>
                        <select class="form-select" id="ano_letivo_id" name="ano_letivo_id" required onchange="filtrarTurmasPorAnoLetivo()">
                            @foreach($anosLetivosDisponiveis ?? [] as $ano)
                                <option value="{{ $ano->id }}" 
                                        data-ano="{{ $ano->id }}"
                                        {{ $anoLetivoAtual->id == $ano->id ? 'selected' : '' }}>
                                    @php
                                        $anoRaw = $ano->getRawOriginal('ano');
                                        $anoExibido = strpos($anoRaw, '/') !== false ? $anoRaw : $anoRaw;
                                    @endphp
                                    {{ $anoExibido }}
                                    @if($ano->isDisponivelParaMatricula())
                                        (Disponível)
                                    @endif
                                </option>
                            @endforeach
                        </select>
                    </div>
                    <input type="hidden" name="ano_letivo_anterior_id" value="{{ $anoLetivoAnteriorId }}">
                    
                    <div class="mb-3">
                        <label for="turma_id" class="form-label">Nova Turma <span class="text-danger">*</span></label>
                        <select class="form-select @error('turma_id') is-invalid @enderror" 
                                id="turma_id" name="turma_id" required>
                            <option value="">Selecione a Turma</option>
                            @foreach($turmasDisponiveis as $turma)
                                <option value="{{ $turma->id }}" 
                                        data-ano-letivo-id="{{ $turma->ano_letivo_id }}"
                                        {{ old('turma_id') == $turma->id ? 'selected' : '' }}>
                                    {{ $turma->codigo }} - {{ $turma->nome }}
                                </option>
                            @endforeach
                        </select>
                        @error('turma_id')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                        <small class="text-muted">
                            @if($isAprovado)
                                Apenas turmas da {{ $classeAtual + 1 }}ª classe estão disponíveis (classe superior).
                            @else
                                Apenas turmas da {{ $classeAtual }}ª classe estão disponíveis (mesma classe, turma diferente).
                            @endif
                        </small>
                    </div>
                    
                    <div class="mt-3">
                        <button type="submit" class="btn btn-primary" onclick="return confirm('Tem certeza que deseja renovar a matrícula deste aluno?')">
                            <i class="bi bi-check-circle"></i> Confirmar Renovação
                        </button>
                        <a href="{{ route('admin.inscricoes.index') }}" class="btn btn-secondary">Cancelar</a>
                    </div>
                </form>
            @else
                <div class="alert alert-warning">
                    @php
                        $anoFinal = strpos($anoLetivoAtual->ano, '/') !== false ? explode('/', $anoLetivoAtual->ano)[1] : $anoLetivoAtual->ano;
                        $classeDestino = $isAprovado ? $classeAtual + 1 : $classeAtual;
                    @endphp
                    Nenhuma turma da {{ $classeDestino }}ª classe encontrada para o ano lectivo atual ({{ $anoFinal }}).
                    Por favor, crie turmas da {{ $classeDestino }}ª classe primeiro.
                </div>
            @endif
        </div>
    </div>
</div>

<script>
    function filtrarTurmasPorAnoLetivo() {
        const anoLetivoId = document.getElementById('ano_letivo_id').value;
        const turmaSelect = document.getElementById('turma_id');
        const options = turmaSelect.querySelectorAll('option');
        
        // Mostrar/ocultar opções baseado no ano letivo selecionado
        options.forEach(option => {
            if (option.value === '') {
                option.style.display = '';
            } else {
                const turmaAnoLetivoId = option.getAttribute('data-ano-letivo-id');
                if (turmaAnoLetivoId === anoLetivoId) {
                    option.style.display = '';
                } else {
                    option.style.display = 'none';
                }
            }
        });
        
        // Resetar seleção se a turma atual não pertence ao ano letivo selecionado
        const turmaSelecionada = turmaSelect.value;
        if (turmaSelecionada) {
            const optionSelecionada = turmaSelect.querySelector(`option[value="${turmaSelecionada}"]`);
            if (optionSelecionada && optionSelecionada.getAttribute('data-ano-letivo-id') !== anoLetivoId) {
                turmaSelect.value = '';
            }
        }
    }
    
    // Filtrar ao carregar a página
    document.addEventListener('DOMContentLoaded', function() {
        filtrarTurmasPorAnoLetivo();
    });
</script>
@endsection
