@extends('layouts.app')

@section('title', 'Visualizar Inscrição - SGE')

@section('content')
<div class="row">
    <div class="col-12">
        <div class="d-flex justify-content-between align-items-center mb-2" style="border-bottom: 1px solid #dee2e6; padding-bottom: 8px;">
            <div>
                <h5 class="mb-0" style="font-weight: 600;">{{ $aluno->user->name ?? 'N/A' }}</h5>
                <small class="text-muted">Código: {{ $aluno->codigo_estudante ?? 'N/A' }} | Status: 
                    <span class="badge bg-warning text-dark">PENDENTE</span>
                </small>
            </div>
            <div class="d-flex gap-1">
                <button type="button" class="btn btn-sm btn-success aprovar-btn" data-id="{{ $aluno->id }}">
                    <i class="bi bi-check-circle"></i> Aprovar
                </button>
                <button type="button" class="btn btn-sm btn-danger rejeitar-btn" data-id="{{ $aluno->id }}">
                    <i class="bi bi-x-circle"></i> Rejeitar
                </button>
                <a href="{{ route('admin.inscricoes.pendentes') }}" class="btn btn-sm btn-secondary">
                    <i class="bi bi-arrow-left"></i> Voltar
                </a>
            </div>
        </div>

        <div class="row">
            <div class="col-md-6 mb-3">
                <div class="mb-1">
                    <small class="text-muted" style="font-weight: 600;">Informações Pessoais</small>
                </div>
                <div style="background: #f8f9fa; padding: 15px; border-radius: 4px; font-size: 0.85rem;">
                    <div class="row mb-3">
                        <div class="col-4 text-center">
                            @if($aluno->foto)
                                <img src="{{ asset('storage/' . $aluno->foto) }}" 
                                     alt="Foto" 
                                     style="max-width: 100px; max-height: 120px; object-fit: cover; border-radius: 4px;">
                            @else
                                <div style="width: 100px; height: 120px; background-color: #e9ecef; border-radius: 4px; display: flex; align-items: center; justify-content: center; margin: 0 auto;">
                                    <span class="text-muted" style="font-size: 0.7rem;">Sem foto</span>
                                </div>
                            @endif
                        </div>
                        <div class="col-8">
                            <div class="mb-2"><strong>Nome:</strong> {{ $aluno->user->name ?? 'N/A' }}</div>
                            <div class="mb-2"><strong>Telefone:</strong> {{ $aluno->telefone ?? 'N/A' }}</div>
                            <div class="mb-2"><strong>Email:</strong> {{ $aluno->user->email ?? 'N/A' }}</div>
                            <div class="mb-2"><strong>Data Submissão:</strong> 
                                {{ $aluno->data_submissao ? $aluno->data_submissao->format('d/m/Y H:i') : 'N/A' }}
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-12 mb-2"><strong>Endereço:</strong> {{ $aluno->endereco ?? 'N/A' }}</div>
                        <div class="col-12 mb-2"><strong>Data de Nascimento:</strong> {{ $aluno->data_nascimento ? $aluno->data_nascimento->format('d/m/Y') : 'N/A' }}</div>
                        <div class="col-12 mb-2"><strong>Local de Nascimento:</strong> {{ $aluno->local_nascimento ?? 'N/A' }}</div>
                        <div class="col-12 mb-2"><strong>Naturalidade:</strong> {{ $aluno->naturalidade ?? 'N/A' }}</div>
                        <div class="col-12 mb-2"><strong>Distrito:</strong> {{ $aluno->distrito_natural ?? 'N/A' }}</div>
                        <div class="col-12 mb-2"><strong>Província:</strong> {{ $aluno->provincia_natural ?? 'N/A' }}</div>
                        <div class="col-12 mb-2"><strong>Gênero:</strong> 
                            @if($aluno->genero == 'M')
                                Masculino
                            @elseif($aluno->genero == 'F')
                                Feminino
                            @elseif($aluno->genero == 'Outro')
                                Outro
                            @else
                                N/A
                            @endif
                        </div>
                        <div class="col-12 mb-2"><strong>Tipo Documento:</strong> {{ $aluno->tipo_documento ?? 'N/A' }}</div>
                        <div class="col-12 mb-2"><strong>Nº Documento:</strong> {{ $aluno->num_documento ?? 'N/A' }}</div>
                        <div class="col-12 mb-2"><strong>Local Emissão:</strong> {{ $aluno->local_emissao ?? 'N/A' }}</div>
                        <div class="col-12 mb-2"><strong>Data Emissão:</strong> {{ $aluno->data_emissao ? $aluno->data_emissao->format('d/m/Y') : 'N/A' }}</div>
                    </div>
                </div>
            </div>

            <div class="col-md-6 mb-3">
                <div class="mb-1">
                    <small class="text-muted" style="font-weight: 600;">Encarregado de Educação</small>
                </div>
                <div style="background: #f8f9fa; padding: 15px; border-radius: 4px; font-size: 0.85rem;">
                    <div class="mb-2"><strong>Nome:</strong> {{ $aluno->nome_encarregado ?? 'N/A' }}</div>
                    <div class="mb-2"><strong>Telefone:</strong> {{ $aluno->telefone_encarregado ?? 'N/A' }}</div>
                    <div class="mb-2"><strong>Endereço:</strong> {{ $aluno->endereco_encarregado ?? 'N/A' }}</div>
                    <div class="mb-2"><strong>Profissão:</strong> {{ $aluno->profissao_encarregado ?? 'N/A' }}</div>
                    <div class="mb-2"><strong>BI N°:</strong> {{ $aluno->bi_encarregado ?? 'N/A' }}</div>
                    <div class="mb-2"><strong>Grau de Parentesco:</strong> {{ $aluno->grau_parentesco ?? 'N/A' }}</div>
                </div>

                <div class="mb-1 mt-3">
                    <small class="text-muted" style="font-weight: 600;">Pai</small>
                </div>
                <div style="background: #f8f9fa; padding: 15px; border-radius: 4px; font-size: 0.85rem;">
                    <div class="mb-2"><strong>Nome:</strong> {{ $aluno->nome_pai ?? 'N/A' }}</div>
                    <div class="mb-2"><strong>Local Trabalho:</strong> {{ $aluno->local_trabalho_pai ?? 'N/A' }}</div>
                    <div class="mb-2"><strong>Telefone:</strong> {{ $aluno->telefone_pai ?? 'N/A' }}</div>
                    <div class="mb-2"><strong>BI N°:</strong> {{ $aluno->bi_pai ?? 'N/A' }}</div>
                </div>

                <div class="mb-1 mt-3">
                    <small class="text-muted" style="font-weight: 600;">Mãe</small>
                </div>
                <div style="background: #f8f9fa; padding: 15px; border-radius: 4px; font-size: 0.85rem;">
                    <div class="mb-2"><strong>Nome:</strong> {{ $aluno->nome_mae ?? 'N/A' }}</div>
                    <div class="mb-2"><strong>Local Trabalho:</strong> {{ $aluno->local_trabalho_mae ?? 'N/A' }}</div>
                    <div class="mb-2"><strong>Telefone:</strong> {{ $aluno->telefone_mae ?? 'N/A' }}</div>
                    <div class="mb-2"><strong>BI N°:</strong> {{ $aluno->bi_mae ?? 'N/A' }}</div>
                </div>
            </div>
        </div>

        <div class="row">
            <div class="col-md-6 mb-3">
                <div class="mb-1">
                    <small class="text-muted" style="font-weight: 600;">Informação Complementar</small>
                </div>
                <div style="background: #f8f9fa; padding: 15px; border-radius: 4px; font-size: 0.85rem;">
                    <div class="mb-2"><strong>Irmãos mais velhos:</strong> {{ $aluno->num_irmaos_mais_velhos ?? 0 }}</div>
                    <div class="mb-2"><strong>Irmãos mais novos:</strong> {{ $aluno->num_irmaos_mais_novos ?? 0 }}</div>
                    <div class="mb-2"><strong>Irmãos mesma idade:</strong> {{ $aluno->num_irmaos_mesma_idade ?? 0 }}</div>
                </div>
            </div>

            <div class="col-md-6 mb-3">
                <div class="mb-1">
                    <small class="text-muted" style="font-weight: 600;">Dados de Saúde</small>
                </div>
                <div style="background: #f8f9fa; padding: 15px; border-radius: 4px; font-size: 0.85rem;">
                    <div class="mb-2"><strong>Plano de Saúde:</strong> {{ $aluno->plano_saude ?? 'N/A' }}</div>
                    <div class="mb-2"><strong>Problema Crônico:</strong> {{ $aluno->problema_saude_cronico ?? 'N/A' }}</div>
                    <div class="mb-2"><strong>Alergias:</strong> {{ $aluno->alergias ?? 'N/A' }}</div>
                    <div class="mb-2"><strong>Diagnóstico Deficiência:</strong> {{ $aluno->diagnostico_deficiencia ?? 'N/A' }}</div>
                    <div class="mb-2"><strong>Dificuldades:</strong> {{ $aluno->dificuldade_motora_auditiva_visual_fala_emocional ?? 'N/A' }}</div>
                    <div class="mb-2"><strong>Tratamento Médico:</strong> {{ $aluno->tratamento_medico ?? 'N/A' }}</div>
                    <div class="mb-2"><strong>Medicação:</strong> {{ $aluno->medicacao ?? 'N/A' }}</div>
                    <div class="mb-2"><strong>Vacinas em Dia:</strong> 
                        @if($aluno->vacinas_em_dia === 1)
                            Sim
                        @elseif($aluno->vacinas_em_dia === 0)
                            Não
                        @else
                            N/A
                        @endif
                    </div>
                    <div class="mb-2"><strong>Contato Emergência:</strong> {{ $aluno->contato_emergencia ?? 'N/A' }}</div>
                    @if($aluno->outras_informacoes_saude)
                        <div class="mb-2"><strong>Outras Informações:</strong> {{ $aluno->outras_informacoes_saude }}</div>
                    @endif
                </div>
            </div>
        </div>

        <div class="row">
            <div class="col-md-12 mb-3">
                <div class="mb-1">
                    <small class="text-muted" style="font-weight: 600;">Indivíduos Autorizados</small>
                </div>
                <div style="background: #f8f9fa; padding: 15px; border-radius: 4px; font-size: 0.85rem;">
                    <div class="row">
                        <div class="col-md-4 mb-2">
                            <strong>1. Nome:</strong> {{ $aluno->individuo_autorizado_1_nome ?? 'N/A' }}<br>
                            <strong>Telefone:</strong> {{ $aluno->individuo_autorizado_1_telefone ?? 'N/A' }}
                        </div>
                        <div class="col-md-4 mb-2">
                            <strong>2. Nome:</strong> {{ $aluno->individuo_autorizado_2_nome ?? 'N/A' }}<br>
                            <strong>Telefone:</strong> {{ $aluno->individuo_autorizado_2_telefone ?? 'N/A' }}
                        </div>
                        <div class="col-md-4 mb-2">
                            <strong>3. Nome:</strong> {{ $aluno->individuo_autorizado_3_nome ?? 'N/A' }}<br>
                            <strong>Telefone:</strong> {{ $aluno->individuo_autorizado_3_telefone ?? 'N/A' }}
                        </div>
                    </div>
                </div>
            </div>
        </div>

        @if($aluno->observacoes_inscricao)
            <div class="row">
                <div class="col-md-12 mb-3">
                    <div class="mb-1">
                        <small class="text-muted" style="font-weight: 600;">Observações</small>
                    </div>
                    <div style="background: #fff3cd; padding: 15px; border-radius: 4px; font-size: 0.85rem;">
                        {{ $aluno->observacoes_inscricao }}
                    </div>
                </div>
            </div>
        @endif
    </div>
</div>

<!-- Modal para Rejeitar -->
<div class="modal fade" id="modalRejeitar" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Rejeitar Inscrição</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <form id="formRejeitar" method="POST">
                @csrf
                @method('POST')
                <div class="modal-body">
                    <p>Tem certeza que deseja rejeitar esta inscrição?</p>
                    <div class="mb-3">
                        <label for="observacoes_rejeitar" class="form-label">Observações <span class="text-danger">*</span></label>
                        <textarea class="form-control" id="observacoes_rejeitar" name="observacoes" rows="4" required minlength="10" placeholder="Explique o motivo da rejeição (mínimo 10 caracteres)"></textarea>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancelar</button>
                    <button type="submit" class="btn btn-danger">Rejeitar</button>
                </div>
            </form>
        </div>
    </div>
</div>

<script>
document.addEventListener('DOMContentLoaded', function() {
    // Aprovar inscrição
    document.querySelectorAll('.aprovar-btn').forEach(btn => {
        btn.addEventListener('click', function() {
            const id = this.getAttribute('data-id');
            if (confirm('Tem certeza que deseja aprovar esta inscrição?')) {
                fetch(`{{ url('admin/inscricoes') }}/${id}/aprovar`, {
                    method: 'POST',
                    headers: {
                        'Content-Type': 'application/json',
                        'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').content
                    },
                    body: JSON.stringify({})
                })
                .then(response => response.json())
                .then(data => {
                    if (data.success) {
                        alert(data.message);
                        window.location.href = '{{ route('admin.inscricoes.pendentes') }}';
                    }
                })
                .catch(error => {
                    console.error('Erro:', error);
                    alert('Erro ao aprovar inscrição');
                });
            }
        });
    });

    // Rejeitar inscrição
    document.querySelectorAll('.rejeitar-btn').forEach(btn => {
        btn.addEventListener('click', function() {
            const id = this.getAttribute('data-id');
            const form = document.getElementById('formRejeitar');
            form.action = `{{ url('admin/inscricoes') }}/${id}/rejeitar`;
            
            const modal = new bootstrap.Modal(document.getElementById('modalRejeitar'));
            modal.show();
        });
    });
});
</script>
@endsection
