@extends('layouts.app')

@section('title', 'Verificar Factura - SGE')

@section('content')
<div class="row">
    <div class="col-12">
        <div class="d-flex justify-content-between align-items-center mb-3">
            <h4 class="mb-0">
                <i class="bi bi-search text-primary me-2"></i>
                Verificar Factura
            </h4>
            <a href="{{ route('admin.gestao') }}" class="btn btn-secondary btn-sm">
                <i class="bi bi-arrow-left"></i> Voltar
            </a>
        </div>
    </div>
</div>

<div class="row justify-content-center">
    <div class="col-md-8">
        <div class="card">
            <div class="card-header bg-primary text-white">
                <h5 class="mb-0">Verificar Factura por Código</h5>
            </div>
            <div class="card-body">
                <form method="GET" action="{{ route('admin.invoice.verificar') }}">
                    <div class="mb-3">
                        <label for="codigo" class="form-label">Código de Verificação</label>
                        <input type="text" 
                               class="form-control @error('codigo') is-invalid @enderror" 
                               id="codigo" 
                               name="codigo" 
                               value="{{ $codigo ?? old('codigo') }}" 
                               required 
                               autofocus
                               placeholder="Digite o código de verificação da factura">
                        @error('codigo')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                        <small class="form-text text-muted">
                            Digite o código de verificação que aparece no rodapé da factura.
                        </small>
                    </div>

                    <button type="submit" class="btn btn-primary">
                        <i class="bi bi-search me-1"></i> Verificar
                    </button>
                </form>

                @if(isset($erro))
                    <div class="alert alert-danger mt-3">
                        <i class="bi bi-exclamation-triangle me-2"></i>
                        {{ $erro }}
                    </div>
                @endif

                @if(isset($invoice))
                    <hr class="my-4">
                    
                    <div class="card border-success">
                        <div class="card-header bg-success text-white">
                            <h5 class="mb-0">
                                <i class="bi bi-check-circle me-2"></i>
                                Factura Encontrada
                            </h5>
                        </div>
                        <div class="card-body">
                            <div class="row mb-3">
                                <div class="col-md-6">
                                    @if(isset($logotipoUrl) && $logotipoUrl)
                                        <img src="{{ $logotipoUrl }}" alt="Logotipo" style="max-height: 60px; margin-bottom: 10px;">
                                    @endif
                                    <p class="mb-0">
                                        <strong>{{ \App\Models\Configuracao::get('escola', 'ESCOLA PRIMARIA E COMPLETA SGE') }}</strong>
                                    </p>
                                </div>
                                <div class="col-md-6 text-end">
                                    <h5 class="mb-2">FACTURA</h5>
                                    <p class="mb-1"><strong>Nº:</strong> {{ $invoice->numero_factura }}</p>
                                    <p class="mb-1"><strong>Data:</strong> {{ $invoice->data_emissao->format('d/m/Y') }}</p>
                                    @if($invoice->status === 'PAGA')
                                        <span class="badge bg-success">Paga</span>
                                    @else
                                        <span class="badge bg-warning">Pendente</span>
                                    @endif
                                </div>
                            </div>

                            <hr>

                            <div class="mb-3">
                                <p class="mb-1"><strong>Aluno:</strong> {{ $invoice->aluno->user->name }}</p>
                                <p class="mb-0"><strong>Código:</strong> {{ $invoice->aluno->codigo_estudante }}</p>
                            </div>

                            <div class="table-responsive">
                                <table class="table table-bordered table-sm">
                                    <thead>
                                        <tr>
                                            <th>Descrição</th>
                                            <th class="text-end">Valor</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @if($invoice->itens)
                                            @foreach($invoice->itens as $item)
                                                <tr>
                                                    <td>{{ $item['descricao'] ?? 'Mensalidade' }}</td>
                                                    <td class="text-end">{{ number_format($item['valor'] ?? $invoice->valor, 2, ',', '.') }} MT</td>
                                                </tr>
                                            @endforeach
                                        @else
                                            <tr>
                                                <td>{{ $invoice->descricao ?? 'Mensalidade' }}</td>
                                                <td class="text-end">{{ number_format($invoice->valor, 2, ',', '.') }} MT</td>
                                            </tr>
                                        @endif
                                    </tbody>
                                    <tfoot>
                                        <tr>
                                            <th class="text-end">Total</th>
                                            <th class="text-end">{{ number_format($invoice->valor, 2, ',', '.') }} MT</th>
                                        </tr>
                                    </tfoot>
                                </table>
                            </div>

                            @if($invoice->payment)
                                <div class="mt-3">
                                    <h6>Informações de Pagamento</h6>
                                    <p class="mb-1">
                                        <strong>Método:</strong> {{ $invoice->payment->metodo === 'MPESA' ? 'M-Pesa' : 'Emola' }}<br>
                                        <strong>Referência:</strong> {{ $invoice->payment->reference }}<br>
                                        @if($invoice->payment->data_pagamento)
                                            <strong>Data Pagamento:</strong> {{ $invoice->payment->data_pagamento->format('d/m/Y H:i') }}
                                        @endif
                                    </p>
                                </div>
                            @endif

                            <div class="mt-3 pt-3 border-top text-center">
                                <p class="text-muted mb-1" style="font-size: 0.85rem;">Documento gerado automaticamente pelo Sistema de Gestão Escolar</p>
                                <p class="mb-0" style="font-size: 0.9rem;">
                                    <strong>Código de Verificação:</strong> 
                                    <span class="badge bg-secondary">{{ $invoice->codigo_verificacao }}</span>
                                </p>
                            </div>
                        </div>
                    </div>
                @endif
            </div>
        </div>
    </div>
</div>
@endsection

