@extends('layouts.app')

@section('title', 'Redefinir Senha - SGE')

@section('content')
<div class="row">
    <div class="col-12">
        <div class="d-flex justify-content-between align-items-center mb-2" style="border-bottom: 1px solid #dee2e6; padding-bottom: 8px;">
            <h5 class="mb-0" style="font-weight: 600;">
                <i class="bi bi-key-fill text-warning me-2"></i>
                Redefinir Senha
            </h5>
            <a href="{{ route('admin.password-reset.index') }}" class="btn btn-sm btn-secondary">
                <i class="bi bi-arrow-left"></i> Voltar
            </a>
        </div>

        <div class="card">
            <div class="card-body">
                <div class="alert alert-warning">
                    <i class="bi bi-exclamation-triangle me-2"></i>
                    <strong>Atenção:</strong> Você está prestes a redefinir a senha de <strong>{{ $user->name }}</strong>.
                    O usuário precisará alterar a senha no próximo login.
                </div>

                <div class="mb-3">
                    <strong>Informações do Usuário:</strong>
                    <ul class="mt-2">
                        <li><strong>Nome:</strong> {{ $user->name }}</li>
                        <li><strong>Email:</strong> {{ $user->email }}</li>
                        <li><strong>Tipo:</strong> 
                            @php
                                $tipoLabels = [
                                    'superadmin' => 'Superadmin',
                                    'admin' => 'Admin',
                                    'funcionario' => 'Funcionário',
                                    'professor' => 'Professor',
                                    'aluno' => 'Aluno',
                                ];
                                $tipoLabel = $tipoLabels[$user->tipo] ?? ucfirst($user->tipo);
                            @endphp
                            {{ $tipoLabel }}
                        </li>
                        @if($user->aluno)
                            <li><strong>Código de Estudante:</strong> {{ $user->aluno->codigo_estudante }}</li>
                        @elseif($user->professor)
                            <li><strong>Número de Funcionário:</strong> {{ $user->professor->numero_funcionario }}</li>
                        @elseif($user->funcionario)
                            <li><strong>Número de Funcionário:</strong> {{ $user->funcionario->numero_funcionario }}</li>
                        @endif
                    </ul>
                </div>

                <form method="POST" action="{{ route('admin.password-reset.reset', $user) }}">
                    @csrf

                    <div class="mb-3">
                        <label for="password" class="form-label">Nova Senha</label>
                        <input type="password" 
                               class="form-control @error('password') is-invalid @enderror" 
                               id="password" 
                               name="password" 
                               required 
                               minlength="8">
                        @error('password')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                        <small class="form-text text-muted">
                            A senha deve ter no mínimo 8 caracteres.
                        </small>
                    </div>

                    <div class="mb-3">
                        <label for="password_confirmation" class="form-label">Confirmar Nova Senha</label>
                        <input type="password" 
                               class="form-control" 
                               id="password_confirmation" 
                               name="password_confirmation" 
                               required 
                               minlength="8">
                    </div>

                    <div class="d-flex gap-2">
                        <button type="submit" class="btn btn-warning">
                            <i class="bi bi-key-fill"></i> Redefinir Senha
                        </button>
                        <a href="{{ route('admin.password-reset.index') }}" class="btn btn-secondary">
                            Cancelar
                        </a>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
@endsection

