<!DOCTYPE html>
<html lang="pt">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>{{ $titulo ?? 'Folha de Salário' }} - {{ $mesNome }}/{{ $ano }}</title>
    <style>
        @media print {
            .no-print { display: none !important; }
            body { margin: 0; padding: 0; }
        }
        .btn-print { display: none; }
        body { font-family: Arial, sans-serif; font-size: 12px; margin: 20px; color: #333; }
        .header { text-align: center; margin-bottom: 30px; border-bottom: 2px solid #333; padding-bottom: 15px; }
        table { width: 100%; border-collapse: collapse; margin-bottom: 20px; }
        table th, table td { border: 1px solid #333; padding: 8px; text-align: left; }
        table th { background-color: #333; color: white; font-weight: bold; }
        table tr:nth-child(even) { background-color: #f9f9f9; }
        .text-right { text-align: right; }
        .text-center { text-align: center; }
        .total-row { font-weight: bold; background-color: #e8e8e8 !important; }
        .info-box { margin-bottom: 20px; padding: 10px; background-color: #f5f5f5; border: 1px solid #ddd; }
        .footer { margin-top: 30px; padding-top: 15px; border-top: 1px solid #333; text-align: center; font-size: 10px; }
    </style>
</head>
<body>
    @if(!isset($logotipoBase64) && isset($logotipoUrl))
        <button class="btn-print no-print" onclick="window.print()" style="position: fixed; top: 20px; right: 20px; padding: 10px 20px; background-color: #007bff; color: white; border: none; border-radius: 5px; cursor: pointer; font-size: 14px;">
            Imprimir
        </button>
    @endif

    <div class="header">
        <div style="text-align: center; margin-bottom: 15px;">
            @if($logotipoBase64)
                <img src="{{ $logotipoBase64 }}" alt="Logotipo" style="max-height: 80px; max-width: 200px; margin-bottom: 10px;">
            @elseif(isset($logotipoUrl) && $logotipoUrl)
                <img src="{{ $logotipoUrl }}" alt="Logotipo" style="max-height: 80px; max-width: 200px; margin-bottom: 10px;">
            @endif
            <div style="text-align: center;">
                <h2 style="margin: 5px 0; font-size: 16px; font-weight: normal;">{{ $titulo ?? 'FOLHA DE SALÁRIO' }}</h2>
                <h3 style="margin: 5px 0; font-size: 14px; font-weight: normal;">{{ $mesNome }} de {{ $ano }}</h3>
            </div>
        </div>

        @if(isset($entidadeEspecifica) && $entidadeEspecifica)
            <p style="margin: 10px 0 0 0;">
                <strong>{{ $entidadeLabel ?? 'Funcionário' }}:</strong>
                {{ $entidadeEspecifica->nome ?? ($entidadeEspecifica->user->name ?? '-') }}
            </p>
        @else
            <p style="margin: 10px 0 0 0;"><strong>Todos</strong></p>
        @endif
    </div>

    <div class="info-box">
        <p><strong>Período:</strong> {{ $mesNome }} de {{ $ano }}</p>
        <p><strong>Data de Emissão:</strong> {{ now()->format('d/m/Y H:i') }}</p>
        <p><strong>Total de Registos:</strong> {{ $payments->count() }}</p>
    </div>

    <table>
        <thead>
            <tr>
                <th style="width: 3%;">#</th>
                <th style="width: 12%;">Código</th>
                <th style="width: 22%;">Nome</th>
                <th style="width: 15%;">Cargo</th>
                <th style="width: 12%;" class="text-right">Valor Bruto</th>
                <th style="width: 10%;" class="text-right">INSS (3%)</th>
                <th style="width: 10%;" class="text-right">IRPS</th>
                <th style="width: 12%;" class="text-right">Valor Líquido</th>
                <th style="width: 8%;">Data Pagamento</th>
            </tr>
        </thead>
        <tbody>
            @foreach($payments as $index => $payment)
                @php
                    $isServico = ($tipoEntidade ?? 'servico') === 'servico';
                    $ent = $isServico ? $payment->funcionarioServico : $payment->funcionario;
                    $nome = $isServico
                        ? ($ent ? ($ent->nome ?? '-') : '-')
                        : ($ent && $ent->user ? $ent->user->name : ($ent ? 'Usuário não associado' : '-'));
                    $codigo = $isServico
                        ? ('#' . ($ent ? $ent->id : $payment->funcionario_servico_id))
                        : ($ent ? ($ent->numero_funcionario ?? ('#' . $payment->funcionario_id)) : ('#' . $payment->funcionario_id));
                    $cargo = $ent ? ($ent->cargo ?? '-') : '-';
                    $liq = $payment->valor_liquido ?? ((float)$payment->valor_total - (float)($payment->inss ?? 0) - (float)($payment->irps ?? 0));
                @endphp
                <tr>
                    <td class="text-center">{{ $index + 1 }}</td>
                    <td>{{ $codigo }}</td>
                    <td>{{ $nome }}</td>
                    <td>{{ $cargo }}</td>
                    <td class="text-right">{{ number_format($payment->valor_total, 2, ',', '.') }} MT</td>
                    <td class="text-right">{{ number_format($payment->inss ?? 0, 2, ',', '.') }} MT</td>
                    <td class="text-right">{{ number_format($payment->irps ?? 0, 2, ',', '.') }} MT</td>
                    <td class="text-right"><strong>{{ number_format($liq, 2, ',', '.') }} MT</strong></td>
                    <td class="text-center">
                        @if($payment->data_pagamento)
                            {{ \Carbon\Carbon::parse($payment->data_pagamento)->format('d/m/Y') }}
                        @else
                            -
                        @endif
                    </td>
                </tr>
            @endforeach
        </tbody>
        <tfoot>
            <tr class="total-row">
                <td colspan="4" class="text-right"><strong>TOTAL GERAL:</strong></td>
                <td class="text-right"><strong>{{ number_format($payments->sum('valor_total'), 2, ',', '.') }} MT</strong></td>
                <td class="text-right"><strong>{{ number_format($payments->sum('inss'), 2, ',', '.') }} MT</strong></td>
                <td class="text-right"><strong>{{ number_format($payments->sum('irps'), 2, ',', '.') }} MT</strong></td>
                <td class="text-right"><strong>{{ number_format($payments->sum(function($p) { return $p->valor_liquido ?? ((float)$p->valor_total - (float)($p->inss ?? 0) - (float)($p->irps ?? 0)); }), 2, ',', '.') }} MT</strong></td>
                <td></td>
            </tr>
        </tfoot>
    </table>

    <div class="footer">
        <p>Documento gerado em {{ now()->format('d/m/Y H:i') }} pelo Sistema Integrado de Gestão Escolar (SIGE)</p>
        <p>Este documento é uma cópia autêntica da folha de salário</p>
    </div>
</body>
</html>

