@extends('layouts.app')

@section('title', 'Criar Turma - SGE')

@section('content')
<div class="row">
    <div class="col-md-6 mx-auto">
        <div class="d-flex justify-content-between align-items-center mb-3">
            <h5 class="mb-0">Nova Turma</h5>
            <a href="{{ route('admin.turmas.index') }}" class="btn btn-sm btn-secondary">
                <i class="bi bi-arrow-left"></i> Voltar
            </a>
        </div>
        
        <div class="card">
            <div class="card-body">
                <form action="{{ route('admin.turmas.store') }}" method="POST">
                    @csrf

                    <div class="mb-3">
                        <label for="nivel_ensino" class="form-label">Nível de Ensino <span class="text-danger">*</span></label>
                        <select class="form-select form-select-sm @error('nivel_ensino') is-invalid @enderror"
                                id="nivel_ensino" name="nivel_ensino" required>
                            <option value="">Selecione o nível...</option>
                            <option value="PRIMARIO" {{ old('nivel_ensino', 'PRIMARIO') === 'PRIMARIO' ? 'selected' : '' }}>Primário</option>
                            <option value="SECUNDARIO" {{ old('nivel_ensino') === 'SECUNDARIO' ? 'selected' : '' }}>Secundário</option>
                        </select>
                        @error('nivel_ensino')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>

                    <div class="mb-3">
                        <label for="codigo" class="form-label">Classe <span class="text-danger">*</span></label>
                        <select class="form-select form-select-sm @error('codigo') is-invalid @enderror" 
                                id="codigo" name="codigo" required>
                            <option value="">Selecione a classe...</option>
                        </select>
                        @error('codigo')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>

                    <div class="mb-3">
                        <label for="nome" class="form-label">Turma <span class="text-danger">*</span></label>
                        <select class="form-select form-select-sm @error('nome') is-invalid @enderror" 
                                id="nome" name="nome" required>
                            <option value="">Selecione a turma...</option>
                            @foreach(['A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L'] as $letra)
                                <option value="{{ $letra }}" {{ old('nome') == $letra ? 'selected' : '' }}>
                                    Turma {{ $letra }}
                                </option>
                            @endforeach
                        </select>
                        @error('nome')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>

                    <div class="mb-3">
                        <label for="ano_letivo_id" class="form-label">Ano Letivo <span class="text-danger">*</span></label>
                        <select class="form-select form-select-sm @error('ano_letivo_id') is-invalid @enderror" 
                                id="ano_letivo_id" name="ano_letivo_id" required>
                            <option value="">Selecione...</option>
                            @foreach($anoLetivos as $ano)
                                <option value="{{ $ano->id }}" {{ old('ano_letivo_id', $anoLetivoAtivo?->id) == $ano->id ? 'selected' : '' }}>
                                    {{ $ano->ano_inicial }}
                                </option>
                            @endforeach
                        </select>
                        @error('ano_letivo_id')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>

                    <div class="mb-3">
                        <label for="capacidade_maxima" class="form-label">Capacidade Máxima</label>
                        <input type="number" class="form-control form-control-sm @error('capacidade_maxima') is-invalid @enderror" 
                               id="capacidade_maxima" name="capacidade_maxima" 
                               value="{{ old('capacidade_maxima', 35) }}" min="1">
                        @error('capacidade_maxima')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>

                    <div class="mb-3 form-check">
                        <input class="form-check-input" type="checkbox" id="Activa" name="Activa" 
                               {{ old('Activa', true) ? 'checked' : '' }}>
                        <label class="form-check-label" for="Activa">
                            Turma Activa
                        </label>
                    </div>

                    <div class="d-flex gap-2">
                        <button type="submit" class="btn btn-primary btn-sm">
                            <i class="bi bi-check-circle"></i> Criar
                        </button>
                        <a href="{{ route('admin.turmas.index') }}" class="btn btn-secondary btn-sm">Cancelar</a>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
<script>
function initTurmaCreateForm() {
    const nivelSelect = document.getElementById('nivel_ensino');
    const classeSelect = document.getElementById('codigo');
    if (!nivelSelect || !classeSelect) return;

    const oldCodigo = @json(old('codigo'));

    function renderClasses() {
        const nivel = nivelSelect.value || 'PRIMARIO';
        const range = nivel === 'SECUNDARIO' ? { start: 7, end: 12 } : { start: 1, end: 6 };

        classeSelect.innerHTML = '<option value="">Selecione a classe...</option>';
        for (let i = range.start; i <= range.end; i++) {
            const value = `${i}ª Classe`;
            const option = document.createElement('option');
            option.value = value;
            option.textContent = value;
            if (oldCodigo === value) {
                option.selected = true;
            }
            classeSelect.appendChild(option);
        }
    }

    nivelSelect.addEventListener('change', function() {
        renderClasses();
    });

    renderClasses();
}

window.initTurmaCreateForm = initTurmaCreateForm;

document.addEventListener('DOMContentLoaded', function() {
    initTurmaCreateForm();
});
</script>
@endsection
