@extends('layouts.app')

@section('title', 'Dashboard - Estudante')

@section('content')
@if($isIncapacitado ?? false)
    <div class="row mb-3">
        <div class="col-12">
            <div class="alert alert-danger">
                <i class="bi bi-exclamation-triangle-fill me-2"></i>
                <strong>STATUS: INCAPACITADO</strong><br>
                Você está bloqueado devido a falta de 3 ou mais pagamentos. 
                Você não pode acessar notas, trabalhos, horários e outras funcionalidades até regularizar sua situação financeira.
                <br><br>
                <strong>Apenas a área de pagamentos está disponível.</strong>
                <a href="{{ route('aluno.financeiro') }}" class="btn btn-danger btn-sm mt-2">
                    <i class="bi bi-cash-coin"></i> Regularizar Pagamentos
                </a>
            </div>
        </div>
    </div>
@endif

<div class="row">
    <div class="col-12">
        <div class="d-flex justify-content-between align-items-center mb-3">
            <h4 class="mb-0">
                <i class="bi bi-calendar-week text-primary me-2"></i>
                Meus Horários
            </h4>
            <div>
                @php
                    $anoExibir = date('Y');
                    if ($anoLetivoAtivo) {
                        $anoRaw = $anoLetivoAtivo->getRawOriginal('ano');
                        if (strpos($anoRaw, '/') !== false) {
                            $anoExibir = explode('/', $anoRaw)[1];
                        } else {
                            $anoExibir = $anoRaw;
                        }
                    }
                @endphp
                <span class="badge bg-primary">{{ $anoExibir }}</span>
            </div>
        </div>
    </div>
</div>

@if($dividas > 0 && !($isIncapacitado ?? false))
    <div class="row mb-3">
        <div class="col-12">
            <div class="alert alert-warning">
                <i class="bi bi-exclamation-triangle me-2"></i>
                <strong>Atenção:</strong> Você possui dívidas pendentes no valor de 
                <strong>{{ number_format($dividas, 2, ',', '.') }} MT</strong>.
                <a href="{{ route('aluno.financeiro') }}" class="alert-link">Ver detalhes</a>
            </div>
        </div>
    </div>
@endif

<!-- Horários -->
@if($turmas->count() > 0)
    @foreach($turmas as $turma)
        @php
            $horariosTurma = $horarios->filter(function($h) use ($turma) {
                return $h->turma_id == $turma->id;
            });
            
            // Obter todos os horários únicos para esta turma
            $horariosUnicos = $horariosTurma->map(function($h) {
                return [
                    'inicio' => \Carbon\Carbon::parse($h->hora_inicio)->format('H:i'),
                    'fim' => \Carbon\Carbon::parse($h->hora_fim)->format('H:i'),
                    'hora_inicio' => $h->hora_inicio,
                ];
            })->unique(function($item) {
                return $item['inicio'];
            })->sortBy('hora_inicio')->values();
            
            // Criar estrutura de grade
            $grade = [];
            $diasSemana = ['Segunda', 'Terça', 'Quarta', 'Quinta', 'Sexta'];
            
            foreach ($horariosUnicos as $horarioUnico) {
                $horaFormatada = $horarioUnico['inicio'];
                $horaCarbon = \Carbon\Carbon::parse($horarioUnico['hora_inicio']);
                $grade[$horaFormatada] = [];
                
                foreach ($diasSemana as $dia) {
                    $horario = $horariosTurma->first(function($h) use ($dia, $horaCarbon) {
                        $horaInicio = \Carbon\Carbon::parse($h->hora_inicio);
                        return $h->dia_semana === $dia && 
                               $horaInicio->format('H:i') === $horaCarbon->format('H:i');
                    });
                    
                    $grade[$horaFormatada][$dia] = $horario;
                }
            }
        @endphp
        
        <div class="card mb-4">
            <div class="card-header bg-white">
                <h5 class="mb-0">
                    <i class="bi bi-calendar-week text-primary me-2"></i>
                    {{ $turma->nome }} - {{ $turma->codigo }}
                </h5>
            </div>
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table table-bordered table-sm text-center" style="font-size: 0.9rem;">
                        <thead class="table-light">
                            <tr>
                                <th style="width: 120px;">Horário</th>
                                @foreach($diasSemana as $dia)
                                    <th>{{ $dia }}</th>
                                @endforeach
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($grade as $hora => $aulas)
                                <tr>
                                    <td class="fw-bold">
                                        @php
                                            $horarioUnico = $horariosUnicos->first(function($h) use ($hora) {
                                                return $h['inicio'] === $hora;
                                            });
                                        @endphp
                                        {{ $hora }} - {{ $horarioUnico['fim'] ?? '' }}
                                    </td>
                                    @foreach($diasSemana as $dia)
                                        <td>
                                            @if(isset($aulas[$dia]) && $aulas[$dia])
                                                @php
                                                    $aula = $aulas[$dia];
                                                @endphp
                                                <div class="p-2" style="background-color: #f8f9fa; border-radius: 4px;">
                                                    <strong class="d-block">{{ $aula->disciplina->nome ?? '-' }}</strong>
                                                    <small class="text-muted d-block">
                                                        @if($aula->professor && $aula->professor->user)
                                                            {{ $aula->professor->user->name }}
                                                        @else
                                                            -
                                                        @endif
                                                    </small>
                                                    @if($aula->sala)
                                                        <small class="text-info d-block">
                                                            <i class="bi bi-door-open"></i> {{ $aula->sala }}
                                                        </small>
                                                    @endif
                                                </div>
                                            @else
                                                <span class="text-muted">-</span>
                                            @endif
                                        </td>
                                    @endforeach
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    @endforeach
@else
    <div class="alert alert-info text-center">
        <i class="bi bi-calendar-x display-4 d-block mb-3"></i>
        <h5>Nenhum horário disponível</h5>
        <p class="text-muted mb-0">Você ainda não está matriculado em nenhuma turma ou não há horários cadastrados.</p>
    </div>
@endif
@endsection

