<!DOCTYPE html>
<html lang="pt">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Folheto de Aproveitamento - {{ $aluno->user->name }}</title>
    <style>
        * {
            box-sizing: border-box;
            margin: 0;
            padding: 0;
            font-family: 'Times New Roman', Times, serif;
        }
        
        @page {
            size: A4;
            margin: 0;
        }
        
        @media print {
            @page {
                margin: 0;
                size: A4;
            }
            
            html, body {
                margin: 0;
                padding: 0;
                width: 210mm;
                height: auto;
                background: white;
            }
            
            .no-print {
                display: none !important;
            }
        }
        
        body {
            background-color: #f5f5f5;
            color: #000;
            line-height: 1.4;
            padding: 20px;
        }
        
        .document {
            background-color: white;
            padding: 20px;
            max-width: 100%;
            width: 210mm;
            min-height: 297mm;
            box-sizing: border-box;
            margin: 0 auto;
        }
        
        .header {
            margin-bottom: 15px;
            text-align: center;
            line-height: 1.3;
        }
        
        .header img {
            max-height: 120px;
            margin-bottom: 5px;
        }
        
        .header-line {
            font-size: 11pt;
            margin-bottom: 3px;
        }
        
        .escola-nome {
            font-weight: bold;
        }
        
        .info-header {
            font-size: 9pt;
            margin-top: 5px;
        }
        
        table {
            width: 100%;
            border-collapse: collapse;
            font-size: 9pt;
            margin-bottom: 20px;
        }
        
        table th,
        table td {
            border: 1px solid #000;
            padding: 4px;
            text-align: center;
        }
        
        table th {
            background-color: #f0f0f0;
            font-weight: bold;
        }
        
        .col-numero {
            width: 30px;
        }
        
        .col-nome {
            width: auto;
            text-align: left;
            padding-left: 8px;
        }
        
        .col-genero {
            width: 40px;
        }
        
        .col-disciplina {
            width: 50px;
        }
        
        .col-media {
            width: 60px;
        }
        
        .col-classificacao {
            width: 100px;
        }
        
        .select-trimestre {
            margin-bottom: 20px;
            padding: 15px;
            background: #f8f9fa;
            border-radius: 5px;
        }
        
        .select-trimestre form {
            display: flex;
            gap: 10px;
            align-items: center;
            flex-wrap: wrap;
        }
        
        .select-trimestre label {
            font-weight: bold;
        }
        
        .select-trimestre select {
            padding: 5px 10px;
            border: 1px solid #ddd;
            border-radius: 4px;
        }
        
        .btn-print {
            padding: 8px 15px;
            background: #007bff;
            color: white;
            border: none;
            border-radius: 4px;
            cursor: pointer;
            text-decoration: none;
            display: inline-block;
        }
        
        .btn-print:hover {
            background: #0056b3;
        }
    </style>
</head>
<body>
    <div class="document">
        <div class="select-trimestre no-print">
            <form method="GET" style="display: flex; gap: 10px; align-items: center; flex-wrap: wrap;">
                <label for="trimestre"><strong>Selecionar Trimestre:</strong></label>
                <select name="trimestre" id="trimestre" onchange="this.form.submit()" style="padding: 5px;">
                    @foreach(\App\Models\Trimestre::where('ano_letivo_id', $anoLetivoAtivo->id)->orderBy('numero')->get() as $t)
                        <option value="{{ $t->numero }}" {{ $trimestre->numero == $t->numero ? 'selected' : '' }}>
                            {{ $t->numero }}º Trimestre
                        </option>
                    @endforeach
                </select>
                <button type="button" class="btn-print" onclick="window.print()">
                    <i class="bi bi-printer"></i> Imprimir
                </button>
            </form>
        </div>
        
        <div class="header">
            @if(!empty($logotipoBase64))
                <img src="{{ $logotipoBase64 }}" alt="Logotipo da Escola">
            @endif
            <div class="header-line">Aproveitamento Pedagógico do {{ $trimestre->numero }}º Trimestre</div>
            <div class="info-header">
                @if($turma->codigo)
                    {{ strtoupper($turma->codigo) }}
                @endif
                Turma: {{ strtoupper($turma->nome) }} | Ano Lectivo: {{ $anoLetivoAtivo->ano_inicial ?? $anoLetivoAtivo->ano }}
            </div>
        </div>
        
        @if($disciplinas->count() > 0)
            <table>
                <thead>
                    <tr>
                        <th class="col-numero">Nº</th>
                        <th class="col-nome">Nome Completo</th>
                        <th class="col-genero">Gén.</th>
                        @foreach($disciplinas as $disciplina)
                            @php
                                $abreviacoes = [
                                    'Português' => 'Port.',
                                    'Matemática' => 'Mat.',
                                    'Ciências Naturais' => 'C. Nat.',
                                    'Ciências Sociais' => 'C. Soc.',
                                    'Educação Visual e Ofícios' => 'EVO',
                                    'Educação Física' => 'E. Fis.',
                                    'Física' => 'Físi',
                                    'História' => 'HIST',
                                    'Inglês' => 'Ingl.',
                                    'Química' => 'Quím.',
                                    'Biologia' => 'Biol.',
                                ];
                                $abrev = $abreviacoes[$disciplina->nome] ?? strtoupper(substr($disciplina->nome, 0, 5));
                            @endphp
                            <th class="col-disciplina">{{ $abrev }}</th>
                        @endforeach
                        <th class="col-media">Média Trimestral</th>
                        <th class="col-classificacao">Classificação</th>
                    </tr>
                </thead>
                <tbody>
                    <tr>
                        <td>{{ $numeroAluno ?? '-' }}</td>
                        <td class="col-nome" style="text-align: left; padding-left: 8px;">{{ strtoupper($aluno->user->name) }}</td>
                        <td>{{ $aluno->genero == 'M' ? 'M' : ($aluno->genero == 'F' ? 'F' : '-') }}</td>
                        @foreach($disciplinas as $disciplina)
                            <td>
                                {{ isset($mediasPorDisciplina[$disciplina->id]) && $mediasPorDisciplina[$disciplina->id] !== null ? $mediasPorDisciplina[$disciplina->id] : '-' }}
                            </td>
                        @endforeach
                        <td><strong>{{ $mediaTrimestralGeral ?? '-' }}</strong></td>
                        <td><strong>{{ $classificacaoMedia }}</strong></td>
                    </tr>
                </tbody>
            </table>
        @else
            <div style="padding: 20px; text-align: center; color: #666;">
                <p>Nenhuma disciplina encontrada para esta turma no ano letivo ativo.</p>
            </div>
        @endif
    </div>
</body>
</html>
