@extends('layouts.app')

@section('title', 'Meu Perfil - Estudante')

@section('content')
<div class="row">
    <div class="col-md-8 mx-auto">
        <div class="card border-0 shadow-sm">
            <div class="card-header bg-white">
                <h4 class="mb-0">
                    <i class="bi bi-person-circle text-primary me-2"></i>
                    Meu Perfil
                </h4>
            </div>
            <div class="card-body">
                <div class="row mb-3">
                    <div class="col-md-4 text-center">
                        @if($aluno->foto)
                            <img src="{{ asset('storage/' . $aluno->foto) }}" alt="Foto" class="img-thumbnail" style="max-width: 150px;">
                        @else
                            <div class="bg-secondary rounded-circle d-inline-flex align-items-center justify-content-center" style="width: 150px; height: 150px;">
                                <i class="bi bi-person text-white" style="font-size: 4rem;"></i>
                            </div>
                        @endif
                    </div>
                    <div class="col-md-8">
                        <h3>{{ $aluno->user->name }}</h3>
                        <p class="text-muted mb-2">
                            <i class="bi bi-envelope me-2"></i>{{ $aluno->user->email ?? 'N/A' }}
                        </p>
                        <p class="text-muted mb-2">
                            <i class="bi bi-123 me-2"></i>Código: {{ $aluno->codigo_estudante ?? 'N/A' }}
                        </p>
                        @if($aluno->telefone)
                            <p class="text-muted mb-2">
                                <i class="bi bi-telephone me-2"></i>{{ $aluno->telefone }}
                            </p>
                        @endif
                    </div>
                </div>

                <hr>

                <h5 class="mb-3">Informações Pessoais</h5>
                <div class="row mb-3">
                    <div class="col-md-6">
                        <strong>Data de Nascimento:</strong><br>
                        <span class="text-muted">{{ $aluno->data_nascimento ? $aluno->data_nascimento->format('d/m/Y') : 'N/A' }}</span>
                    </div>
                    <div class="col-md-6">
                        <strong>Género:</strong><br>
                        <span class="text-muted">{{ $aluno->genero == 'M' ? 'Masculino' : ($aluno->genero == 'F' ? 'Feminino' : 'N/A') }}</span>
                    </div>
                </div>

                @if($aluno->endereco)
                    <div class="mb-3">
                        <strong>Endereço:</strong><br>
                        <span class="text-muted">{{ $aluno->endereco }}</span>
                    </div>
                @endif

                <hr>

                <h5 class="mb-3">Turmas Atuais</h5>
                @if($turmas->count() > 0)
                    <div class="list-group">
                        @foreach($turmas as $turma)
                            <div class="list-group-item">
                                <strong>{{ $turma->codigo }} - {{ $turma->nome }}</strong>
                            </div>
                        @endforeach
                    </div>
                @else
                    <p class="text-muted">Nenhuma turma atribuída</p>
                @endif
            </div>
        </div>
    </div>
</div>
@endsection

