@extends('layouts.app')

@section('title', 'Trabalhos/TPCs - Estudante')

@section('content')
@php
    use Illuminate\Support\Facades\Storage;
@endphp
<div class="row">
    <div class="col-12">
        <div class="d-flex justify-content-between align-items-center mb-3">
            <h4 class="mb-0">
                <i class="bi bi-file-earmark-text text-info me-2"></i>
                Trabalhos e TPCs
            </h4>
            <div>
                <span class="badge bg-primary">{{ $anoLetivoAtivo->ano ?? 'N/A' }}</span>
            </div>
        </div>
    </div>
</div>

@if($trabalhos->count() > 0)
    <div class="table-responsive">
        <table class="table table-bordered table-hover">
            <thead class="table-light">
                <tr>
                    <th>Título</th>
                    <th>Disciplina</th>
                    <th>Turma</th>
                    <th>Professor</th>
                    <th>Data Entrega</th>
                    <th>Acções</th>
                </tr>
            </thead>
            <tbody>
                @foreach($trabalhos as $trabalho)
                    <tr>
                        <td>{{ $trabalho->titulo }}</td>
                        <td>{{ $trabalho->disciplina->nome }}</td>
                        <td>{{ $trabalho->turma->codigo }} - {{ $trabalho->turma->nome }}</td>
                        <td>{{ $trabalho->professor->user->name ?? 'N/A' }}</td>
                        <td>{{ $trabalho->data_entrega->format('d/m/Y') }}</td>
                        <td>
                            @if($trabalho->arquivo)
                                <div class="btn-group btn-group-sm" role="group">
                                    <a href="{{ route('aluno.trabalhos.visualizar', $trabalho) }}" target="_blank" class="btn btn-outline-info" title="Ver">
                                        <i class="bi bi-eye"></i>
                                    </a>
                                    <a href="{{ Storage::url($trabalho->arquivo) }}" download class="btn btn-outline-success" title="Download">
                                        <i class="bi bi-download"></i>
                                    </a>
                                </div>
                            @else
                                <span class="text-muted">-</span>
                            @endif
                        </td>
                    </tr>
                @endforeach
            </tbody>
        </table>
    </div>
@else
    <div class="alert alert-info text-center">
        <i class="bi bi-inbox display-4 d-block mb-3"></i>
        Nenhum trabalho atribuído ainda.
    </div>
@endif
@endsection

