@extends('layouts.app')

@section('title', 'Redefinir Senha - SGE')

@section('content')
<style>
    .login-container {
        min-height: calc(100vh - 200px);
        display: flex;
        align-items: center;
        justify-content: center;
    }
</style>
<div class="login-container">
    <div class="row justify-content-center w-100">
        <div class="col-md-4">
            <div class="card">
                <div class="card-header bg-primary-custom text-white">
                    <h4 class="mb-0">Redefinir Senha</h4>
                </div>
                <div class="card-body">
                    <form method="POST" action="{{ route('password.update') }}">
                        @csrf
                        <input type="hidden" name="token" value="{{ $token }}">

                        <div class="mb-3">
                            <label for="email" class="form-label">Email</label>
                            <input type="email" class="form-control @error('email') is-invalid @enderror" 
                                   id="email" name="email" value="{{ old('email') }}" required autofocus>
                            @error('email')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>

                        <div class="mb-3">
                            <label for="password" class="form-label">Nova Senha</label>
                            <input type="password" class="form-control @error('password') is-invalid @enderror" 
                                   id="password" name="password" required minlength="8">
                            @error('password')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                            <small class="form-text text-muted">
                                A senha deve ter no mínimo 8 caracteres.
                            </small>
                        </div>

                        <div class="mb-3">
                            <label for="password_confirmation" class="form-label">Confirmar Nova Senha</label>
                            <input type="password" class="form-control" 
                                   id="password_confirmation" name="password_confirmation" required minlength="8">
                        </div>

                        <button type="submit" class="btn btn-primary-custom w-100">Redefinir Senha</button>
                    </form>

                    <div class="mt-3 text-center">
                        <a href="{{ route('login') }}">Voltar para o login</a>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

