@extends('layouts.app')

@section('title', 'Estatísticas de Avaliações')

@section('content')
<div class="row">
    <div class="col-12">
        <div class="d-flex justify-content-between align-items-center mb-3">
            <h2>Estatísticas de Aprovação/Reprovação</h2>
            <a href="{{ route('avaliacoes.index') }}" class="btn btn-secondary btn-sm">Voltar</a>
        </div>

        <div class="card mb-3">
            <div class="card-body">
                <form method="GET" action="{{ route('avaliacoes.estatisticas') }}" class="row g-3">
                    <div class="col-md-3">
                        <label for="turma_id" class="form-label">Turma</label>
                        <select name="turma_id" id="turma_id" class="form-select" required>
                            <option value="">Selecione a Turma</option>
                            @foreach($turmas as $turma)
                                <option value="{{ $turma->id }}" {{ $turmaId == $turma->id ? 'selected' : '' }}>
                                    {{ $turma->codigo }} - {{ $turma->nome }}
                                </option>
                            @endforeach
                        </select>
                    </div>
                    <div class="col-md-3">
                        <label for="tipo" class="form-label">Tipo</label>
                        <select name="tipo" id="tipo" class="form-select">
                            <option value="anual" {{ $tipo == 'anual' ? 'selected' : '' }}>Anual</option>
                            <option value="trimestral" {{ $tipo == 'trimestral' ? 'selected' : '' }}>Por Trimestre</option>
                        </select>
                    </div>
                    <div class="col-md-3" id="trimestre-container" style="display: {{ $tipo == 'trimestral' ? 'block' : 'none' }};">
                        <label for="trimestre_id" class="form-label">Trimestre</label>
                        <select name="trimestre_id" id="trimestre_id" class="form-select">
                            <option value="">Selecione o Trimestre</option>
                            @foreach($trimestres as $trimestre)
                                <option value="{{ $trimestre->id }}" {{ $trimestreId == $trimestre->id ? 'selected' : '' }}>
                                    {{ $trimestre->numero }}° Trimestre
                                </option>
                            @endforeach
                        </select>
                    </div>
                    <div class="col-md-3 d-flex align-items-end">
                        <button type="submit" class="btn btn-primary">Buscar</button>
                    </div>
                </form>
            </div>
        </div>

        @if($turmaId && !empty($estatisticas))
            @php
                $turma = $turmas->firstWhere('id', $turmaId);
            @endphp
            <div class="card mb-3">
                <div class="card-header bg-info text-white">
                    <h5 class="mb-0">
                        Estatísticas - {{ $turma->codigo }} - {{ $turma->nome }}
                        @if($tipo == 'trimestral' && $trimestreId)
                            - {{ $trimestres->firstWhere('id', $trimestreId)->numero }}° Trimestre
                        @else
                            - Anual
                        @endif
                    </h5>
                </div>
            </div>

            @foreach($estatisticas as $disciplinaId => $stats)
                @php
                    $disciplina = \App\Models\Disciplina::find($disciplinaId);
                @endphp
                <div class="card mb-3">
                    <div class="card-header bg-primary text-white">
                        <h5 class="mb-0">{{ $disciplina->nome }}</h5>
                    </div>
                    <div class="card-body">
                        <div class="row">
                            <div class="col-md-6">
                                <h6 class="text-success">Aprovados</h6>
                                <table class="table table-sm table-bordered">
                                    <thead class="table-light">
                                        <tr>
                                            <th>Gênero</th>
                                            <th>Quantidade</th>
                                            <th>Percentual</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <tr>
                                            <td>Homens</td>
                                            <td><strong>{{ $stats['aprovados_homens'] }}</strong></td>
                                            <td>{{ $stats['total'] > 0 ? number_format(($stats['aprovados_homens'] / $stats['total']) * 100, 1) : 0 }}%</td>
                                        </tr>
                                        <tr>
                                            <td>Mulheres</td>
                                            <td><strong>{{ $stats['aprovados_mulheres'] }}</strong></td>
                                            <td>{{ $stats['total'] > 0 ? number_format(($stats['aprovados_mulheres'] / $stats['total']) * 100, 1) : 0 }}%</td>
                                        </tr>
                                        <tr class="table-success">
                                            <td><strong>Total</strong></td>
                                            <td><strong>{{ $stats['total_aprovados'] }}</strong></td>
                                            <td><strong>{{ $stats['total'] > 0 ? number_format(($stats['total_aprovados'] / $stats['total']) * 100, 1) : 0 }}%</strong></td>
                                        </tr>
                                    </tbody>
                                </table>
                            </div>
                            <div class="col-md-6">
                                <h6 class="text-danger">Reprovados</h6>
                                <table class="table table-sm table-bordered">
                                    <thead class="table-light">
                                        <tr>
                                            <th>Gênero</th>
                                            <th>Quantidade</th>
                                            <th>Percentual</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <tr>
                                            <td>Homens</td>
                                            <td><strong>{{ $stats['reprovados_homens'] }}</strong></td>
                                            <td>{{ $stats['total'] > 0 ? number_format(($stats['reprovados_homens'] / $stats['total']) * 100, 1) : 0 }}%</td>
                                        </tr>
                                        <tr>
                                            <td>Mulheres</td>
                                            <td><strong>{{ $stats['reprovados_mulheres'] }}</strong></td>
                                            <td>{{ $stats['total'] > 0 ? number_format(($stats['reprovados_mulheres'] / $stats['total']) * 100, 1) : 0 }}%</td>
                                        </tr>
                                        <tr class="table-danger">
                                            <td><strong>Total</strong></td>
                                            <td><strong>{{ $stats['total_reprovados'] }}</strong></td>
                                            <td><strong>{{ $stats['total'] > 0 ? number_format(($stats['total_reprovados'] / $stats['total']) * 100, 1) : 0 }}%</strong></td>
                                        </tr>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                        <div class="row mt-3">
                            <div class="col-md-12">
                                <div class="alert alert-warning">
                                    <strong>Desistiram:</strong> {{ $stats['desistiram'] }} estudante(s)
                                    ({{ $stats['total'] > 0 ? number_format(($stats['desistiram'] / $stats['total']) * 100, 1) : 0 }}%)
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-12">
                                <div class="progress" style="height: 30px;">
                                    <div class="progress-bar bg-success" role="progressbar" 
                                         style="width: {{ $stats['total'] > 0 ? ($stats['total_aprovados'] / $stats['total']) * 100 : 0 }}%"
                                         aria-valuenow="{{ $stats['total_aprovados'] }}" 
                                         aria-valuemin="0" 
                                         aria-valuemax="{{ $stats['total'] }}">
                                        Aprovados: {{ $stats['total_aprovados'] }}
                                    </div>
                                    <div class="progress-bar bg-danger" role="progressbar" 
                                         style="width: {{ $stats['total'] > 0 ? ($stats['total_reprovados'] / $stats['total']) * 100 : 0 }}%"
                                         aria-valuenow="{{ $stats['total_reprovados'] }}" 
                                         aria-valuemin="0" 
                                         aria-valuemax="{{ $stats['total'] }}">
                                        Reprovados: {{ $stats['total_reprovados'] }}
                                    </div>
                                    <div class="progress-bar bg-warning" role="progressbar" 
                                         style="width: {{ $stats['total'] > 0 ? ($stats['desistiram'] / $stats['total']) * 100 : 0 }}%"
                                         aria-valuenow="{{ $stats['desistiram'] }}" 
                                         aria-valuemin="0" 
                                         aria-valuemax="{{ $stats['total'] }}">
                                        Desistiram: {{ $stats['desistiram'] }}
                                    </div>
                                </div>
                                <p class="mt-2 text-center"><strong>Total de Estudantes:</strong> {{ $stats['total'] }}</p>
                            </div>
                        </div>
                    </div>
                </div>
            @endforeach
        @elseif($turmaId)
            <div class="alert alert-info">
                Selecione uma turma e tipo de estatística para visualizar os dados.
            </div>
        @endif
    </div>
</div>

<script>
    document.getElementById('tipo').addEventListener('change', function() {
        const tipo = this.value;
        const trimestreContainer = document.getElementById('trimestre-container');
        const trimestreSelect = document.getElementById('trimestre_id');
        
        if (tipo === 'trimestral') {
            trimestreContainer.style.display = 'block';
            trimestreSelect.required = true;
        } else {
            trimestreContainer.style.display = 'none';
            trimestreSelect.required = false;
            trimestreSelect.value = '';
        }
    });
</script>
@endsection

