@extends('layouts.app')

@section('title', 'Avaliações - SGE')

@section('content')
<div class="row">
    <div class="col-12">
        <div class="d-flex justify-content-between align-items-center mb-3">
            <h2>Avaliações</h2>
            <div>
                @if(auth()->user()->isProfessor())
                @endif
                @if((auth()->user()->isAdmin() || auth()->user()->isSuperadmin() || auth()->user()->podeGerir('gerir_avaliacoes')) && isset($turmas) && $turmas->count() > 0)
                    <div class="btn-group">
                        <button type="button" class="btn btn-success dropdown-toggle" data-bs-toggle="dropdown">
                            <i class="bi bi-file-earmark-excel"></i> Exportar Excel
                        </button>
                        <ul class="dropdown-menu">
                            @foreach($turmas as $turma)
                                <li>
                                    <a class="dropdown-item" href="{{ route('avaliacoes.exportar-excel', ['turma_id' => $turma->id, 'ano_letivo_id' => $anoLetivo->id ?? 0]) }}">
                                        {{ $turma->codigo }} - {{ $turma->nome }}
                                    </a>
                                </li>
                            @endforeach
                        </ul>
                    </div>
                @endif
            </div>
        </div>

        @if($errors->any())
            <div class="alert alert-danger alert-dismissible fade show" role="alert">
                @foreach($errors->all() as $error)
                    {{ $error }}
                @endforeach
                <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
            </div>
        @endif

        @if(session('error'))
            <div class="alert alert-danger alert-dismissible fade show" role="alert">
                {{ session('error') }}
                <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
            </div>
        @endif

        @if(session('success'))
            <div class="alert alert-success alert-dismissible fade show" role="alert">
                {{ session('success') }}
                <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
            </div>
        @endif

        @if(auth()->user()->isAdmin() || auth()->user()->isSuperadmin() || auth()->user()->podeGerir('gerir_avaliacoes'))
            <div class="mb-3">
                <div class="row g-2">
                    <div class="col-md-3">
                        <a href="{{ route('avaliacoes.notas-por-estudante') }}" class="btn btn-outline-primary w-100 btn-sm">Notas por Estudante</a>
                    </div>
                    <div class="col-md-3">
                        <a href="{{ route('avaliacoes.todas-disciplinas', ['turma_id' => $turmas->first()->id ?? 0, 'ano_letivo_id' => $anoLetivo->id ?? 0]) }}" 
                           class="btn btn-outline-primary w-100 btn-sm">Todas as Disciplinas</a>
                    </div>
                    <div class="col-md-3">
                        <a href="{{ route('admin.alunos.folhetos-turma') }}" class="btn btn-outline-primary w-100 btn-sm">Folhetos Individuais</a>
                    </div>
                    <div class="col-md-3">
                        <a href="{{ route('avaliacoes.estatisticas') }}" class="btn btn-outline-primary w-100 btn-sm">Estatísticas</a>
                    </div>
                </div>
            </div>
        @elseif(auth()->user()->isProfessor())
            @if(isset($avaliacoes) && isset($turma) && isset($disciplina))
                {{-- Filtro e cabeçalho minimalista --}}
                <div class="mb-2 d-flex justify-content-between align-items-center flex-wrap gap-2" style="font-size: 0.85rem;">
                    <div class="d-flex align-items-center gap-2 flex-wrap">
                        <span class="fw-bold">{{ $turma->codigo }} - {{ $turma->nome }}</span>
                        <span>|</span>
                        <span class="fw-bold">{{ $disciplina->nome }}</span>
                    </div>
                    <form method="GET" action="{{ route('avaliacoes.index') }}" class="d-flex align-items-center gap-2" style="font-size: 0.85rem;">
                        <input type="hidden" name="turma_id" value="{{ $turma->id }}">
                        <input type="hidden" name="disciplina_id" value="{{ $disciplina->id }}">
                        <select name="filtro_tipo" class="form-select form-select-sm" style="width: auto; font-size: 0.85rem;" onchange="this.form.submit()">
                            <option value="anual" {{ ($filtroTipo ?? 'anual') === 'anual' ? 'selected' : '' }}>Pauta Anual</option>
                            <option value="trimestre" {{ ($filtroTipo ?? 'anual') === 'trimestre' ? 'selected' : '' }}>Por Trimestre</option>
                        </select>
                        @if(($filtroTipo ?? 'anual') === 'trimestre')
                            <select name="trimestre_id" class="form-select form-select-sm" style="width: auto; font-size: 0.85rem;" onchange="this.form.submit()">
                                <option value="">Todos</option>
                                @foreach($trimestres ?? [] as $t)
                                    <option value="{{ $t->id }}" {{ ($trimestreFiltro ?? '') == $t->id ? 'selected' : '' }}>
                                        {{ $t->numero }}º Trimestre
                                    </option>
                                @endforeach
                            </select>
                        @endif
                        <a href="{{ route('avaliacoes.index') }}" class="btn btn-sm btn-secondary" style="font-size: 0.85rem;">
                            <i class="bi bi-arrow-left"></i> Voltar
                        </a>
                    </form>
                </div>
                
                {{-- Tabela minimalista --}}
                @php
                    $isSecundario = isset($turma) && ($turma->nivel_ensino ?? 'PRIMARIO') === 'SECUNDARIO';
                @endphp
                <div class="table-responsive">
                    <table class="table table-bordered table-sm" style="font-size: 0.7rem;">
                        <style>
                            .table-bordered th, .table-bordered td {
                                padding: 0.25rem 0.35rem !important;
                            }
                        </style>
                        @if(($filtroTipo ?? 'anual') === 'anual')
                            {{-- Pauta Anual --}}
                            <thead>
                                @if($isSecundario)
                                    <tr>
                                        <th rowspan="2" style="vertical-align: middle;">Aluno</th>
                                        @foreach($trimestres ?? [] as $t)
                                            <th colspan="4" class="text-center">{{ $t->numero }}º Trimestre</th>
                                        @endforeach
                                        <th rowspan="2" style="vertical-align: middle;">MFRD</th>
                                        <th rowspan="2" style="vertical-align: middle;">Classificação</th>
                                    </tr>
                                    <tr>
                                        @foreach($trimestres ?? [] as $t)
                                            <th>Teste 1</th>
                                            <th>Teste 2</th>
                                            <th>Av. Final</th>
                                            <th>Média</th>
                                        @endforeach
                                    </tr>
                                @else
                                    <tr>
                                        <th rowspan="2" style="vertical-align: middle;">Aluno</th>
                                        @foreach($trimestres ?? [] as $t)
                                            <th colspan="8" class="text-center">{{ $t->numero }}º Trimestre</th>
                                        @endforeach
                                        <th rowspan="2" style="vertical-align: middle;">MFRD</th>
                                        <th rowspan="2" style="vertical-align: middle;">Classificação</th>
                                    </tr>
                                    <tr>
                                        @foreach($trimestres ?? [] as $t)
                                            <th>1ª A.Pr</th>
                                            <th>2ª A.Pr</th>
                                            <th>MAP</th>
                                            <th>1ª ACS</th>
                                            <th>2ª ACS</th>
                                            <th>MACS</th>
                                            <th>AT</th>
                                            <th>MT</th>
                                        @endforeach
                                    </tr>
                                @endif
                            </thead>
                            <tbody>
                                @php
                                    $alunosUnicos = $avaliacoes->pluck('aluno')->unique('id')->values();
                                @endphp
                                @forelse($alunosUnicos as $aluno)
                                    <tr>
                                        <td>{{ $aluno->user->name ?? 'N/A' }}</td>
                                        @foreach($trimestres ?? [] as $t)
                                            @php
                                                $avaliacao = $avaliacoes->filter(function($a) use ($aluno, $t) {
                                                    return $a->aluno_id == $aluno->id && $a->trimestre_id == $t->id;
                                                })->first();
                                            @endphp
                                            @if($isSecundario)
                                                <td class="text-center {{ $avaliacao && $avaliacao->teste1 !== null && $avaliacao->teste1 < 10 ? 'text-danger' : '' }}">{{ $avaliacao && $avaliacao->teste1 !== null ? number_format($avaliacao->teste1, 1) : '-' }}</td>
                                                <td class="text-center {{ $avaliacao && $avaliacao->teste2 !== null && $avaliacao->teste2 < 10 ? 'text-danger' : '' }}">{{ $avaliacao && $avaliacao->teste2 !== null ? number_format($avaliacao->teste2, 1) : '-' }}</td>
                                                <td class="text-center {{ $avaliacao && $avaliacao->avaliacao_final !== null && $avaliacao->avaliacao_final < 10 ? 'text-danger' : '' }}">{{ $avaliacao && $avaliacao->avaliacao_final !== null ? number_format($avaliacao->avaliacao_final, 1) : '-' }}</td>
                                                <td class="text-center fw-bold {{ $avaliacao && $avaliacao->media_nacional !== null && $avaliacao->media_nacional < 10 ? 'text-danger' : '' }}">{{ $avaliacao && $avaliacao->media_nacional !== null ? number_format($avaliacao->media_nacional, 1) : '-' }}</td>
                                            @else
                                                <td class="text-center {{ $avaliacao && $avaliacao->a_pratica_1 !== null && $avaliacao->a_pratica_1 < 10 ? 'text-danger' : '' }}">{{ $avaliacao && $avaliacao->a_pratica_1 !== null ? number_format($avaliacao->a_pratica_1, 1) : '-' }}</td>
                                                <td class="text-center {{ $avaliacao && $avaliacao->a_pratica_2 !== null && $avaliacao->a_pratica_2 < 10 ? 'text-danger' : '' }}">{{ $avaliacao && $avaliacao->a_pratica_2 !== null ? number_format($avaliacao->a_pratica_2, 1) : '-' }}</td>
                                                <td class="text-center fw-bold {{ $avaliacao && $avaliacao->map !== null && $avaliacao->map < 10 ? 'text-danger' : '' }}">{{ $avaliacao && $avaliacao->map !== null ? number_format($avaliacao->map, 1) : '-' }}</td>
                                                <td class="text-center {{ $avaliacao && $avaliacao->acs_1 !== null && $avaliacao->acs_1 < 10 ? 'text-danger' : '' }}">{{ $avaliacao && $avaliacao->acs_1 !== null ? number_format($avaliacao->acs_1, 1) : '-' }}</td>
                                                <td class="text-center {{ $avaliacao && $avaliacao->acs_2 !== null && $avaliacao->acs_2 < 10 ? 'text-danger' : '' }}">{{ $avaliacao && $avaliacao->acs_2 !== null ? number_format($avaliacao->acs_2, 1) : '-' }}</td>
                                                <td class="text-center fw-bold {{ $avaliacao && $avaliacao->macs !== null && $avaliacao->macs < 10 ? 'text-danger' : '' }}">{{ $avaliacao && $avaliacao->macs !== null ? number_format($avaliacao->macs, 1) : '-' }}</td>
                                                <td class="text-center {{ $avaliacao && $avaliacao->at !== null && $avaliacao->at < 10 ? 'text-danger' : '' }}">{{ $avaliacao && $avaliacao->at !== null ? number_format($avaliacao->at, 1) : '-' }}</td>
                                                <td class="text-center fw-bold {{ $avaliacao && $avaliacao->mt !== null && $avaliacao->mt < 10 ? 'text-danger' : '' }}">{{ $avaliacao && $avaliacao->mt !== null ? number_format($avaliacao->mt, 0) : '-' }}</td>
                                            @endif
                                        @endforeach
                                        <td class="text-center fw-bold {{ isset($mediasAnuais[$aluno->id]) && $mediasAnuais[$aluno->id] < 10 ? 'text-danger' : '' }}">
                                            {{ isset($mediasAnuais[$aluno->id]) ? number_format($mediasAnuais[$aluno->id], 0) : '-' }}
                                        </td>
                                        <td class="text-center fw-bold {{ isset($classificacoes[$aluno->id]) ? ($classificacoes[$aluno->id] === 'APROVADO' ? 'text-success' : 'text-danger') : '' }}">
                                            {{ isset($classificacoes[$aluno->id]) ? $classificacoes[$aluno->id] : '-' }}
                                        </td>
                                    </tr>
                                @empty
                                    <tr>
                                        <td colspan="{{ ($isSecundario ? (count($trimestres ?? []) * 4) : (count($trimestres ?? []) * 8)) + 3 }}" class="text-center text-muted">Nenhuma avaliação registrada</td>
                                    </tr>
                                @endforelse
                            </tbody>
                        @else
                            {{-- Por Trimestre --}}
                            <thead>
                                @if($isSecundario)
                                    <tr>
                                        <th>Aluno</th>
                                        <th>Trimestre</th>
                                        <th>Teste 1</th>
                                        <th>Teste 2</th>
                                        <th>Av. Final</th>
                                        <th>Média</th>
                                    </tr>
                                @else
                                    <tr>
                                        <th>Aluno</th>
                                        <th>Trimestre</th>
                                        <th>1ª A.Pr</th>
                                        <th>2ª A.Pr</th>
                                        <th>MAP</th>
                                        <th>1ª ACS</th>
                                        <th>2ª ACS</th>
                                        <th>MACS</th>
                                        <th>AT</th>
                                        <th>MT</th>
                                    </tr>
                                @endif
                            </thead>
                            <tbody>
                                @forelse($avaliacoes as $avaliacao)
                                    <tr>
                                        <td>{{ $avaliacao->aluno->user->name ?? 'N/A' }}</td>
                                        <td>{{ $avaliacao->trimestre->numero ?? 'N/A' }}º</td>
                                        @if($isSecundario)
                                            <td class="text-center {{ $avaliacao->teste1 !== null && $avaliacao->teste1 < 10 ? 'text-danger' : '' }}">{{ $avaliacao->teste1 !== null ? number_format($avaliacao->teste1, 1) : '-' }}</td>
                                            <td class="text-center {{ $avaliacao->teste2 !== null && $avaliacao->teste2 < 10 ? 'text-danger' : '' }}">{{ $avaliacao->teste2 !== null ? number_format($avaliacao->teste2, 1) : '-' }}</td>
                                            <td class="text-center {{ $avaliacao->avaliacao_final !== null && $avaliacao->avaliacao_final < 10 ? 'text-danger' : '' }}">{{ $avaliacao->avaliacao_final !== null ? number_format($avaliacao->avaliacao_final, 1) : '-' }}</td>
                                            <td class="text-center fw-bold {{ $avaliacao->media_nacional !== null && $avaliacao->media_nacional < 10 ? 'text-danger' : '' }}">{{ $avaliacao->media_nacional !== null ? number_format($avaliacao->media_nacional, 1) : '-' }}</td>
                                        @else
                                            <td class="text-center {{ $avaliacao->a_pratica_1 !== null && $avaliacao->a_pratica_1 < 10 ? 'text-danger' : '' }}">{{ $avaliacao->a_pratica_1 !== null ? number_format($avaliacao->a_pratica_1, 1) : '-' }}</td>
                                            <td class="text-center {{ $avaliacao->a_pratica_2 !== null && $avaliacao->a_pratica_2 < 10 ? 'text-danger' : '' }}">{{ $avaliacao->a_pratica_2 !== null ? number_format($avaliacao->a_pratica_2, 1) : '-' }}</td>
                                            <td class="text-center fw-bold {{ $avaliacao->map !== null && $avaliacao->map < 10 ? 'text-danger' : '' }}">{{ $avaliacao->map !== null ? number_format($avaliacao->map, 1) : '-' }}</td>
                                            <td class="text-center {{ $avaliacao->acs_1 !== null && $avaliacao->acs_1 < 10 ? 'text-danger' : '' }}">{{ $avaliacao->acs_1 !== null ? number_format($avaliacao->acs_1, 1) : '-' }}</td>
                                            <td class="text-center {{ $avaliacao->acs_2 !== null && $avaliacao->acs_2 < 10 ? 'text-danger' : '' }}">{{ $avaliacao->acs_2 !== null ? number_format($avaliacao->acs_2, 1) : '-' }}</td>
                                            <td class="text-center fw-bold {{ $avaliacao->macs !== null && $avaliacao->macs < 10 ? 'text-danger' : '' }}">{{ $avaliacao->macs !== null ? number_format($avaliacao->macs, 1) : '-' }}</td>
                                            <td class="text-center {{ $avaliacao->at !== null && $avaliacao->at < 10 ? 'text-danger' : '' }}">{{ $avaliacao->at !== null ? number_format($avaliacao->at, 1) : '-' }}</td>
                                            <td class="text-center fw-bold {{ $avaliacao->mt !== null && $avaliacao->mt < 10 ? 'text-danger' : '' }}">{{ $avaliacao->mt !== null ? number_format($avaliacao->mt, 0) : '-' }}</td>
                                        @endif
                                    </tr>
                                @empty
                                    <tr>
                                        <td colspan="{{ $isSecundario ? 6 : 10 }}" class="text-center text-muted">Nenhuma avaliação registrada</td>
                                    </tr>
                                @endforelse
                            </tbody>
                        @endif
                    </table>
                </div>
            @else
                {{-- Mostrar lista de turmas e disciplinas --}}
                <div class="table-responsive">
                    <table class="table table-bordered table-sm" style="font-size: 0.75rem;">
                        <style>
                            .table-bordered th, .table-bordered td {
                                padding: 0.3rem 0.5rem !important;
                            }
                        </style>
                        <thead>
                            <tr>
                                <th>Turma</th>
                                <th>Disciplina</th>
                                <th>Acções</th>
                            </tr>
                        </thead>
                        <tbody>
                            @forelse($turmasComDisciplinas ?? [] as $item)
                                <tr>
                                    <td>{{ $item->turma->codigo }} - {{ $item->turma->nome }}</td>
                                    <td>{{ $item->disciplina->nome }}</td>
                                    <td>
                                        <a href="{{ route('avaliacoes.create', ['turma_id' => $item->turma_id, 'disciplina_id' => $item->disciplina_id, 'trimestre_id' => 1, 'ano_letivo_id' => $anoLetivo->id ?? 0]) }}" 
                                           class="btn btn-sm btn-outline-primary" style="font-size: 0.7rem; padding: 0.2rem 0.4rem;">Lançar</a>
                                        <a href="{{ route('avaliacoes.index', ['turma_id' => $item->turma_id, 'disciplina_id' => $item->disciplina_id]) }}" 
                                           class="btn btn-sm btn-outline-info" style="font-size: 0.7rem; padding: 0.2rem 0.4rem;">Ver</a>
                                        <a href="{{ route('avaliacoes.imprimir-ficha', ['turma_id' => $item->turma_id, 'disciplina_id' => $item->disciplina_id, 'ano_letivo_id' => $anoLetivo->id ?? 0]) }}" 
                                           class="btn btn-sm btn-outline-secondary" style="font-size: 0.7rem; padding: 0.2rem 0.4rem;" target="_blank">Imprimir</a>
                                    </td>
                                </tr>
                            @empty
                                <tr>
                                    <td colspan="3" class="text-center text-muted">Nenhuma turma atribuída</td>
                                </tr>
                            @endforelse
                        </tbody>
                    </table>
                </div>
            @endif
        @elseif(auth()->user()->isAluno())
            <div class="table-responsive">
                <table class="table table-bordered table-sm">
                    <thead>
                        <tr>
                            <th>Disciplina</th>
                            <th>Turma</th>
                            <th>Trimestre</th>
                            <th>Nota Nacional</th>
                        </tr>
                    </thead>
                    <tbody>
                        @forelse($avaliacoes ?? [] as $avaliacao)
                            <tr>
                                <td>{{ $avaliacao->disciplina->nome }}</td>
                                <td>{{ $avaliacao->turma->nome }}</td>
                                <td>{{ $avaliacao->trimestre->nome }}</td>
                                <td>{{ $avaliacao->media_nacional ?? 'N/A' }}</td>
                            </tr>
                        @empty
                            <tr>
                                <td colspan="4" class="text-center text-muted">Nenhuma avaliação registrada</td>
                            </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>
        @endif
    </div>
</div>
@endsection



