@extends('layouts.app')

@section('title', 'Nova Mensagem - SIGE')

@section('content')
<style>
    body {
        background-color: #f8f9fa !important;
    }
    .card {
        background-color: #fff !important;
        border: 1px solid #dee2e6 !important;
        box-shadow: 0 0.125rem 0.25rem rgba(0, 0, 0, 0.075) !important;
    }
    .card-body {
        background-color: #fff !important;
        color: #212529 !important;
    }
    .form-control, .form-select {
        background-color: #fff !important;
        color: #212529 !important;
        border: 1px solid #dee2e6 !important;
    }
    .form-control:focus, .form-select:focus {
        background-color: #fff !important;
        color: #212529 !important;
        border-color: #0d6efd !important;
        box-shadow: 0 0 0 0.25rem rgba(13, 110, 253, 0.25) !important;
    }
    textarea.form-control {
        background-color: #fff !important;
        color: #212529 !important;
    }
    .form-label {
        color: #212529 !important;
        font-weight: 500;
    }
    .alert-info {
        background-color: #d1ecf1 !important;
        color: #0c5460 !important;
        border-color: #bee5eb !important;
    }
</style>
<div class="row">
    <div class="col-12">
        <div class="d-flex justify-content-between align-items-center mb-2">
            <h5 class="mb-0">
                <i class="bi bi-chat-dots text-primary me-1"></i>Nova Mensagem
            </h5>
            <a href="{{ route('chat.index') }}" class="btn btn-sm btn-outline-secondary">
                <i class="bi bi-arrow-left"></i>
            </a>
        </div>
    </div>
</div>

<div class="card border-0 shadow-sm">
    <div class="card-body p-3" style="background-color: #fff;">
        <form id="formMensagemMassa" method="POST" action="{{ route('chat.store-mass') }}">
            @csrf
            <input type="hidden" name="tipo" value="{{ $tipo }}">
            
            <div class="mb-2">
                <small class="text-muted d-block mb-1">
                    @if($tipo === 'geral')
                        Para: Todos
                    @elseif($tipo === 'professores')
                        Para: Professores
                    @elseif($tipo === 'alunos')
                        Para: Alunos
                    @elseif($tipo === 'escola')
                        Para: Direção
                    @endif
                </small>
                <textarea name="message" 
                          id="messageTextarea"
                          class="form-control form-control-sm" 
                          rows="4" 
                          placeholder="Mensagem..." 
                          required
                          style="background-color: #fff; border: 1px solid #dee2e6; resize: none;"
                          autofocus></textarea>
            </div>
            
            <div class="d-flex justify-content-end gap-2 mt-2">
                <a href="{{ route('chat.index') }}" class="btn btn-sm btn-outline-secondary">Cancelar</a>
                <button type="submit" class="btn btn-sm btn-primary">
                    <i class="bi bi-send me-1"></i>Enviar
                </button>
            </div>
        </form>
    </div>
</div>

<script>
document.getElementById('formMensagemMassa').addEventListener('submit', function(e) {
    e.preventDefault();
    
    const formData = new FormData(this);
    const button = this.querySelector('button[type="submit"]');
    const originalText = button.innerHTML;
    button.disabled = true;
    button.innerHTML = '<span class="spinner-border spinner-border-sm me-1"></span> Enviando...';
    
    fetch(this.action, {
        method: 'POST',
        body: formData,
        headers: {
            'X-Requested-With': 'XMLHttpRequest',
            'Accept': 'application/json'
        }
    })
    .then(response => response.json())
    .then(data => {
        if (data.success) {
            alert('Mensagem enviada com sucesso para ' + data.enviadas + ' destinatário(s)!');
            window.location.href = '{{ route("chat.index") }}';
        } else {
            alert('Erro ao enviar mensagem: ' + (data.error || 'Erro desconhecido'));
            button.disabled = false;
            button.innerHTML = originalText;
        }
    })
    .catch(error => {
        console.error('Erro:', error);
        alert('Erro ao enviar mensagem. Tente novamente.');
        button.disabled = false;
        button.innerHTML = originalText;
    });
});
</script>
@endsection
