@extends('layouts.app')

@section('title', 'Eventos - SGE')

@section('content')
<div class="row">
    <div class="col-12">
        <div class="d-flex justify-content-between align-items-center mb-2" style="border-bottom: 1px solid #dee2e6; padding-bottom: 8px;">
            <h5 class="mb-0" style="font-weight: 600;">Eventos</h5>
            @if(auth()->user()->isAdmin() || auth()->user()->isSuperadmin() || auth()->user()->podeGerir('gerir_eventos'))
                <a href="{{ route('eventos.create') }}" class="btn btn-sm btn-primary">
                    <i class="bi bi-plus-circle"></i> Agendar Evento
                </a>
            @endif
        </div>

        @if(isset($eventos) && $eventos->count() > 0)
            <div class="js-ajax-pagination">
                <div class="table-responsive">
                    <table class="table table-sm table-bordered" style="font-size: 0.85rem; margin-bottom: 0;">
                    <thead style="background-color: #f8f9fa;">
                        <tr>
                            <th style="padding: 6px;">Título</th>
                            <th style="padding: 6px;">Data</th>
                            <th style="padding: 6px;">Hora</th>
                            <th style="padding: 6px;">Tipo</th>
                            <th style="padding: 6px;">Status</th>
                            @if(auth()->user()->isAdmin() || auth()->user()->isSuperadmin() || auth()->user()->podeGerir('gerir_eventos'))
                                <th style="padding: 6px;">Acções</th>
                            @endif
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($eventos as $evento)
                            <tr class="{{ $evento->cancelado ? 'table-secondary' : '' }}">
                                <td style="padding: 5px;">
                                    <strong>{{ $evento->titulo }}</strong>
                                    @if($evento->descricao)
                                        <br><small class="text-muted" style="font-size: 0.75rem;">{{ Str::limit($evento->descricao, 50) }}</small>
                                    @endif
                                </td>
                                <td style="padding: 5px;">{{ $evento->data->format('d/m/Y') }}</td>
                                <td style="padding: 5px;">
                                    @if($evento->hora_inicio)
                                        {{ $evento->hora_inicio->format('H:i') }}@if($evento->hora_fim) - {{ $evento->hora_fim->format('H:i') }}@endif
                                    @else
                                        -
                                    @endif
                                </td>
                                <td style="padding: 5px;">
                                    <span style="font-size: 0.75rem; padding: 2px 6px; background: #e7f3ff; color: #0066cc; border-radius: 3px;">{{ $evento->tipo }}</span>
                                    @if($evento->turma)
                                        <br><small style="font-size: 0.7rem;">{{ $evento->turma->codigo }} - {{ $evento->turma->nome }}</small>
                                    @endif
                                    @if($evento->disciplina)
                                        <br><small style="font-size: 0.7rem;">{{ $evento->disciplina->nome }}</small>
                                    @endif
                                </td>
                                <td style="padding: 5px;">
                                    @if($evento->cancelado)
                                        <span style="font-size: 0.75rem; padding: 2px 6px; background: #f8d7da; color: #721c24; border-radius: 3px;">Cancelado</span>
                                    @else
                                        <span style="font-size: 0.75rem; padding: 2px 6px; background: #d4edda; color: #155724; border-radius: 3px;">Activo</span>
                                    @endif
                                </td>
                                @if(auth()->user()->isAdmin() || auth()->user()->isSuperadmin() || auth()->user()->podeGerir('gerir_eventos'))
                                    <td style="padding: 5px;">
                                        <div style="display: flex; gap: 4px;">
                                            <a href="{{ route('eventos.edit', $evento) }}" class="btn btn-sm" style="padding: 2px 6px; font-size: 0.75rem; background: #fff3cd; color: #856404; border: none;" title="Editar">
                                                <i class="bi bi-pencil"></i>
                                            </a>
                                            <form action="{{ route('eventos.cancelar', $evento) }}" method="POST" class="d-inline">
                                                @csrf
                                                @method('PATCH')
                                                <button type="submit" class="btn btn-sm" style="padding: 2px 6px; font-size: 0.75rem; background: {{ $evento->cancelado ? '#d4edda' : '#fff3cd' }}; color: {{ $evento->cancelado ? '#155724' : '#856404' }}; border: none;" title="{{ $evento->cancelado ? 'Reativar' : 'Cancelar' }}">
                                                    <i class="bi bi-{{ $evento->cancelado ? 'check-circle' : 'x-circle' }}"></i>
                                                </button>
                                            </form>
                                            <form action="{{ route('eventos.destroy', $evento) }}" method="POST" class="d-inline"
                                                  onsubmit="return confirm('Tem certeza que deseja eliminar este evento?');">
                                                @csrf
                                                @method('DELETE')
                                                <button type="submit" class="btn btn-sm" style="padding: 2px 6px; font-size: 0.75rem; background: #f8d7da; color: #721c24; border: none;" title="Eliminar">
                                                    <i class="bi bi-trash"></i>
                                                </button>
                                            </form>
                                        </div>
                                    </td>
                                @endif
                            </tr>
                        @endforeach
                    </tbody>
                    </table>
                </div>
                
                @if(method_exists($eventos, 'links'))
                    <div class="mt-3">
                        {{ $eventos->appends(request()->query())->links() }}
                    </div>
                @endif
            </div>
        @else
            <div style="background: #f8f9fa; padding: 20px; border-radius: 4px; text-align: center; font-size: 0.85rem;">
                Nenhum evento registrado
            </div>
        @endif
    </div>
</div>
@endsection



