<!DOCTYPE html>
<html lang="pt">
<head>
    <meta charset="UTF-8">
    <title>Relatório Financeiro</title>
    <style>
        @page {
            margin: 15mm;
        }
        body {
            font-family: Arial, sans-serif;
            font-size: 9pt;
            margin: 0;
            padding: 0;
        }
        .header {
            text-align: center;
            margin-bottom: 15px;
            border-bottom: 2px solid #000;
            padding-bottom: 10px;
        }
        .header img {
            max-height: 80px;
            margin-bottom: 5px;
        }
        .header h1 {
            font-size: 14pt;
            margin: 5px 0;
            font-weight: bold;
        }
        .info-header {
            font-size: 8pt;
            margin-bottom: 10px;
            padding: 5px;
            background-color: #f5f5f5;
            border: 1px solid #ddd;
        }
        table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 15px;
            font-size: 8pt;
        }
        th, td {
            border: 1px solid #000;
            padding: 4px;
            text-align: left;
        }
        th {
            background-color: #f0f0f0;
            font-weight: bold;
            text-align: center;
        }
        .text-end {
            text-align: right;
        }
        .text-center {
            text-align: center;
        }
        .summary-box {
            display: inline-block;
            border: 1px solid #000;
            padding: 8px;
            margin: 5px;
            min-width: 120px;
            text-align: center;
        }
        .summary-box .label {
            font-size: 7pt;
            color: #666;
        }
        .summary-box .value {
            font-size: 11pt;
            font-weight: bold;
        }
        .page-break {
            page-break-after: always;
        }
    </style>
</head>
<body>
    <div class="header">
        @if(!empty($logotipoBase64))
            <img src="{{ $logotipoBase64 }}" alt="Logotipo da Escola">
        @endif
        <h1>RELATÓRIO FINANCEIRO</h1>
        <div style="font-size: 9pt;">
            @if($anoLetivo)
                Ano Letivo: {{ $anoLetivo->ano_inicial ?? $anoLetivo->ano }}
            @endif
            @if($turma)
                | Turma: {{ $turma->codigo }} - {{ $turma->nome }}
            @endif
            @if($nivelEnsino)
                | Nível: {{ $nivelEnsino == 'PRIMARIO' ? 'Ensino Primário' : 'Ensino Secundário' }}
            @endif
        </div>
    </div>

    <div class="info-header">
        <strong>Período:</strong> {{ ucfirst($tipoPeriodo) }} | 
        <strong>Data de Geração:</strong> {{ date('d/m/Y H:i') }}
    </div>

    <div style="text-align: center; margin-bottom: 15px;">
        <div class="summary-box">
            <div class="label">Esperado</div>
            <div class="value">{{ number_format($totalEsperado, 0, ',', '.') }} MT</div>
        </div>
        <div class="summary-box">
            <div class="label">Pago</div>
            <div class="value" style="color: #28a745;">{{ number_format($totalPago, 0, ',', '.') }} MT</div>
        </div>
        <div class="summary-box">
            <div class="label">Pendente</div>
            <div class="value" style="color: #ffc107;">{{ number_format($totalPendente, 0, ',', '.') }} MT</div>
        </div>
        <div class="summary-box">
            <div class="label">Vencido</div>
            <div class="value" style="color: #dc3545;">{{ number_format($totalVencido, 0, ',', '.') }} MT</div>
        </div>
    </div>

    @if(!empty($dadosAgrupados) && count($dadosAgrupados) > 0)
        <table>
            <thead>
                <tr>
                    <th>
                        @if($agruparPor == 'turma')
                            Turma
                        @elseif($agruparPor == 'classe')
                            Classe
                        @elseif($agruparPor == 'nivel_ensino')
                            Nível de Ensino
                        @endif
                    </th>
                    <th class="text-end">Esperado</th>
                    <th class="text-end">Pago</th>
                    <th class="text-end">Pendente</th>
                    <th class="text-end">Vencido</th>
                    <th class="text-end">Facturas</th>
                    <th class="text-end">Taxa</th>
                </tr>
            </thead>
            <tbody>
                @foreach($dadosAgrupados as $dados)
                    @php
                        $taxaPagamento = $dados['esperado'] > 0 ? ($dados['pago'] / $dados['esperado']) * 100 : 0;
                    @endphp
                    <tr>
                        <td>{{ $dados['label'] }}</td>
                        <td class="text-end">{{ number_format($dados['esperado'], 0, ',', '.') }} MT</td>
                        <td class="text-end">{{ number_format($dados['pago'], 0, ',', '.') }} MT</td>
                        <td class="text-end">{{ number_format($dados['pendente'], 0, ',', '.') }} MT</td>
                        <td class="text-end">{{ number_format($dados['vencido'], 0, ',', '.') }} MT</td>
                        <td class="text-end">{{ number_format($dados['facturas'], 0, ',', '.') }} MT</td>
                        <td class="text-end">{{ number_format($taxaPagamento, 0) }}%</td>
                    </tr>
                @endforeach
            </tbody>
        </table>
    @endif

    <table>
        <thead>
            <tr>
                <th>Período</th>
                <th class="text-end">Esperado</th>
                <th class="text-end">Pago</th>
                <th class="text-end">Pendente</th>
                <th class="text-end">Taxa</th>
            </tr>
        </thead>
        <tbody>
            @foreach($dadosPorPeriodo as $dados)
                @php
                    $taxaPagamento = $dados['esperado'] > 0 ? ($dados['pago'] / $dados['esperado']) * 100 : 0;
                @endphp
                <tr>
                    <td>{{ $dados['periodo'] }}</td>
                    <td class="text-end">{{ number_format($dados['esperado'], 0, ',', '.') }} MT</td>
                    <td class="text-end">{{ number_format($dados['pago'], 0, ',', '.') }} MT</td>
                    <td class="text-end">{{ number_format($dados['pendente'], 0, ',', '.') }} MT</td>
                    <td class="text-end">{{ number_format($taxaPagamento, 0) }}%</td>
                </tr>
            @endforeach
        </tbody>
    </table>

    <div style="margin-top: 20px; font-size: 8pt; text-align: center; color: #666;">
        Relatório gerado em {{ date('d/m/Y H:i:s') }}
    </div>
</body>
</html>
