@extends('layouts.app')

@section('title', 'Gerar Horários Automaticamente - SGE')

@section('content')
<div class="row">
    <div class="col-md-10">
        <div class="d-flex justify-content-between align-items-center mb-2" style="border-bottom: 1px solid #dee2e6; padding-bottom: 8px;">
            <h5 class="mb-0" style="font-weight: 600;">Gerar Horários Automaticamente</h5>
            <a href="{{ route('horarios.index') }}" class="btn btn-sm btn-secondary">
                <i class="bi bi-arrow-left"></i> Voltar
            </a>
        </div>
        
        <div style="background: #f8f9fa; padding: 15px; border-radius: 4px;">
            <form method="POST" action="{{ route('horarios.store-automatico') }}">
                @csrf

                <div class="mb-2">
                    <label for="turma_id" class="form-label" style="font-size: 0.85rem; margin-bottom: 3px;">Turma <span class="text-danger">*</span></label>
                    <select class="form-select form-select-sm @error('turma_id') is-invalid @enderror" 
                            id="turma_id" name="turma_id" required>
                        <option value="">Selecione uma turma</option>
                        @foreach($turmas as $turma)
                            <option value="{{ $turma->id }}" {{ old('turma_id') == $turma->id ? 'selected' : '' }}>
                                {{ $turma->codigo }} - {{ $turma->nome }}
                            </option>
                        @endforeach
                    </select>
                    @error('turma_id')
                        <div class="invalid-feedback">{{ $message }}</div>
                    @enderror
                    <small class="text-muted" style="font-size: 0.75rem;">A turma deve ter disciplinas e professores atribuídos. Serão criadas <strong>6 aulas por dia</strong>.</small>
                </div>

                <div class="row">
                    <div class="col-md-6 mb-2">
                        <label for="hora_inicio_manha" class="form-label" style="font-size: 0.85rem; margin-bottom: 3px;">Início <span class="text-danger">*</span></label>
                        <input type="time" class="form-control form-control-sm @error('hora_inicio_manha') is-invalid @enderror" 
                               id="hora_inicio_manha" name="hora_inicio_manha" value="{{ old('hora_inicio_manha', '07:30') }}" required>
                        @error('hora_inicio_manha')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>

                    <div class="col-md-6 mb-2">
                        <label for="hora_fim_manha" class="form-label" style="font-size: 0.85rem; margin-bottom: 3px;">Fim <span class="text-danger">*</span></label>
                        <input type="time" class="form-control form-control-sm @error('hora_fim_manha') is-invalid @enderror" 
                               id="hora_fim_manha" name="hora_fim_manha" value="{{ old('hora_fim_manha', '12:15') }}" required>
                        @error('hora_fim_manha')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                        <small class="text-muted" style="font-size: 0.7rem;">Intervalo de 15 min após a 3ª aula</small>
                    </div>
                </div>


                <div class="row">
                    <div class="col-md-6 mb-2">
                        <label for="duracao_aula" class="form-label" style="font-size: 0.85rem; margin-bottom: 3px;">Duração da Aula (minutos) <span class="text-danger">*</span></label>
                        <input type="number" class="form-control form-control-sm @error('duracao_aula') is-invalid @enderror" 
                               id="duracao_aula" name="duracao_aula" value="{{ old('duracao_aula', 45) }}" min="30" max="120" step="15" required>
                        @error('duracao_aula')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                        <small class="text-muted" style="font-size: 0.7rem;">Serão criadas exatamente 6 aulas por dia</small>
                    </div>

                    <div class="col-md-6 mb-2">
                        <label for="sala_padrao" class="form-label" style="font-size: 0.85rem; margin-bottom: 3px;">Sala Padrão</label>
                        <input type="text" class="form-control form-control-sm @error('sala_padrao') is-invalid @enderror" 
                               id="sala_padrao" name="sala_padrao" value="{{ old('sala_padrao') }}" placeholder="Ex: Sala 1">
                        @error('sala_padrao')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>
                </div>

                <div class="mb-2">
                    <label class="form-label" style="font-size: 0.85rem; margin-bottom: 3px;">Dias da Semana <span class="text-danger">*</span></label>
                    <div style="display: flex; flex-wrap: wrap; gap: 10px;">
                        @foreach(['Segunda', 'Terça', 'Quarta', 'Quinta', 'Sexta'] as $dia)
                            <div class="form-check">
                                <input class="form-check-input" type="checkbox" name="dias_semana[]" 
                                       id="dia_{{ $dia }}" value="{{ $dia }}" 
                                       {{ in_array($dia, old('dias_semana', ['Segunda', 'Terça', 'Quarta', 'Quinta', 'Sexta'])) ? 'checked' : '' }}>
                                <label class="form-check-label" for="dia_{{ $dia }}" style="font-size: 0.85rem;">
                                    {{ $dia }}-feira
                                </label>
                            </div>
                        @endforeach
                    </div>
                    @error('dias_semana')
                        <div class="text-danger" style="font-size: 0.75rem;">{{ $message }}</div>
                    @enderror
                </div>

                <input type="hidden" name="ano_letivo_id" value="{{ $anoLetivo->id }}">

                <div class="mt-3">
                    <button type="submit" class="btn btn-sm btn-primary">
                        <i class="bi bi-magic"></i> Gerar Horários
                    </button>
                    <a href="{{ route('horarios.index') }}" class="btn btn-sm btn-secondary">Cancelar</a>
                </div>
            </form>
        </div>
    </div>
</div>
@endsection

