<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <title>Horários - {{ $anoLetivo->ano ?? '' }}</title>
    <style>
        @page {
            margin: 15mm;
        }
        body {
            font-family: Arial, sans-serif;
            font-size: 9pt;
            margin: 0;
            padding: 0;
        }
        .header {
            text-align: center;
            margin-bottom: 15px;
            border-bottom: 2px solid #000;
            padding-bottom: 10px;
        }
        .header img {
            max-height: 80px;
            margin-bottom: 5px;
        }
        .header h1 {
            font-size: 14pt;
            margin: 5px 0;
            font-weight: bold;
        }
        .header p {
            font-size: 9pt;
            margin: 2px 0;
        }
        .page-header {
            text-align: center;
            margin-bottom: 15px;
            border-bottom: 2px solid #000;
            padding-bottom: 10px;
        }
        .page-header img {
            max-height: 80px;
            margin-bottom: 5px;
        }
        .page-header p {
            font-size: 9pt;
            margin: 2px 0;
        }
        .turma-header {
            background-color: #e9ecef;
            padding: 8px;
            font-weight: bold;
            font-size: 10pt;
            margin-bottom: 10px;
            border: 1px solid #dee2e6;
        }
        table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 20px;
            page-break-inside: avoid;
        }
        th, td {
            border: 1px solid #000;
            padding: 4px;
            text-align: center;
            font-size: 8pt;
        }
        th {
            background-color: #f8f9fa;
            font-weight: bold;
        }
        .horario-time {
            background-color: #f8f9fa;
            font-weight: bold;
            width: 80px;
        }
        .horario-cell {
            min-height: 40px;
            vertical-align: middle;
        }
        .disciplina-badge {
            font-weight: bold;
            font-size: 8pt;
            display: block;
            margin-bottom: 2px;
        }
        .professor-name {
            font-size: 7pt;
            color: #495057;
        }
        .intervalo {
            background-color: #fff3cd;
            font-weight: bold;
            text-align: center;
        }
        .empty {
            background-color: #ffffff;
        }
    </style>
</head>
<body>
    @if(isset($grades) && count($grades) > 0)
        @foreach($grades as $turmaId => $data)
            @php
                $turma = $data['turma'];
                $grade = $data['grade'];
                $horarios = $data['horarios'];
                
                // Cores para disciplinas (gerar baseado no nome)
                $coresDisciplinas = [];
                $disciplinasUnicas = [];
                foreach ($grade as $hora => $dias) {
                    foreach ($dias as $dia => $horario) {
                        if ($horario && $horario->disciplina) {
                            $disciplinasUnicas[$horario->disciplina->id] = $horario->disciplina->nome;
                        }
                    }
                }
                $paletaCores = [
                    '#d4edda', '#fff3cd', '#d1ecf1', '#f8d7da', 
                    '#e2e3e5', '#d4edda', '#cce5ff', '#ffe6cc',
                    '#e6f3ff', '#ffe6f0', '#f0e6ff', '#fff0e6'
                ];
                $corIndex = 0;
                foreach ($disciplinasUnicas as $id => $nome) {
                    $coresDisciplinas[$id] = $paletaCores[$corIndex % count($paletaCores)];
                    $corIndex++;
                }
            @endphp
            
            <div style="page-break-after: always;">
                <div class="page-header">
                    @if(!empty($logotipoBase64))
                        <img src="{{ $logotipoBase64 }}" alt="Logotipo da Escola">
                    @endif
                    <p>Ano Letivo: {{ $anoLetivo->ano ?? '' }}</p>
                    <p><strong>HORÁRIOS DE AULAS</strong></p>
                </div>
                <div class="turma-header">
                    Sala: {{ $turma->codigo ?? '' }} - {{ $turma->nome ?? 'Turma #' . $turmaId }}
                </div>
                
                <table>
                    <thead>
                        <tr>
                            <th class="horario-time">Horário</th>
                            @foreach($diasSemana as $dia)
                                <th>{{ $diasAbreviados[$dia] }}</th>
                            @endforeach
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($horarios as $horarioInfo)
                            @php
                                $horaInicio = $horarioInfo['inicio'];
                                $isIntervalo = isset($horarioInfo['tipo']) && $horarioInfo['tipo'] === 'intervalo';
                            @endphp
                            <tr>
                                <td class="horario-time" style="{{ $isIntervalo ? 'background-color: #fff3cd;' : '' }}">
                                    {{ $horarioInfo['display'] }}
                                </td>
                                @if($isIntervalo)
                                    <td colspan="{{ count($diasSemana) }}" class="intervalo">
                                        Intervalo para Lanche
                                    </td>
                                @else
                                    @foreach($diasSemana as $dia)
                                        @php
                                            $horario = $grade[$horaInicio][$dia] ?? null;
                                            $corFundo = $horario && $horario->disciplina ? ($coresDisciplinas[$horario->disciplina->id] ?? '#ffffff') : '#ffffff';
                                        @endphp
                                        <td class="horario-cell {{ !$horario ? 'empty' : '' }}" 
                                            style="background-color: {{ $corFundo }};">
                                            @if($horario)
                                                <span class="disciplina-badge">
                                                    {{ $horario->disciplina->nome }}
                                                </span>
                                                <span class="professor-name">
                                                    {{ $horario->professor->user->name }}
                                                </span>
                                            @else
                                                <span>-</span>
                                            @endif
                                        </td>
                                    @endforeach
                                @endif
                            </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
        @endforeach
    @else
        <p style="text-align: center; padding: 20px;">Nenhum horário registrado</p>
    @endif
</body>
</html>

