<!DOCTYPE html>
<html lang="pt">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <title>@yield('title', 'Inscrição - ' . \App\Models\Configuracao::get('escola', 'Colégio'))</title>
    
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.0/font/bootstrap-icons.css">
    
    <style>
        :root {
            --cor-principal: {{ \App\Models\Tema::getTemaAtivo()->cor_principal ?? '#0d6efd' }};
        }
        
        body {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            min-height: 100vh;
            padding: 20px 0;
        }
        
        .public-container {
            max-width: 900px;
            margin: 0 auto;
        }
        
        .public-card {
            background: white;
            border-radius: 15px;
            box-shadow: 0 10px 40px rgba(0,0,0,0.2);
            overflow: hidden;
        }
        
        .public-header {
            background: var(--cor-principal);
            color: white;
            padding: 30px;
            text-align: center;
        }
        
        .public-header h1 {
            margin: 0;
            font-size: 2rem;
            font-weight: bold;
        }
        
        .public-header p {
            margin: 10px 0 0 0;
            opacity: 0.9;
        }
        
        .public-body {
            padding: 30px;
        }
        
        .btn-primary-custom {
            background-color: var(--cor-principal);
            border-color: var(--cor-principal);
        }
        
        .btn-primary-custom:hover {
            background-color: #0056b3;
            border-color: #0056b3;
        }
        
        .section-title {
            color: var(--cor-principal);
            font-weight: bold;
            margin-top: 20px;
            margin-bottom: 15px;
            padding-bottom: 10px;
            border-bottom: 2px solid var(--cor-principal);
        }
        
        .required {
            color: red;
        }
    </style>
</head>
<body>
    <div class="public-container">
        <div class="public-card">
            <div class="public-header">
                <h1>{{ \App\Models\Configuracao::get('escola', 'Colégio Premium') }}</h1>
                <p>Formulário de Inscrição Online</p>
            </div>
            
            <div class="public-body">
                @if(session('success'))
                    <div class="alert alert-success alert-dismissible fade show" role="alert">
                        {{ session('success') }}
                        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                    </div>
                @endif
                
                @if(session('error'))
                    <div class="alert alert-danger alert-dismissible fade show" role="alert">
                        {{ session('error') }}
                        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                    </div>
                @endif
                
                @if($errors->any())
                    <div class="alert alert-danger">
                        <ul class="mb-0">
                            @foreach($errors->all() as $error)
                                <li>{{ $error }}</li>
                            @endforeach
                        </ul>
                    </div>
                @endif
                
                @yield('content')
            </div>
        </div>
    </div>
    
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    @stack('scripts')
</body>
</html>
