@extends('layouts.app')

@section('title', 'Notificações - SIGE')

@section('content')
<div class="row">
    <div class="col-12">
        <div class="d-flex justify-content-between align-items-center mb-3">
            <h4 class="mb-0">
                <i class="bi bi-bell text-primary me-2"></i>
                Notificações
            </h4>
            <form action="{{ route('notifications.read-all') }}" method="POST" class="d-inline">
                @csrf
                <button type="submit" class="btn btn-sm btn-outline-primary">
                    <i class="bi bi-check-all me-1"></i> Marcar todas como lidas
                </button>
            </form>
        </div>
    </div>
</div>

@if($notifications->count() > 0)
    <div class="list-group">
        @foreach($notifications as $notification)
            <a href="{{ $notification->link ?? '#' }}" 
               class="list-group-item list-group-item-action {{ !$notification->read ? 'list-group-item-primary' : '' }}"
               onclick="if(event.target.tagName !== 'BUTTON') { markAsRead({{ $notification->id }}); }">
                <div class="d-flex w-100 justify-content-between">
                    <h6 class="mb-1">
                        @if(!$notification->read)
                            <span class="badge bg-primary me-2">Nova</span>
                        @endif
                        {{ $notification->title }}
                    </h6>
                    <small>{{ $notification->created_at->diffForHumans() }}</small>
                </div>
                <p class="mb-1">{{ $notification->message }}</p>
                <form action="{{ route('notifications.read', $notification) }}" method="POST" class="d-inline" onsubmit="event.stopPropagation(); return false;">
                    @csrf
                    <button type="submit" class="btn btn-sm btn-outline-secondary" onclick="markAsRead({{ $notification->id }}); return false;">
                        <i class="bi bi-check"></i> Marcar como lida
                    </button>
                </form>
            </a>
        @endforeach
    </div>

    <div class="mt-3">
        {{ $notifications->links() }}
    </div>
@else
    <div class="alert alert-info text-center">
        <i class="bi bi-inbox display-4 d-block mb-3"></i>
        Nenhuma notificação encontrada.
    </div>
@endif

<script>
function markAsRead(notificationId) {
    fetch(`/notifications/${notificationId}/read`, {
        method: 'POST',
        headers: {
            'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').content,
            'Content-Type': 'application/json',
            'Accept': 'application/json'
        }
    })
    .then(response => response.json())
    .then(data => {
        if (data.success) {
            location.reload();
        }
    });
}
</script>
@endsection
