@extends('layouts.app')

@section('title', 'Dashboard - Professor')

@section('content')
<div class="row">
    <div class="col-12">
        <div class="d-flex justify-content-between align-items-center mb-3">
            <h4 class="mb-0">
                <i class="bi bi-clock text-primary me-2"></i>
                Meus Horários
            </h4>
            <div>
                @php
                    $anoExibir = date('Y');
                    if ($anoLetivoAtivo) {
                        $anoRaw = $anoLetivoAtivo->getRawOriginal('ano');
                        if (strpos($anoRaw, '/') !== false) {
                            $anoExibir = explode('/', $anoRaw)[1];
                        } else {
                            $anoExibir = $anoRaw;
                        }
                    }
                @endphp
                <span class="badge bg-primary">{{ $anoExibir }}</span>
            </div>
        </div>
    </div>
</div>

<!-- Horários -->
@if($horarios->count() > 0)
    @php
        $diasSemana = ['Segunda', 'Terça', 'Quarta', 'Quinta', 'Sexta'];
        
        // Organizar horários por dia
        $horariosPorDia = [];
        foreach ($diasSemana as $dia) {
            $horariosPorDia[$dia] = $horarios->filter(function($h) use ($dia) {
                return $h->dia_semana === $dia;
            })->sortBy('hora_inicio')->values();
        }
        
        // Coletar todos os horários únicos
        $todosHorarios = collect();
        foreach ($horariosPorDia as $dia => $horariosDia) {
            foreach ($horariosDia as $horario) {
                $todosHorarios->push([
                    'hora_inicio' => $horario->hora_inicio,
                    'hora_fim' => $horario->hora_fim,
                    'dia' => $dia,
                    'horario' => $horario
                ]);
            }
        }
        $horariosUnicos = $todosHorarios->unique(function($item) {
            return \Carbon\Carbon::parse($item['hora_inicio'])->format('H:i');
        })->sortBy('hora_inicio')->values();
        
        // Criar estrutura de grade
        $grade = [];
        foreach ($horariosUnicos as $horarioUnico) {
            $horaFormatada = \Carbon\Carbon::parse($horarioUnico['hora_inicio'])->format('H:i');
            $horaCarbon = \Carbon\Carbon::parse($horarioUnico['hora_inicio']);
            $grade[$horaFormatada] = [];
            
            foreach ($diasSemana as $dia) {
                $horario = $horariosPorDia[$dia]->first(function($h) use ($horaCarbon) {
                    $horaInicio = \Carbon\Carbon::parse($h->hora_inicio);
                    return $horaInicio->format('H:i') === $horaCarbon->format('H:i');
                });
                
                $grade[$horaFormatada][$dia] = $horario;
            }
        }
    @endphp
    
    <div class="card mb-4">
        <div class="card-header bg-white">
            <h5 class="mb-0">
                <i class="bi bi-calendar-week text-primary me-2"></i>
                Horários Semanais
            </h5>
        </div>
        <div class="card-body">
            <div class="table-responsive">
                <table class="table table-bordered table-sm text-center" style="font-size: 0.9rem;">
                    <thead class="table-light">
                        <tr>
                            <th style="width: 120px;">Horário</th>
                            @foreach($diasSemana as $dia)
                                <th>{{ $dia }}</th>
                            @endforeach
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($grade as $hora => $aulas)
                            <tr>
                                <td class="fw-bold">
                                    @php
                                        $horarioUnico = $horariosUnicos->first(function($h) use ($hora) {
                                            return \Carbon\Carbon::parse($h['hora_inicio'])->format('H:i') === $hora;
                                        });
                                    @endphp
                                    {{ $hora }} - {{ \Carbon\Carbon::parse($horarioUnico['hora_fim'])->format('H:i') }}
                                </td>
                                @foreach($diasSemana as $dia)
                                    <td>
                                        @if(isset($aulas[$dia]) && $aulas[$dia])
                                            @php
                                                $aula = $aulas[$dia];
                                            @endphp
                                            <div class="p-2" style="background-color: #f8f9fa; border-radius: 4px;">
                                                <strong class="d-block">{{ $aula->disciplina->nome ?? '-' }}</strong>
                                                <small class="text-muted d-block">
                                                    {{ $aula->turma->codigo ?? '-' }} - {{ $aula->turma->nome ?? '-' }}
                                                </small>
                                                @if($aula->sala)
                                                    <small class="text-info d-block">
                                                        <i class="bi bi-door-open"></i> {{ $aula->sala }}
                                                    </small>
                                                @endif
                                            </div>
                                        @else
                                            <span class="text-muted">-</span>
                                        @endif
                                    </td>
                                @endforeach
                            </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
        </div>
    </div>
@else
    <div class="alert alert-info text-center">
        <i class="bi bi-calendar-x display-4 d-block mb-3"></i>
        <h5>Nenhum horário disponível</h5>
        <p class="text-muted mb-0">Você ainda não possui horários cadastrados.</p>
    </div>
@endif
@endsection

