@extends('layouts.app')

@section('title', 'Meu Perfil - Professor')

@section('content')
<div class="row">
    <div class="col-12">
        <div class="d-flex justify-content-between align-items-center mb-3">
            <h4 class="mb-0">
                <i class="bi bi-person text-secondary me-2"></i>
                Meu Perfil
            </h4>
            <a href="{{ route('professor.dashboard') }}" class="btn btn-sm btn-secondary">
                <i class="bi bi-arrow-left me-1"></i> Voltar
            </a>
        </div>
    </div>

    <div class="col-md-6">
        <div class="card border-0 shadow-sm">
            <div class="card-header bg-white border-bottom">
                <h5 class="card-title mb-0">Informações Pessoais</h5>
            </div>
            <div class="card-body">
                <div class="mb-3">
                    <strong>Nome:</strong>
                    <p class="mb-0">{{ $professor->user->name }}</p>
                </div>
                <div class="mb-3">
                    <strong>Email:</strong>
                    <p class="mb-0">{{ $professor->user->email }}</p>
                </div>
                <div class="mb-3">
                    <strong>Número de Funcionário:</strong>
                    <p class="mb-0">{{ $professor->numero_funcionario }}</p>
                </div>
                @if($professor->telefone)
                    <div class="mb-3">
                        <strong>Telefone:</strong>
                        <p class="mb-0">{{ $professor->telefone }}</p>
                    </div>
                @endif
                @if($professor->endereco)
                    <div class="mb-3">
                        <strong>Endereço:</strong>
                        <p class="mb-0">{{ $professor->endereco }}</p>
                    </div>
                @endif
                @if($professor->data_nascimento)
                    <div class="mb-3">
                        <strong>Data de Nascimento:</strong>
                        <p class="mb-0">{{ $professor->data_nascimento->format('d/m/Y') }}</p>
                    </div>
                @endif
                <div class="mb-3">
                    <strong>Status:</strong>
                    <p class="mb-0">
                        @if($professor->user && $professor->user->is_active)
                            <span class="badge bg-success">Activo</span>
                        @else
                            <span class="badge bg-danger">Bloqueado</span>
                        @endif
                    </p>
                </div>
            </div>
        </div>
    </div>

    <div class="col-md-6">
        <div class="card border-0 shadow-sm">
            <div class="card-header bg-white border-bottom">
                <h5 class="card-title mb-0">
                    Disciplinas Lecionadas
                    @if($anoLetivo)
                        <small class="text-muted">({{ $anoLetivo->ano }})</small>
                    @endif
                </h5>
            </div>
            <div class="card-body">
                @if($disciplinas->count() > 0)
                    <div class="table-responsive">
                        <table class="table table-sm">
                            <thead>
                                <tr>
                                    <th>Disciplina</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($disciplinas as $disciplina)
                                    <tr>
                                        <td>{{ $disciplina->nome }}</td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                @else
                    <p class="text-muted mb-0">Nenhuma disciplina atribuída</p>
                @endif
            </div>
        </div>
    </div>
</div>
@endsection

