@extends('layouts.app')

@section('title', 'Planos Trimestrais - Professor')

@section('content')
<div class="row">
    <div class="col-12">
        <div class="d-flex justify-content-between align-items-center mb-2" style="border-bottom: 1px solid #dee2e6; padding-bottom: 8px;">
            <h5 class="mb-0" style="font-weight: 600;">Planos Trimestrais</h5>
            <a href="{{ route('professor.planos.create') }}" class="btn btn-sm btn-primary">
                <i class="bi bi-plus-circle"></i> Novo
            </a>
        </div>

        @if($planos->count() > 0)
            <div class="js-ajax-pagination">
                <div class="table-responsive">
                    <table class="table table-sm table-bordered" style="font-size: 0.85rem;">
                    <thead style="background-color: #f8f9fa;">
                        <tr>
                            <th style="padding: 6px;">Disciplina</th>
                            <th style="padding: 6px;">Turma</th>
                            <th style="padding: 6px;">Trimestre</th>
                            <th style="padding: 6px;">Acções</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($planos as $plano)
                            <tr>
                                <td style="padding: 5px;">{{ $plano->disciplina->nome }}</td>
                                <td style="padding: 5px;">{{ $plano->turma->codigo }}</td>
                                <td style="padding: 5px;">{{ $plano->trimestre->nome ?? 'N/A' }}</td>
                                <td style="padding: 5px;">
                                    <div style="display: flex; gap: 4px;">
                                        <a href="{{ route('professor.planos.edit', $plano) }}" class="btn btn-sm" style="padding: 2px 6px; font-size: 0.75rem; background: #fff3cd; color: #856404; border: none;" title="Editar">
                                            <i class="bi bi-pencil"></i>
                                        </a>
                                        @if($plano->arquivo)
                                            <a href="{{ route('professor.planos.visualizar', $plano) }}" target="_blank" class="btn btn-sm" style="padding: 2px 6px; font-size: 0.75rem; background: #e7f3ff; color: #0066cc; border: none;" title="Visualizar">
                                                <i class="bi bi-eye"></i>
                                            </a>
                                            <a href="{{ route('professor.planos.download', $plano) }}" class="btn btn-sm" style="padding: 2px 6px; font-size: 0.75rem; background: #d4edda; color: #155724; border: none;" title="Download">
                                                <i class="bi bi-download"></i>
                                            </a>
                                        @endif
                                        <form action="{{ route('professor.planos.destroy', $plano) }}" method="POST" class="d-inline" onsubmit="return confirm('Excluir?');">
                                            @csrf
                                            @method('DELETE')
                                            <button type="submit" class="btn btn-sm" style="padding: 2px 6px; font-size: 0.75rem; background: #f8d7da; color: #721c24; border: none;" title="Excluir">
                                                <i class="bi bi-trash"></i>
                                            </button>
                                        </form>
                                    </div>
                                </td>
                            </tr>
                        @endforeach
                    </tbody>
                    </table>
                </div>
                
                @if(method_exists($planos, 'links'))
                    <div class="mt-3">
                        {{ $planos->appends(request()->query())->links() }}
                    </div>
                @endif
            </div>
        @else
            <div class="alert alert-info text-center" style="padding: 20px;">
                Nenhum plano enviado ainda.
            </div>
        @endif
    </div>
</div>
@endsection
