@extends('layouts.app')

@section('title', 'Ver Plano Trimestral - Professor')

@section('content')
<div class="row">
    <div class="col-md-8 mx-auto">
        <div class="card">
            <div class="card-header bg-primary-custom text-white">
                <h4 class="mb-0">
                    <i class="bi bi-calendar-check me-2"></i>
                    Plano Trimestral
                </h4>
            </div>
            <div class="card-body">
                <div class="mb-3">
                    <strong>Disciplina:</strong> {{ $plano->disciplina->nome }}
                </div>
                <div class="mb-3">
                    <strong>Turma:</strong> {{ $plano->turma->codigo }} - {{ $plano->turma->nome }}
                </div>
                <div class="mb-3">
                    <strong>Trimestre:</strong> {{ $plano->trimestre->nome ?? 'N/A' }}
                </div>
                <div class="mb-3">
                    <strong>Arquivo:</strong>
                    @if($plano->nome_arquivo)
                        <i class="bi bi-file-earmark-pdf text-danger me-1"></i>
                        {{ $plano->nome_arquivo }}
                    @else
                        <span class="text-muted">N/A</span>
                    @endif
                </div>
                @if($plano->observacoes)
                    <div class="mb-3">
                        <strong>Observações:</strong>
                        <p class="mt-2">{{ $plano->observacoes }}</p>
                    </div>
                @endif
                <div class="mb-3">
                    <strong>Data de Upload:</strong> {{ $plano->created_at->format('d/m/Y H:i') }}
                </div>
                <div class="d-flex gap-2 mt-4">
                    <a href="{{ route('professor.planos.index') }}" class="btn btn-secondary">
                        <i class="bi bi-arrow-left me-1"></i> Voltar
                    </a>
                    <a href="{{ route('professor.planos.edit', $plano) }}" class="btn btn-warning">
                        <i class="bi bi-pencil me-1"></i> Editar
                    </a>
                    @if($plano->arquivo)
                        <a href="{{ route('professor.planos.visualizar', $plano) }}" target="_blank" class="btn btn-primary">
                            <i class="bi bi-file-earmark-text me-1"></i> Visualizar
                        </a>
                        <a href="{{ route('professor.planos.download', $plano) }}" class="btn btn-success">
                            <i class="bi bi-download me-1"></i> Download
                        </a>
                    @endif
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

