@extends('layouts.app')

@section('title', 'TPCs - Professor')

@section('content')
<div class="row">
    <div class="col-12">
        <div class="d-flex justify-content-between align-items-center mb-3">
            <h4 class="mb-0">
                <i class="bi bi-file-earmark-text text-primary me-2"></i>
                TPCs
            </h4>
            <div>
                <span class="badge bg-primary me-2">{{ $anoLetivo->ano ?? 'N/A' }}</span>
                <a href="{{ route('professor.tpcs.create') }}" class="btn btn-primary-custom">
                    <i class="bi bi-plus-circle me-1"></i> Novo TPC
                </a>
            </div>
        </div>

        @if($tpcs->count() > 0)
            <div class="table-responsive">
                <table class="table table-bordered table-sm" style="font-size: 0.75rem;">
                    <style>
                        .table-bordered th, .table-bordered td {
                            padding: 0.3rem 0.5rem !important;
                        }
                    </style>
                    <thead>
                        <tr>
                            <th>Título</th>
                            <th>Disciplina</th>
                            <th>Turma</th>
                            <th>Data Entrega</th>
                            <th>Valor</th>
                            <th>Acções</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($tpcs as $tpc)
                            <tr>
                                <td>{{ $tpc->titulo }}</td>
                                <td>{{ $tpc->disciplina->nome }}</td>
                                <td>{{ $tpc->turma->codigo }} - {{ $tpc->turma->nome }}</td>
                                <td>{{ $tpc->data_entrega->format('d/m/Y') }}</td>
                                <td>{{ $tpc->valor ?? 'N/A' }}</td>
                                <td>
                                    <div class="btn-group btn-group-sm" role="group">
                                        <a href="{{ route('professor.tpcs.show', $tpc) }}" class="btn btn-outline-info" style="font-size: 0.7rem; padding: 0.2rem 0.4rem;" title="Ver">
                                            <i class="bi bi-eye"></i>
                                        </a>
                                        <a href="{{ route('professor.tpcs.edit', $tpc) }}" class="btn btn-outline-primary" style="font-size: 0.7rem; padding: 0.2rem 0.4rem;" title="Editar">
                                            <i class="bi bi-pencil"></i>
                                        </a>
                                        @if($tpc->arquivo)
                                            <a href="{{ route('professor.tpcs.visualizar', $tpc) }}" target="_blank" class="btn btn-outline-success" style="font-size: 0.7rem; padding: 0.2rem 0.4rem;" title="Visualizar Arquivo">
                                                <i class="bi bi-file-earmark-pdf"></i>
                                            </a>
                                        @endif
                                        <form action="{{ route('professor.tpcs.destroy', $tpc) }}" method="POST" class="d-inline" onsubmit="return confirm('Tem certeza que deseja excluir este TPC?');">
                                            @csrf
                                            @method('DELETE')
                                            <button type="submit" class="btn btn-outline-danger" style="font-size: 0.7rem; padding: 0.2rem 0.4rem;" title="Excluir">
                                                <i class="bi bi-trash"></i>
                                            </button>
                                        </form>
                                    </div>
                                </td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
        @else
            <div class="alert alert-info text-center">
                <i class="bi bi-inbox display-4 d-block mb-3"></i>
                Nenhum TPC criado ainda.
                <a href="{{ route('professor.tpcs.create') }}" class="btn btn-primary-custom mt-3">
                    <i class="bi bi-plus-circle me-1"></i> Criar Primeiro TPC
                </a>
            </div>
        @endif
    </div>
</div>
@endsection

