@extends('layouts.app')

@section('title', 'Minhas Turmas - Professor')

@section('content')
<div class="row">
    <div class="col-12">
        <div class="d-flex justify-content-between align-items-center mb-3">
            <h4 class="mb-0">
                <i class="bi bi-building text-success me-2"></i>
                Minhas Turmas e Disciplinas
            </h4>
            <div>
                <span class="badge bg-primary">{{ $anoLetivoAtivo->ano ?? 'N/A' }}</span>
                <a href="{{ route('professor.dashboard') }}" class="btn btn-sm btn-secondary">
                    <i class="bi bi-arrow-left me-1"></i> Voltar
                </a>
            </div>
        </div>
    </div>

    <div class="col-12">
        <div class="card border-0 shadow-sm">
            <div class="card-body p-2">
                @if(count($alocacoes) > 0)
                    @php
                        $totalTurmas = $alocacoes->pluck('turma_codigo')->unique()->count();
                        $totalDisciplinas = $alocacoes->pluck('disciplina_nome')->unique()->count();
                        $totalAlunos = $alocacoes->sum('total_alunos');
                    @endphp
                    
                    <div class="mb-2 p-2" style="background-color: #f8f9fa; border-radius: 4px; font-size: 0.75rem;">
                        <div class="d-flex flex-wrap gap-3">
                            <span><strong>Total de Turmas:</strong> {{ $totalTurmas }}</span>
                            <span><strong>Total de Disciplinas:</strong> {{ $totalDisciplinas }}</span>
                            <span><strong>Total de Alocações:</strong> {{ count($alocacoes) }}</span>
                            <span><strong>Total de Alunos:</strong> {{ $totalAlunos }}</span>
                        </div>
                    </div>
                    
                    <div class="table-responsive">
                        <table class="table table-bordered table-sm" style="font-size: 0.75rem;">
                            <style>
                                .table-bordered th, .table-bordered td {
                                    padding: 0.3rem 0.5rem !important;
                                }
                                .grupo-classe {
                                    background-color: #e9ecef !important;
                                    font-weight: 600;
                                }
                            </style>
                            <thead>
                                <tr>
                                    <th style="width: 25%;">Classe</th>
                                    <th style="width: 20%;">Turma</th>
                                    <th style="width: 25%;">Disciplina</th>
                                    <th style="width: 10%; text-align: center;">Alunos</th>
                                    <th style="width: 20%; text-align: center;">Acções</th>
                                </tr>
                            </thead>
                            <tbody>
                                @php
                                    $classeAnterior = null;
                                @endphp
                                @foreach($alocacoes as $alocacao)
                                    @php
                                        $classeAtual = $alocacao->turma_codigo;
                                        $novaClasse = $classeAnterior !== $classeAtual;
                                        $classeAnterior = $classeAtual;
                                    @endphp
                                    @if($novaClasse && count($alocacoes) > 1)
                                        <tr class="grupo-classe">
                                            <td colspan="5" style="padding: 0.4rem 0.5rem;">
                                                <strong>{{ $alocacao->turma_codigo }}</strong>
                                                @php
                                                    $disciplinasClasse = $alocacoes->where('turma_codigo', $alocacao->turma_codigo)->pluck('disciplina_nome')->unique()->count();
                                                @endphp
                                                <span class="text-muted" style="font-size: 0.7rem; margin-left: 10px;">
                                                    ({{ $alocacoes->where('turma_codigo', $alocacao->turma_codigo)->count() }} alocação(ões), 
                                                    {{ $disciplinasClasse }} disciplina(s))
                                                </span>
                                            </td>
                                        </tr>
                                    @endif
                                    <tr>
                                        <td>{{ $alocacao->turma_codigo }}</td>
                                        <td>{{ $alocacao->turma_nome }}</td>
                                        <td>
                                            <span class="badge bg-info" style="font-size: 0.7rem;">{{ $alocacao->disciplina_nome }}</span>
                                        </td>
                                        <td class="text-center">{{ $alocacao->total_alunos ?? 0 }}</td>
                                        <td style="text-align: center;">
                                            @if(isset($alocacao->turma_id) && isset($alocacao->disciplina_id))
                                                <a href="{{ route('avaliacoes.create') }}?turma_id={{ $alocacao->turma_id }}&disciplina_id={{ $alocacao->disciplina_id }}" 
                                                   class="btn btn-sm btn-primary" style="font-size: 0.7rem; padding: 0.2rem 0.4rem;" title="Lançar avaliações">
                                                    <i class="bi bi-clipboard-plus"></i> Lançar
                                                </a>
                                                <a href="{{ route('avaliacoes.index') }}?turma_id={{ $alocacao->turma_id }}&disciplina_id={{ $alocacao->disciplina_id }}" 
                                                   class="btn btn-sm btn-outline-info" style="font-size: 0.7rem; padding: 0.2rem 0.4rem;" title="Ver avaliações">
                                                    <i class="bi bi-eye"></i> Ver
                                                </a>
                                            @else
                                                <span class="text-muted" style="font-size: 0.7rem;">Dados incompletos</span>
                                            @endif
                                        </td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                @else
                    <div class="text-center py-5">
                        <i class="bi bi-inbox display-4 text-muted"></i>
                        <p class="text-muted mt-3">Nenhuma turma atribuída</p>
                    </div>
                @endif
            </div>
        </div>
    </div>
</div>
@endsection

