@extends('layouts.public')

@section('title', 'Inscrição Online')

@push('scripts')
<script>
    // Sincronizar campos de data
    document.addEventListener('DOMContentLoaded', function() {
        const diaNasc = document.getElementById('dia_nascimento');
        const mesNasc = document.getElementById('mes_nascimento');
        const anoNasc = document.getElementById('ano_nascimento');
        const dataNasc = document.getElementById('data_nascimento');

        function updateDateField() {
            if (diaNasc && mesNasc && anoNasc && diaNasc.value && mesNasc.value && anoNasc.value) {
                const dia = String(diaNasc.value).padStart(2, '0');
                const mes = String(mesNasc.value).padStart(2, '0');
                const ano = anoNasc.value;
                if (dataNasc) dataNasc.value = `${ano}-${mes}-${dia}`;
            }
        }

        function updateIndividualFields() {
            if (dataNasc && dataNasc.value) {
                const date = new Date(dataNasc.value);
                if (diaNasc) diaNasc.value = date.getDate();
                if (mesNasc) mesNasc.value = date.getMonth() + 1;
                if (anoNasc) anoNasc.value = date.getFullYear();
            }
        }

        if (diaNasc) diaNasc.addEventListener('change', updateDateField);
        if (mesNasc) mesNasc.addEventListener('change', updateDateField);
        if (anoNasc) anoNasc.addEventListener('change', updateDateField);
        if (dataNasc) dataNasc.addEventListener('change', updateIndividualFields);
    });

    let stream = null;
    let video = null;
    let canvas = null;

    function previewFoto(input) {
        if (input.files && input.files[0]) {
            const reader = new FileReader();
            reader.onload = function(e) {
                const preview = document.getElementById('foto-preview');
                if (preview) {
                    preview.innerHTML = `<img src="${e.target.result}" style="width: 100%; height: 100%; object-fit: cover;">`;
                }
            };
            reader.readAsDataURL(input.files[0]);
        }
    }

    function capturarFoto() {
        if (!navigator.mediaDevices || !navigator.mediaDevices.getUserMedia) {
            alert('Seu navegador não suporta captura de vídeo. Use um navegador moderno como Chrome, Firefox ou Edge.');
            return;
        }
        
        const modal = document.createElement('div');
        modal.className = 'modal fade';
        modal.id = 'modal-camera';
        modal.setAttribute('data-bs-backdrop', 'static');
        modal.setAttribute('data-bs-keyboard', 'false');
        modal.setAttribute('tabindex', '-1');
        modal.innerHTML = `
            <div class="modal-dialog modal-lg">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title">Capturar Foto do Aluno</h5>
                        <button type="button" class="btn-close" onclick="fecharCamera()"></button>
                    </div>
                    <div class="modal-body text-center">
                        <video id="video-camera" autoplay playsinline style="width: 100%; max-width: 500px; border: 2px solid #333;"></video>
                        <canvas id="canvas-camera" style="display: none;"></canvas>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-primary" onclick="tirarFoto()">
                            <i class="bi bi-camera-fill"></i> Capturar Foto
                        </button>
                        <button type="button" class="btn btn-secondary" onclick="fecharCamera()">Cancelar</button>
                    </div>
                </div>
            </div>
        `;
        document.body.appendChild(modal);
        
        setTimeout(function() {
            if (typeof window.bootstrap !== 'undefined' && window.bootstrap.Modal) {
                modal.removeAttribute('aria-hidden');
                const bsModal = new window.bootstrap.Modal(modal, { backdrop: 'static', keyboard: false });
                modal.addEventListener('shown.bs.modal', function() {
                    video = document.getElementById('video-camera');
                    canvas = document.getElementById('canvas-camera');
                    navigator.mediaDevices.getUserMedia({ video: { facingMode: 'user' } })
                        .then(function(mediaStream) {
                            stream = mediaStream;
                            if (video) video.srcObject = stream;
                        })
                        .catch(function(err) {
                            alert('Erro ao acessar a câmera: ' + err.message);
                            fecharCamera();
                        });
                }, { once: true });
                setTimeout(() => { modal.removeAttribute('aria-hidden'); bsModal.show(); }, 10);
            }
        }, 100);
    }

    function tirarFoto() {
        if (!video || !canvas) return;
        canvas.width = video.videoWidth;
        canvas.height = video.videoHeight;
        const ctx = canvas.getContext('2d');
        ctx.drawImage(video, 0, 0);
        const fotoBase64 = canvas.toDataURL('image/jpeg', 0.8);
        const fotoBase64Input = document.getElementById('foto_base64');
        if (fotoBase64Input) fotoBase64Input.value = fotoBase64;
        const preview = document.getElementById('foto-preview');
        if (preview) preview.innerHTML = `<img src="${fotoBase64}" style="width: 100%; height: 100%; object-fit: cover;">`;
        const fotoInput = document.getElementById('foto');
        if (fotoInput) fotoInput.value = '';
        fecharCamera();
    }

    function fecharCamera() {
        if (stream) {
            stream.getTracks().forEach(track => track.stop());
            stream = null;
        }
        const modal = document.getElementById('modal-camera');
        if (modal) {
            try {
                if (typeof bootstrap !== 'undefined' && bootstrap.Modal) {
                    const bsModal = bootstrap.Modal.getInstance(modal);
                    if (bsModal) bsModal.hide();
                }
            } catch(e) {}
            setTimeout(() => { if (modal && modal.parentNode) modal.remove(); }, 300);
        }
    }

    function removerFoto() {
        const fotoInput = document.getElementById('foto');
        const fotoBase64Input = document.getElementById('foto_base64');
        const preview = document.getElementById('foto-preview');
        if (fotoInput) fotoInput.value = '';
        if (fotoBase64Input) fotoBase64Input.value = '';
        if (preview) preview.innerHTML = '<span class="text-muted small">Sem foto</span>';
    }

    let formSubmitting = false;
    function preventDoubleSubmit(form) {
        if (formSubmitting) return false;
        formSubmitting = true;
        const submitBtn = form.querySelector('button[type="submit"]');
        if (submitBtn) {
            submitBtn.disabled = true;
            submitBtn.innerHTML = '<i class="bi bi-hourglass-split"></i> A submeter...';
        }
        return true;
    }
</script>
@endpush

@section('content')
<form method="POST" action="{{ route('public.inscricao.store') }}" enctype="multipart/form-data" id="form-inscricao" onsubmit="return preventDoubleSubmit(this)">
    @csrf

    <h3 class="section-title">Dados do Aluno</h3>
    
    <div class="row mb-3">
        <div class="col-md-3">
            <label for="foto" class="form-label">Foto do Aluno</label>
            <div id="foto-preview" style="width: 100%; max-width: 120px; height: 150px; border: 2px solid #333; display: flex; align-items: center; justify-content: center; background-color: #f9f9f9; margin-bottom: 5px;">
                <span class="text-muted small">Sem foto</span>
            </div>
            <input type="file" class="form-control form-control-sm @error('foto') is-invalid @enderror" 
                   id="foto" name="foto" accept="image/jpeg,image/jpg,image/png" onchange="previewFoto(this)">
            <input type="hidden" id="foto_base64" name="foto_base64">
            @error('foto')
                <div class="invalid-feedback">{{ $message }}</div>
            @enderror
            <div class="btn-group btn-group-sm w-100 mt-1">
                <button type="button" class="btn btn-outline-primary" onclick="capturarFoto()">
                    <i class="bi bi-camera"></i> Capturar
                </button>
                <button type="button" class="btn btn-outline-danger" onclick="removerFoto()">
                    <i class="bi bi-trash"></i> Remover
                </button>
            </div>
        </div>

        <div class="col-md-9">
            <div class="row">
                <div class="col-md-12 mb-2">
                    <label for="name" class="form-label">Nome Completo <span class="required">*</span></label>
                    <input type="text" class="form-control @error('name') is-invalid @enderror" 
                           id="name" name="name" value="{{ old('name') }}" required>
                    @error('name')
                        <div class="invalid-feedback">{{ $message }}</div>
                    @enderror
                </div>

                <div class="col-md-4 mb-2">
                    <label for="local_nascimento" class="form-label">Local de Nascimento</label>
                    <input type="text" class="form-control @error('local_nascimento') is-invalid @enderror" 
                           id="local_nascimento" name="local_nascimento" value="{{ old('local_nascimento') }}">
                    @error('local_nascimento')
                        <div class="invalid-feedback">{{ $message }}</div>
                    @enderror
                </div>

                <div class="col-md-2 mb-2">
                    <label for="dia_nascimento" class="form-label">Dia</label>
                    <input type="number" class="form-control" id="dia_nascimento" name="dia_nascimento" min="1" max="31" value="{{ old('dia_nascimento') }}">
                </div>

                <div class="col-md-2 mb-2">
                    <label for="mes_nascimento" class="form-label">Mês</label>
                    <input type="number" class="form-control" id="mes_nascimento" name="mes_nascimento" min="1" max="12" value="{{ old('mes_nascimento') }}">
                </div>

                <div class="col-md-2 mb-2">
                    <label for="ano_nascimento" class="form-label">Ano</label>
                    <input type="number" class="form-control" id="ano_nascimento" name="ano_nascimento" min="1900" max="{{ date('Y') }}" value="{{ old('ano_nascimento') }}">
                </div>

                <div class="col-md-2 mb-2">
                    <label for="data_nascimento" class="form-label">Ou Data Completa</label>
                    <input type="date" class="form-control" id="data_nascimento" name="data_nascimento" value="{{ old('data_nascimento') }}">
                </div>
            </div>
        </div>
    </div>

    <div class="row mb-3">
        <div class="col-md-3">
            <label for="naturalidade" class="form-label">Naturalidade</label>
            <input type="text" class="form-control @error('naturalidade') is-invalid @enderror" 
                   id="naturalidade" name="naturalidade" value="{{ old('naturalidade') }}">
            @error('naturalidade')
                <div class="invalid-feedback">{{ $message }}</div>
            @enderror
        </div>

        <div class="col-md-3">
            <label for="distrito_natural" class="form-label">Distrito</label>
            <input type="text" class="form-control @error('distrito_natural') is-invalid @enderror" 
                   id="distrito_natural" name="distrito_natural" value="{{ old('distrito_natural') }}">
            @error('distrito_natural')
                <div class="invalid-feedback">{{ $message }}</div>
            @enderror
        </div>

        <div class="col-md-3">
            <label for="provincia_natural" class="form-label">Província</label>
            <select class="form-select @error('provincia_natural') is-invalid @enderror" id="provincia_natural" name="provincia_natural">
                <option value="">Selecione</option>
                <option value="Cabo Delgado" {{ old('provincia_natural') == 'Cabo Delgado' ? 'selected' : '' }}>Cabo Delgado</option>
                <option value="Gaza" {{ old('provincia_natural') == 'Gaza' ? 'selected' : '' }}>Gaza</option>
                <option value="Inhambane" {{ old('provincia_natural') == 'Inhambane' ? 'selected' : '' }}>Inhambane</option>
                <option value="Manica" {{ old('provincia_natural') == 'Manica' ? 'selected' : '' }}>Manica</option>
                <option value="Maputo" {{ old('provincia_natural') == 'Maputo' ? 'selected' : '' }}>Maputo</option>
                <option value="Maputo Cidade" {{ old('provincia_natural') == 'Maputo Cidade' ? 'selected' : '' }}>Maputo Cidade</option>
                <option value="Nampula" {{ old('provincia_natural') == 'Nampula' ? 'selected' : '' }}>Nampula</option>
                <option value="Niassa" {{ old('provincia_natural') == 'Niassa' ? 'selected' : '' }}>Niassa</option>
                <option value="Sofala" {{ old('provincia_natural') == 'Sofala' ? 'selected' : '' }}>Sofala</option>
                <option value="Tete" {{ old('provincia_natural') == 'Tete' ? 'selected' : '' }}>Tete</option>
                <option value="Zambézia" {{ old('provincia_natural') == 'Zambézia' ? 'selected' : '' }}>Zambézia</option>
            </select>
            @error('provincia_natural')
                <div class="invalid-feedback">{{ $message }}</div>
            @enderror
        </div>

        <div class="col-md-2">
            <label for="tipo_documento" class="form-label">Tipo Doc. <span class="required">*</span></label>
            <select class="form-select @error('tipo_documento') is-invalid @enderror" id="tipo_documento" name="tipo_documento" required>
                <option value="">Selecione</option>
                <option value="BI" {{ old('tipo_documento') == 'BI' ? 'selected' : '' }}>BI</option>
                <option value="Cédula" {{ old('tipo_documento') == 'Cédula' ? 'selected' : '' }}>Cédula</option>
                <option value="Passaporte" {{ old('tipo_documento') == 'Passaporte' ? 'selected' : '' }}>Passaporte</option>
            </select>
            @error('tipo_documento')
                <div class="invalid-feedback">{{ $message }}</div>
            @enderror
        </div>

        <div class="col-md-3">
            <label for="num_documento" class="form-label">Nº do Documento</label>
            <input type="text" class="form-control @error('num_documento') is-invalid @enderror" 
                   id="num_documento" name="num_documento" value="{{ old('num_documento') }}">
            @error('num_documento')
                <div class="invalid-feedback">{{ $message }}</div>
            @enderror
        </div>

        <div class="col-md-3">
            <label for="local_emissao" class="form-label">Local de Emissão</label>
            <input type="text" class="form-control @error('local_emissao') is-invalid @enderror" 
                   id="local_emissao" name="local_emissao" value="{{ old('local_emissao') }}">
            @error('local_emissao')
                <div class="invalid-feedback">{{ $message }}</div>
            @enderror
        </div>

        <div class="col-md-2">
            <label for="data_emissao" class="form-label">Data Emissão</label>
            <input type="date" class="form-control @error('data_emissao') is-invalid @enderror" 
                   id="data_emissao" name="data_emissao" value="{{ old('data_emissao') }}">
            @error('data_emissao')
                <div class="invalid-feedback">{{ $message }}</div>
            @enderror
        </div>

        <div class="col-md-2">
            <label for="genero" class="form-label">Género</label>
            <select class="form-select @error('genero') is-invalid @enderror" id="genero" name="genero">
                <option value="">Selecione</option>
                <option value="M" {{ old('genero') == 'M' ? 'selected' : '' }}>Masculino</option>
                <option value="F" {{ old('genero') == 'F' ? 'selected' : '' }}>Feminino</option>
                <option value="Outro" {{ old('genero') == 'Outro' ? 'selected' : '' }}>Outro</option>
            </select>
            @error('genero')
                <div class="invalid-feedback">{{ $message }}</div>
            @enderror
        </div>

        <div class="col-md-2">
            <label for="telefone" class="form-label">Telefone</label>
            <input type="text" class="form-control @error('telefone') is-invalid @enderror" 
                   id="telefone" name="telefone" value="{{ old('telefone') }}">
            @error('telefone')
                <div class="invalid-feedback">{{ $message }}</div>
            @enderror
        </div>

        <div class="col-md-6">
            <label for="endereco" class="form-label">Endereço</label>
            <textarea class="form-control @error('endereco') is-invalid @enderror" 
                      id="endereco" name="endereco" rows="2">{{ old('endereco') }}</textarea>
            @error('endereco')
                <div class="invalid-feedback">{{ $message }}</div>
            @enderror
        </div>
    </div>

    <h3 class="section-title">Informação Complementar</h3>
    <small class="text-muted">Para efeitos de benefícios diversos (redução de propinas e uso das instalações para eventos)</small>
    
    <div class="row mb-3">
        <div class="col-md-4">
            <label for="num_irmaos_mais_velhos" class="form-label">N° de Irmãos mais velhos</label>
            <input type="number" min="0" class="form-control @error('num_irmaos_mais_velhos') is-invalid @enderror" 
                   id="num_irmaos_mais_velhos" name="num_irmaos_mais_velhos" value="{{ old('num_irmaos_mais_velhos', 0) }}">
            @error('num_irmaos_mais_velhos')
                <div class="invalid-feedback">{{ $message }}</div>
            @enderror
        </div>

        <div class="col-md-4">
            <label for="num_irmaos_mais_novos" class="form-label">N° de Irmãos mais novos</label>
            <input type="number" min="0" class="form-control @error('num_irmaos_mais_novos') is-invalid @enderror" 
                   id="num_irmaos_mais_novos" name="num_irmaos_mais_novos" value="{{ old('num_irmaos_mais_novos', 0) }}">
            @error('num_irmaos_mais_novos')
                <div class="invalid-feedback">{{ $message }}</div>
            @enderror
        </div>

        <div class="col-md-4">
            <label for="num_irmaos_mesma_idade" class="form-label">N° de Irmãos com a mesma idade</label>
            <input type="number" min="0" class="form-control @error('num_irmaos_mesma_idade') is-invalid @enderror" 
                   id="num_irmaos_mesma_idade" name="num_irmaos_mesma_idade" value="{{ old('num_irmaos_mesma_idade', 0) }}">
            @error('num_irmaos_mesma_idade')
                <div class="invalid-feedback">{{ $message }}</div>
            @enderror
        </div>
    </div>

    <h3 class="section-title">Identificação dos Pais</h3>
    
    <div class="row mb-3">
        <div class="col-md-6">
            <h6 class="fw-bold">Nome do Pai</h6>
            <div class="row">
                <div class="col-md-12 mb-2">
                    <label for="nome_pai" class="form-label">Nome</label>
                    <input type="text" class="form-control @error('nome_pai') is-invalid @enderror" 
                           id="nome_pai" name="nome_pai" value="{{ old('nome_pai') }}">
                    @error('nome_pai')
                        <div class="invalid-feedback">{{ $message }}</div>
                    @enderror
                </div>
                <div class="col-md-12 mb-2">
                    <label for="local_trabalho_pai" class="form-label">Local de Trabalho</label>
                    <input type="text" class="form-control @error('local_trabalho_pai') is-invalid @enderror" 
                           id="local_trabalho_pai" name="local_trabalho_pai" value="{{ old('local_trabalho_pai') }}">
                    @error('local_trabalho_pai')
                        <div class="invalid-feedback">{{ $message }}</div>
                    @enderror
                </div>
                <div class="col-md-6 mb-2">
                    <label for="endereco_pai_bairro" class="form-label">Bairro</label>
                    <input type="text" class="form-control @error('endereco_pai_bairro') is-invalid @enderror" 
                           id="endereco_pai_bairro" name="endereco_pai_bairro" value="{{ old('endereco_pai_bairro') }}">
                    @error('endereco_pai_bairro')
                        <div class="invalid-feedback">{{ $message }}</div>
                    @enderror
                </div>
                <div class="col-md-6 mb-2">
                    <label for="endereco_pai_rua" class="form-label">Avenida/Rua</label>
                    <input type="text" class="form-control @error('endereco_pai_rua') is-invalid @enderror" 
                           id="endereco_pai_rua" name="endereco_pai_rua" value="{{ old('endereco_pai_rua') }}">
                    @error('endereco_pai_rua')
                        <div class="invalid-feedback">{{ $message }}</div>
                    @enderror
                </div>
                <div class="col-md-3 mb-2">
                    <label for="endereco_pai_numero" class="form-label">N°</label>
                    <input type="text" class="form-control @error('endereco_pai_numero') is-invalid @enderror" 
                           id="endereco_pai_numero" name="endereco_pai_numero" value="{{ old('endereco_pai_numero') }}">
                    @error('endereco_pai_numero')
                        <div class="invalid-feedback">{{ $message }}</div>
                    @enderror
                </div>
                <div class="col-md-3 mb-2">
                    <label for="endereco_pai_quarteirao" class="form-label">Quarteirão/Andar</label>
                    <input type="text" class="form-control @error('endereco_pai_quarteirao') is-invalid @enderror" 
                           id="endereco_pai_quarteirao" name="endereco_pai_quarteirao" value="{{ old('endereco_pai_quarteirao') }}">
                    @error('endereco_pai_quarteirao')
                        <div class="invalid-feedback">{{ $message }}</div>
                    @enderror
                </div>
                <div class="col-md-3 mb-2">
                    <label for="endereco_pai_flat" class="form-label">Flat</label>
                    <input type="text" class="form-control @error('endereco_pai_flat') is-invalid @enderror" 
                           id="endereco_pai_flat" name="endereco_pai_flat" value="{{ old('endereco_pai_flat') }}">
                    @error('endereco_pai_flat')
                        <div class="invalid-feedback">{{ $message }}</div>
                    @enderror
                </div>
                <div class="col-md-3 mb-2">
                    <label for="telefone_pai" class="form-label">Telefone</label>
                    <input type="text" class="form-control @error('telefone_pai') is-invalid @enderror" 
                           id="telefone_pai" name="telefone_pai" value="{{ old('telefone_pai') }}">
                    @error('telefone_pai')
                        <div class="invalid-feedback">{{ $message }}</div>
                    @enderror
                </div>
                <div class="col-md-6 mb-2">
                    <label for="bi_pai" class="form-label">N° do BI</label>
                    <input type="text" class="form-control @error('bi_pai') is-invalid @enderror" 
                           id="bi_pai" name="bi_pai" value="{{ old('bi_pai') }}">
                    @error('bi_pai')
                        <div class="invalid-feedback">{{ $message }}</div>
                    @enderror
                </div>
            </div>
        </div>

        <div class="col-md-6">
            <h6 class="fw-bold">Nome da Mãe</h6>
            <div class="row">
                <div class="col-md-12 mb-2">
                    <label for="nome_mae" class="form-label">Nome</label>
                    <input type="text" class="form-control @error('nome_mae') is-invalid @enderror" 
                           id="nome_mae" name="nome_mae" value="{{ old('nome_mae') }}">
                    @error('nome_mae')
                        <div class="invalid-feedback">{{ $message }}</div>
                    @enderror
                </div>
                <div class="col-md-12 mb-2">
                    <label for="local_trabalho_mae" class="form-label">Local de Trabalho</label>
                    <input type="text" class="form-control @error('local_trabalho_mae') is-invalid @enderror" 
                           id="local_trabalho_mae" name="local_trabalho_mae" value="{{ old('local_trabalho_mae') }}">
                    @error('local_trabalho_mae')
                        <div class="invalid-feedback">{{ $message }}</div>
                    @enderror
                </div>
                <div class="col-md-6 mb-2">
                    <label for="endereco_mae_bairro" class="form-label">Bairro</label>
                    <input type="text" class="form-control @error('endereco_mae_bairro') is-invalid @enderror" 
                           id="endereco_mae_bairro" name="endereco_mae_bairro" value="{{ old('endereco_mae_bairro') }}">
                    @error('endereco_mae_bairro')
                        <div class="invalid-feedback">{{ $message }}</div>
                    @enderror
                </div>
                <div class="col-md-6 mb-2">
                    <label for="endereco_mae_rua" class="form-label">Avenida/Rua</label>
                    <input type="text" class="form-control @error('endereco_mae_rua') is-invalid @enderror" 
                           id="endereco_mae_rua" name="endereco_mae_rua" value="{{ old('endereco_mae_rua') }}">
                    @error('endereco_mae_rua')
                        <div class="invalid-feedback">{{ $message }}</div>
                    @enderror
                </div>
                <div class="col-md-3 mb-2">
                    <label for="endereco_mae_numero" class="form-label">N°</label>
                    <input type="text" class="form-control @error('endereco_mae_numero') is-invalid @enderror" 
                           id="endereco_mae_numero" name="endereco_mae_numero" value="{{ old('endereco_mae_numero') }}">
                    @error('endereco_mae_numero')
                        <div class="invalid-feedback">{{ $message }}</div>
                    @enderror
                </div>
                <div class="col-md-3 mb-2">
                    <label for="endereco_mae_quarteirao" class="form-label">Quarteirão/Andar</label>
                    <input type="text" class="form-control @error('endereco_mae_quarteirao') is-invalid @enderror" 
                           id="endereco_mae_quarteirao" name="endereco_mae_quarteirao" value="{{ old('endereco_mae_quarteirao') }}">
                    @error('endereco_mae_quarteirao')
                        <div class="invalid-feedback">{{ $message }}</div>
                    @enderror
                </div>
                <div class="col-md-3 mb-2">
                    <label for="endereco_mae_flat" class="form-label">Flat</label>
                    <input type="text" class="form-control @error('endereco_mae_flat') is-invalid @enderror" 
                           id="endereco_mae_flat" name="endereco_mae_flat" value="{{ old('endereco_mae_flat') }}">
                    @error('endereco_mae_flat')
                        <div class="invalid-feedback">{{ $message }}</div>
                    @enderror
                </div>
                <div class="col-md-3 mb-2">
                    <label for="telefone_mae" class="form-label">Telefone</label>
                    <input type="text" class="form-control @error('telefone_mae') is-invalid @enderror" 
                           id="telefone_mae" name="telefone_mae" value="{{ old('telefone_mae') }}">
                    @error('telefone_mae')
                        <div class="invalid-feedback">{{ $message }}</div>
                    @enderror
                </div>
                <div class="col-md-6 mb-2">
                    <label for="bi_mae" class="form-label">N° do BI</label>
                    <input type="text" class="form-control @error('bi_mae') is-invalid @enderror" 
                           id="bi_mae" name="bi_mae" value="{{ old('bi_mae') }}">
                    @error('bi_mae')
                        <div class="invalid-feedback">{{ $message }}</div>
                    @enderror
                </div>
            </div>
        </div>
    </div>

    <h3 class="section-title">Dados de Saúde do Aluno</h3>
    
    <div class="row mb-3">
        <div class="col-md-6 mb-2">
            <label for="plano_saude" class="form-label">É dependente de algum plano de Saúde? Se sim, qual?</label>
            <input type="text" class="form-control @error('plano_saude') is-invalid @enderror" 
                   id="plano_saude" name="plano_saude" value="{{ old('plano_saude') }}" placeholder="Deixe em branco se não">
            @error('plano_saude')
                <div class="invalid-feedback">{{ $message }}</div>
            @enderror
        </div>

        <div class="col-md-6 mb-2">
            <label for="problema_saude_cronico" class="form-label">Tem algum problema de saúde crônico? Se sim, qual?</label>
            <input type="text" class="form-control @error('problema_saude_cronico') is-invalid @enderror" 
                   id="problema_saude_cronico" name="problema_saude_cronico" value="{{ old('problema_saude_cronico') }}" placeholder="Deixe em branco se não">
            @error('problema_saude_cronico')
                <div class="invalid-feedback">{{ $message }}</div>
            @enderror
        </div>

        <div class="col-md-6 mb-2">
            <label for="alergias" class="form-label">Tem alergias? Se sim, quais?</label>
            <input type="text" class="form-control @error('alergias') is-invalid @enderror" 
                   id="alergias" name="alergias" value="{{ old('alergias') }}" placeholder="Deixe em branco se não">
            @error('alergias')
                <div class="invalid-feedback">{{ $message }}</div>
            @enderror
        </div>

        <div class="col-md-6 mb-2">
            <label for="diagnostico_deficiencia" class="form-label">Já recebeu algum diagnóstico médico de deficiência? Se sim, qual?</label>
            <input type="text" class="form-control @error('diagnostico_deficiencia') is-invalid @enderror" 
                   id="diagnostico_deficiencia" name="diagnostico_deficiencia" value="{{ old('diagnostico_deficiencia') }}" placeholder="Deixe em branco se não">
            @error('diagnostico_deficiencia')
                <div class="invalid-feedback">{{ $message }}</div>
            @enderror
        </div>

        <div class="col-md-6 mb-2">
            <label for="dificuldade_motora_auditiva_visual_fala_emocional" class="form-label">Apresenta alguma dificuldade motora, auditiva, visual, na fala ou emocional? Se sim, qual?</label>
            <input type="text" class="form-control @error('dificuldade_motora_auditiva_visual_fala_emocional') is-invalid @enderror" 
                   id="dificuldade_motora_auditiva_visual_fala_emocional" name="dificuldade_motora_auditiva_visual_fala_emocional" value="{{ old('dificuldade_motora_auditiva_visual_fala_emocional') }}" placeholder="Deixe em branco se não">
            @error('dificuldade_motora_auditiva_visual_fala_emocional')
                <div class="invalid-feedback">{{ $message }}</div>
            @enderror
        </div>

        <div class="col-md-6 mb-2">
            <label for="tratamento_medico" class="form-label">Está em tratamento médico? Se sim, para que doença?</label>
            <input type="text" class="form-control @error('tratamento_medico') is-invalid @enderror" 
                   id="tratamento_medico" name="tratamento_medico" value="{{ old('tratamento_medico') }}" placeholder="Deixe em branco se não">
            @error('tratamento_medico')
                <div class="invalid-feedback">{{ $message }}</div>
            @enderror
        </div>

        <div class="col-md-6 mb-2">
            <label for="medicacao" class="form-label">Está em uso de alguma medicação? Qual? Quando encerrar o uso?</label>
            <input type="text" class="form-control @error('medicacao') is-invalid @enderror" 
                   id="medicacao" name="medicacao" value="{{ old('medicacao') }}" placeholder="Deixe em branco se não">
            @error('medicacao')
                <div class="invalid-feedback">{{ $message }}</div>
            @enderror
        </div>

        <div class="col-md-3 mb-2">
            <label for="vacinas_em_dia" class="form-label">As vacinas estão em dia?</label>
            <select class="form-select @error('vacinas_em_dia') is-invalid @enderror" id="vacinas_em_dia" name="vacinas_em_dia">
                <option value="">Selecione</option>
                <option value="1" {{ old('vacinas_em_dia') == '1' ? 'selected' : '' }}>Sim</option>
                <option value="0" {{ old('vacinas_em_dia') == '0' ? 'selected' : '' }}>Não</option>
            </select>
            @error('vacinas_em_dia')
                <div class="invalid-feedback">{{ $message }}</div>
            @enderror
        </div>

        <div class="col-md-6 mb-2">
            <label for="contato_emergencia" class="form-label">Em caso de emergência para quem ligar e em qual número?</label>
            <input type="text" class="form-control @error('contato_emergencia') is-invalid @enderror" 
                   id="contato_emergencia" name="contato_emergencia" value="{{ old('contato_emergencia') }}">
            @error('contato_emergencia')
                <div class="invalid-feedback">{{ $message }}</div>
            @enderror
        </div>

        <div class="col-md-12 mb-2">
            <label for="outras_informacoes_saude" class="form-label">Existe alguma outra informação a respeito da saúde do aluno que o Encarregado queira fazer constar da ficha?</label>
            <textarea class="form-control @error('outras_informacoes_saude') is-invalid @enderror" 
                      id="outras_informacoes_saude" name="outras_informacoes_saude" rows="3">{{ old('outras_informacoes_saude') }}</textarea>
            @error('outras_informacoes_saude')
                <div class="invalid-feedback">{{ $message }}</div>
            @enderror
        </div>
    </div>

    <h3 class="section-title">Indivíduos Autorizados a Acompanhar o Aluno</h3>
    <small class="text-muted">Adulto, idôneo ou maior de 16 anos emancipado</small>
    
    <div class="row mb-3">
        <div class="col-md-6 mb-2">
            <label for="individuo_autorizado_1_nome" class="form-label">Nome (1)</label>
            <input type="text" class="form-control @error('individuo_autorizado_1_nome') is-invalid @enderror" 
                   id="individuo_autorizado_1_nome" name="individuo_autorizado_1_nome" value="{{ old('individuo_autorizado_1_nome') }}">
            @error('individuo_autorizado_1_nome')
                <div class="invalid-feedback">{{ $message }}</div>
            @enderror
        </div>

        <div class="col-md-6 mb-2">
            <label for="individuo_autorizado_1_telefone" class="form-label">Telefone (1)</label>
            <input type="text" class="form-control @error('individuo_autorizado_1_telefone') is-invalid @enderror" 
                   id="individuo_autorizado_1_telefone" name="individuo_autorizado_1_telefone" value="{{ old('individuo_autorizado_1_telefone') }}">
            @error('individuo_autorizado_1_telefone')
                <div class="invalid-feedback">{{ $message }}</div>
            @enderror
        </div>

        <div class="col-md-6 mb-2">
            <label for="individuo_autorizado_2_nome" class="form-label">Nome (2)</label>
            <input type="text" class="form-control @error('individuo_autorizado_2_nome') is-invalid @enderror" 
                   id="individuo_autorizado_2_nome" name="individuo_autorizado_2_nome" value="{{ old('individuo_autorizado_2_nome') }}">
            @error('individuo_autorizado_2_nome')
                <div class="invalid-feedback">{{ $message }}</div>
            @enderror
        </div>

        <div class="col-md-6 mb-2">
            <label for="individuo_autorizado_2_telefone" class="form-label">Telefone (2)</label>
            <input type="text" class="form-control @error('individuo_autorizado_2_telefone') is-invalid @enderror" 
                   id="individuo_autorizado_2_telefone" name="individuo_autorizado_2_telefone" value="{{ old('individuo_autorizado_2_telefone') }}">
            @error('individuo_autorizado_2_telefone')
                <div class="invalid-feedback">{{ $message }}</div>
            @enderror
        </div>

        <div class="col-md-6 mb-2">
            <label for="individuo_autorizado_3_nome" class="form-label">Nome (3)</label>
            <input type="text" class="form-control @error('individuo_autorizado_3_nome') is-invalid @enderror" 
                   id="individuo_autorizado_3_nome" name="individuo_autorizado_3_nome" value="{{ old('individuo_autorizado_3_nome') }}">
            @error('individuo_autorizado_3_nome')
                <div class="invalid-feedback">{{ $message }}</div>
            @enderror
        </div>

        <div class="col-md-6 mb-2">
            <label for="individuo_autorizado_3_telefone" class="form-label">Telefone (3)</label>
            <input type="text" class="form-control @error('individuo_autorizado_3_telefone') is-invalid @enderror" 
                   id="individuo_autorizado_3_telefone" name="individuo_autorizado_3_telefone" value="{{ old('individuo_autorizado_3_telefone') }}">
            @error('individuo_autorizado_3_telefone')
                <div class="invalid-feedback">{{ $message }}</div>
            @enderror
        </div>
    </div>

    <h3 class="section-title">Dados de Encarregado de Educação</h3>
    
    <div class="row mb-3">
        <div class="col-md-4 mb-2">
            <label for="nome_encarregado" class="form-label">Nome do Encarregado <span class="required">*</span></label>
            <input type="text" class="form-control @error('nome_encarregado') is-invalid @enderror" 
                   id="nome_encarregado" name="nome_encarregado" value="{{ old('nome_encarregado') }}" required>
            @error('nome_encarregado')
                <div class="invalid-feedback">{{ $message }}</div>
            @enderror
        </div>

        <div class="col-md-4 mb-2">
            <label for="endereco_encarregado" class="form-label">Endereço de Residência</label>
            <input type="text" class="form-control @error('endereco_encarregado') is-invalid @enderror" 
                   id="endereco_encarregado" name="endereco_encarregado" value="{{ old('endereco_encarregado') }}">
            @error('endereco_encarregado')
                <div class="invalid-feedback">{{ $message }}</div>
            @enderror
        </div>

        <div class="col-md-2 mb-2">
            <label for="profissao_encarregado" class="form-label">Profissão</label>
            <input type="text" class="form-control @error('profissao_encarregado') is-invalid @enderror" 
                   id="profissao_encarregado" name="profissao_encarregado" value="{{ old('profissao_encarregado') }}">
            @error('profissao_encarregado')
                <div class="invalid-feedback">{{ $message }}</div>
            @enderror
        </div>

        <div class="col-md-2 mb-2">
            <label for="telefone_encarregado" class="form-label">Contacto <span class="required">*</span></label>
            <input type="text" class="form-control @error('telefone_encarregado') is-invalid @enderror" 
                   id="telefone_encarregado" name="telefone_encarregado" value="{{ old('telefone_encarregado') }}" required>
            @error('telefone_encarregado')
                <div class="invalid-feedback">{{ $message }}</div>
            @enderror
        </div>

        <div class="col-md-3 mb-2">
            <label for="bi_encarregado" class="form-label">BI N°</label>
            <input type="text" class="form-control @error('bi_encarregado') is-invalid @enderror" 
                   id="bi_encarregado" name="bi_encarregado" value="{{ old('bi_encarregado') }}">
            @error('bi_encarregado')
                <div class="invalid-feedback">{{ $message }}</div>
            @enderror
        </div>

        <div class="col-md-3 mb-2">
            <label for="grau_parentesco" class="form-label">Grau de Parentesco</label>
            <input type="text" class="form-control @error('grau_parentesco') is-invalid @enderror" 
                   id="grau_parentesco" name="grau_parentesco" value="{{ old('grau_parentesco') }}" placeholder="Ex: Pai, Mãe, Tio, etc.">
            @error('grau_parentesco')
                <div class="invalid-feedback">{{ $message }}</div>
            @enderror
        </div>
    </div>

    <div class="alert alert-info">
        <i class="bi bi-info-circle"></i> <strong>Nota:</strong> Após a submissão, a sua inscrição será analisada pela administração. Você receberá uma confirmação por email quando a inscrição for aprovada.
    </div>

    <div class="d-grid gap-2 d-md-flex justify-content-md-end mt-4">
        <button type="submit" class="btn btn-primary-custom btn-lg">
            <i class="bi bi-check-circle"></i> Submeter Inscrição
        </button>
    </div>
</form>
@endsection
