@extends('layouts.app')

@section('title', 'Criar Admin - SGE')

@section('content')
<div class="row">
    <div class="col-md-8">
        <div class="d-flex justify-content-between align-items-center mb-2" style="border-bottom: 1px solid #dee2e6; padding-bottom: 8px;">
            <h5 class="mb-0" style="font-weight: 600;">Criar Novo Admin</h5>
            <a href="{{ route('superadmin.admins.index') }}" class="btn btn-sm btn-secondary">Voltar</a>
        </div>
        
        <div style="background: #f8f9fa; padding: 15px; border-radius: 4px;">
            <form method="POST" action="{{ route('superadmin.admins.store') }}">
                @csrf

                <div class="mb-2">
                    <label for="name" class="form-label" style="font-size: 0.85rem; margin-bottom: 3px;">Nome <span class="text-danger">*</span></label>
                    <input type="text" class="form-control form-control-sm @error('name') is-invalid @enderror" 
                           id="name" name="name" value="{{ old('name') }}" required>
                    @error('name')
                        <div class="invalid-feedback">{{ $message }}</div>
                    @enderror
                </div>

                <div class="mb-2">
                    <label for="email" class="form-label" style="font-size: 0.85rem; margin-bottom: 3px;">Email <span class="text-danger">*</span></label>
                    <input type="email" class="form-control form-control-sm @error('email') is-invalid @enderror" 
                           id="email" name="email" value="{{ old('email') }}" required>
                    @error('email')
                        <div class="invalid-feedback">{{ $message }}</div>
                    @enderror
                </div>

                <div class="mb-2">
                    <label for="password" class="form-label" style="font-size: 0.85rem; margin-bottom: 3px;">Senha <span class="text-danger">*</span></label>
                    <input type="password" class="form-control form-control-sm @error('password') is-invalid @enderror" 
                           id="password" name="password" required minlength="8">
                    @error('password')
                        <div class="invalid-feedback">{{ $message }}</div>
                    @enderror
                    <small class="text-muted" style="font-size: 0.75rem;">Mínimo de 8 caracteres</small>
                </div>

                <div class="mt-2">
                    <button type="submit" class="btn btn-sm btn-primary">Criar</button>
                </div>
            </form>
        </div>
    </div>
</div>
@endsection



