@extends('layouts.app')

@section('title', 'Configurações do Cabeçalho - SGE')

@section('content')
<div class="row">
    <div class="col-md-8">
        <div class="d-flex justify-content-between align-items-center mb-2" style="border-bottom: 1px solid #dee2e6; padding-bottom: 8px;">
            <h5 class="mb-0" style="font-weight: 600;">Configurações do Cabeçalho</h5>
            <a href="{{ route('superadmin.configuracoes') }}" class="btn btn-sm btn-secondary">Voltar</a>
        </div>
        
        <div style="background: #f8f9fa; padding: 15px; border-radius: 4px;">
            <form method="POST" action="{{ route('superadmin.configuracoes.cabecalho.update') }}" enctype="multipart/form-data">
                @csrf

                <div class="mb-2">
                    <label for="republica" class="form-label" style="font-size: 0.85rem; margin-bottom: 3px;">República <span class="text-danger">*</span></label>
                    <input type="text" class="form-control form-control-sm @error('republica') is-invalid @enderror" 
                           id="republica" name="republica" value="{{ old('republica', $republica) }}" required>
                    @error('republica')
                        <div class="invalid-feedback">{{ $message }}</div>
                    @enderror
                    <small class="text-muted" style="font-size: 0.75rem;">Ex: REPÚBLICA DE MOÇAMBIQUE</small>
                </div>

                <div class="mb-2">
                    <label for="provincia" class="form-label" style="font-size: 0.85rem; margin-bottom: 3px;">Província <span class="text-danger">*</span></label>
                    <input type="text" class="form-control form-control-sm @error('provincia') is-invalid @enderror" 
                           id="provincia" name="provincia" value="{{ old('provincia', $provincia) }}" required>
                    @error('provincia')
                        <div class="invalid-feedback">{{ $message }}</div>
                    @enderror
                    <small class="text-muted" style="font-size: 0.75rem;">Ex: PROVINCIAL DA ZAMBÉZIA</small>
                </div>

                <div class="mb-2">
                    <label for="distrito" class="form-label" style="font-size: 0.85rem; margin-bottom: 3px;">Distrito <span class="text-danger">*</span></label>
                    <input type="text" class="form-control form-control-sm @error('distrito') is-invalid @enderror" 
                           id="distrito" name="distrito" value="{{ old('distrito', $distrito) }}" required>
                    @error('distrito')
                        <div class="invalid-feedback">{{ $message }}</div>
                    @enderror
                    <small class="text-muted" style="font-size: 0.75rem;">Ex: GOVERNO DO DISTRITO DE MOCUBA</small>
                </div>

                <div class="mb-2">
                    <label for="escola" class="form-label" style="font-size: 0.85rem; margin-bottom: 3px;">Escola <span class="text-danger">*</span></label>
                    <input type="text" class="form-control form-control-sm @error('escola') is-invalid @enderror" 
                           id="escola" name="escola" value="{{ old('escola', $escola) }}" required>
                    @error('escola')
                        <div class="invalid-feedback">{{ $message }}</div>
                    @enderror
                    <small class="text-muted" style="font-size: 0.75rem;">Ex: ESCOLA PRIMARIA E COMPLETA SGE</small>
                </div>

                <div class="mb-2">
                    <label for="logotipo" class="form-label" style="font-size: 0.85rem; margin-bottom: 3px;">Logotipo da Escola</label>
                    @php
                        $logotipoAtual = \App\Models\Configuracao::get('logotipo_escola', null);
                    @endphp
                    @if($logotipoAtual)
                        <div class="mb-2">
                            <img src="{{ asset('storage/' . $logotipoAtual) }}" alt="Logotipo atual" style="max-height: 80px; max-width: 150px; border: 1px solid #dee2e6; padding: 4px; border-radius: 4px;">
                        </div>
                    @endif
                    <input type="file" class="form-control form-control-sm @error('logotipo') is-invalid @enderror" 
                           id="logotipo" name="logotipo" accept="image/jpeg,image/jpg,image/png,image/gif">
                    @error('logotipo')
                        <div class="invalid-feedback">{{ $message }}</div>
                    @enderror
                    <small class="text-muted" style="font-size: 0.75rem;">JPG, PNG, GIF. Máximo 2MB.</small>
                </div>

                <div class="mt-2">
                    <button type="submit" class="btn btn-sm btn-primary">Salvar</button>
                </div>
            </form>
        </div>
    </div>
</div>
@endsection

