@extends('layouts.app')

@section('title', 'Criar Trabalho - SGE')

@section('content')
<div class="row">
    <div class="col-md-8">
        <div class="card">
            <div class="card-header bg-primary-custom text-white">
                <h4 class="mb-0">Criar Trabalho/TPC</h4>
            </div>
            <div class="card-body">
                <form method="POST" action="{{ route('trabalhos.store') }}">
                    @csrf

                    <div class="mb-3">
                        <label for="titulo" class="form-label">Título *</label>
                        <input type="text" class="form-control @error('titulo') is-invalid @enderror" 
                               id="titulo" name="titulo" value="{{ old('titulo') }}" required>
                        @error('titulo')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>

                    <div class="mb-3">
                        <label for="descricao" class="form-label">Descrição</label>
                        <textarea class="form-control @error('descricao') is-invalid @enderror" 
                                  id="descricao" name="descricao" rows="3">{{ old('descricao') }}</textarea>
                        @error('descricao')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>

                    <div class="mb-3">
                        <label for="disciplina_id" class="form-label">Disciplina *</label>
                        <select class="form-control @error('disciplina_id') is-invalid @enderror" 
                                id="disciplina_id" name="disciplina_id" required>
                            <option value="">Selecione</option>
                            @foreach($disciplinas as $disciplina)
                                <option value="{{ $disciplina->id }}" {{ old('disciplina_id') == $disciplina->id ? 'selected' : '' }}>
                                    {{ $disciplina->nome }}
                                </option>
                            @endforeach
                        </select>
                        @error('disciplina_id')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>

                    <div class="mb-3">
                        <label for="turma_id" class="form-label">Turma *</label>
                        <select class="form-control @error('turma_id') is-invalid @enderror" 
                                id="turma_id" name="turma_id" required>
                            <option value="">Selecione</option>
                            @foreach($turmas as $turma)
                                <option value="{{ $turma->id }}" {{ old('turma_id') == $turma->id ? 'selected' : '' }}>
                                    {{ $turma->nome }}
                                </option>
                            @endforeach
                        </select>
                        @error('turma_id')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>

                    <div class="mb-3">
                        <label for="data_entrega" class="form-label">Data de Entrega *</label>
                        <input type="date" class="form-control @error('data_entrega') is-invalid @enderror" 
                               id="data_entrega" name="data_entrega" value="{{ old('data_entrega') }}" required>
                        @error('data_entrega')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>

                    <div class="mb-3">
                        <label for="tipo" class="form-label">Tipo *</label>
                        <select class="form-control @error('tipo') is-invalid @enderror" 
                                id="tipo" name="tipo" required>
                            <option value="Trabalho" {{ old('tipo') == 'Trabalho' ? 'selected' : '' }}>Trabalho</option>
                            <option value="TPC" {{ old('tipo') == 'TPC' ? 'selected' : '' }}>TPC</option>
                        </select>
                        @error('tipo')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>

                    <div class="mb-3">
                        <label for="valor" class="form-label">Valor (0-20)</label>
                        <input type="number" step="0.01" min="0" max="20" 
                               class="form-control @error('valor') is-invalid @enderror" 
                               id="valor" name="valor" value="{{ old('valor', 0) }}">
                        @error('valor')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>

                    <input type="hidden" name="ano_letivo_id" value="{{ $anoLetivo->id }}">

                    <button type="submit" class="btn btn-primary-custom">Criar Trabalho</button>
                    <a href="{{ route('trabalhos.index') }}" class="btn btn-secondary">Cancelar</a>
                </form>
            </div>
        </div>
    </div>
</div>
@endsection



