@extends('layouts.app')

@section('title', 'Planos - SGE')

@section('content')
<div class="row">
    <div class="col-12">
        <div class="d-flex justify-content-between align-items-center mb-2" style="border-bottom: 1px solid #dee2e6; padding-bottom: 8px;">
            <h5 class="mb-0" style="font-weight: 600;">Planos Trimestrais</h5>
        </div>

        @if(auth()->user()->isAdmin() || auth()->user()->isSuperadmin() || auth()->user()->podeGerir('gerir_planos'))
            <div class="table-responsive">
                <table class="table table-sm table-bordered" style="font-size: 0.85rem;">
                    <thead style="background-color: #f8f9fa;">
                        <tr>
                            <th style="padding: 6px;">Professor</th>
                            <th style="padding: 6px;">Disciplina</th>
                            <th style="padding: 6px;">Turma</th>
                            <th style="padding: 6px;">Trimestre</th>
                            <th style="padding: 6px;">Acções</th>
                        </tr>
                    </thead>
                    <tbody>
                        @forelse($planos ?? [] as $plano)
                            <tr>
                                <td style="padding: 5px;">{{ $plano->professor->user->name ?? 'N/A' }}</td>
                                <td style="padding: 5px;">{{ $plano->disciplina->nome }}</td>
                                <td style="padding: 5px;">{{ $plano->turma->codigo }}</td>
                                <td style="padding: 5px;">{{ $plano->trimestre->nome ?? 'N/A' }}</td>
                                <td style="padding: 5px;">
                                    @if($plano->arquivo)
                                        <div style="display: flex; gap: 4px;">
                                            <a href="{{ route('planos.visualizar', $plano) }}" target="_blank" class="btn btn-sm" style="padding: 2px 6px; font-size: 0.75rem; background: #e7f3ff; color: #0066cc; border: none;" title="Visualizar">
                                                <i class="bi bi-eye"></i>
                                            </a>
                                            <a href="{{ asset('storage/' . $plano->arquivo) }}" download class="btn btn-sm" style="padding: 2px 6px; font-size: 0.75rem; background: #d4edda; color: #155724; border: none;" title="Download">
                                                <i class="bi bi-download"></i>
                                            </a>
                                        </div>
                                    @endif
                                </td>
                            </tr>
                        @empty
                            <tr>
                                <td colspan="5" class="text-center" style="padding: 20px; color: #999;">
                                    Nenhum plano trimestral encontrado.
                                </td>
                            </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>
        @elseif(auth()->user()->isProfessor() || auth()->user()->isAluno())
            <div class="table-responsive">
                <table class="table table-sm table-bordered" style="font-size: 0.85rem;">
                    <thead style="background-color: #f8f9fa;">
                        <tr>
                            <th style="padding: 6px;">Título</th>
                            <th style="padding: 6px;">Disciplina</th>
                            <th style="padding: 6px;">Turma</th>
                            <th style="padding: 6px;">Data Entrega</th>
                            <th style="padding: 6px;">Tipo</th>
                        </tr>
                    </thead>
                    <tbody>
                        @forelse($trabalhos ?? [] as $trabalho)
                            <tr>
                                <td style="padding: 5px;">{{ $trabalho->titulo }}</td>
                                <td style="padding: 5px;">{{ $trabalho->disciplina->nome ?? 'N/A' }}</td>
                                <td style="padding: 5px;">{{ $trabalho->turma->codigo ?? 'N/A' }}</td>
                                <td style="padding: 5px;">{{ $trabalho->data_entrega ? $trabalho->data_entrega->format('d/m/Y') : 'N/A' }}</td>
                                <td style="padding: 5px;">
                                    <span class="badge bg-{{ $trabalho->tipo === 'TPC' ? 'warning' : 'primary' }}">
                                        {{ $trabalho->tipo }}
                                    </span>
                                </td>
                            </tr>
                        @empty
                            <tr>
                                <td colspan="5" class="text-center" style="padding: 20px; color: #999;">
                                    Nenhum trabalho encontrado.
                                </td>
                            </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>
        @endif
    </div>
</div>
@endsection
