

<?php $__env->startSection('title', 'Editar Professor - SGE'); ?>

<?php $__env->startSection('content'); ?>
<div class="row">
    <div class="col-md-10">
        <div class="card">
            <div class="card-header bg-primary-custom text-white py-2">
                <h5 class="mb-0">Editar Professor</h5>
            </div>
            <div class="card-body p-2">
                <form method="POST" action="<?php echo e(route('admin.professores.update', $professor)); ?>" enctype="multipart/form-data">
                    <?php echo csrf_field(); ?>
                    <?php echo method_field('PUT'); ?>

                    <div class="row g-1">
                        <div class="col-md-6">
                            <label for="name" class="form-label small mb-0">Nome *</label>
                            <input type="text" class="form-control form-control-sm <?php $__errorArgs = ['name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                   id="name" name="name" value="<?php echo e(old('name', $professor->user->name)); ?>" required>
                            <?php $__errorArgs = ['name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <div class="invalid-feedback small"><?php echo e($message); ?></div>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>

                        <div class="col-md-6">
                            <label for="numero_funcionario" class="form-label small mb-0">Código do Professor</label>
                            <input type="text" class="form-control form-control-sm" 
                                   id="numero_funcionario" name="numero_funcionario" 
                                   value="<?php echo e(old('numero_funcionario', $professor->numero_funcionario)); ?>" 
                                   readonly disabled>
                        </div>

                        <div class="col-md-6">
                            <label for="genero" class="form-label small mb-0">Género</label>
                            <select class="form-select form-select-sm <?php $__errorArgs = ['genero'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                    id="genero" name="genero">
                                <option value="">Selecione</option>
                                <option value="M" <?php echo e(old('genero', $professor->genero) == 'M' ? 'selected' : ''); ?>>Masculino</option>
                                <option value="F" <?php echo e(old('genero', $professor->genero) == 'F' ? 'selected' : ''); ?>>Feminino</option>
                                <option value="Outro" <?php echo e(old('genero', $professor->genero) == 'Outro' ? 'selected' : ''); ?>>Outro</option>
                            </select>
                            <?php $__errorArgs = ['genero'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <div class="invalid-feedback small"><?php echo e($message); ?></div>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>

                        <div class="col-md-6">
                            <label for="telefone" class="form-label small mb-0">Contacto</label>
                            <input type="text" class="form-control form-control-sm <?php $__errorArgs = ['telefone'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                   id="telefone" name="telefone" value="<?php echo e(old('telefone', $professor->telefone)); ?>" 
                                   placeholder="Ex: 842528792">
                            <?php $__errorArgs = ['telefone'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <div class="invalid-feedback small"><?php echo e($message); ?></div>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>

                        <div class="col-md-6">
                            <label for="nivel_ensino" class="form-label small mb-0">Nível de Ensino *</label>
                            <select class="form-select form-select-sm <?php $__errorArgs = ['nivel_ensino'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                    id="nivel_ensino" name="nivel_ensino" required>
                                <option value="">Selecione</option>
                                <option value="PRIMARIO" <?php echo e(old('nivel_ensino', $professor->nivel_ensino ?? 'AMBOS') == 'PRIMARIO' ? 'selected' : ''); ?>>Primário</option>
                                <option value="SECUNDARIO" <?php echo e(old('nivel_ensino', $professor->nivel_ensino ?? 'AMBOS') == 'SECUNDARIO' ? 'selected' : ''); ?>>Secundário</option>
                                <option value="AMBOS" <?php echo e(old('nivel_ensino', $professor->nivel_ensino ?? 'AMBOS') == 'AMBOS' ? 'selected' : ''); ?>>Ambos</option>
                            </select>
                            <?php $__errorArgs = ['nivel_ensino'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <div class="invalid-feedback small"><?php echo e($message); ?></div>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>

                        <!-- Campos de Salário -->
                        <div class="col-md-6" id="salario_fixo_field" style="display: none;">
                            <label for="salario_fixo" class="form-label small mb-0">Salário Fixo (MT) *</label>
                            <input type="number" step="0.01" min="0" 
                                   class="form-control form-control-sm <?php $__errorArgs = ['salario_fixo'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                   id="salario_fixo" name="salario_fixo" 
                                   value="<?php echo e(old('salario_fixo', $professor->salario_fixo)); ?>" 
                                   placeholder="Ex: 15000.00">
                            <small class="form-text text-muted" style="font-size: 0.7rem;">Salário fixo para professores da primária</small>
                            <?php $__errorArgs = ['salario_fixo'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <div class="invalid-feedback small"><?php echo e($message); ?></div>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>

                        <div class="col-md-6" id="valor_hora_field" style="display: none;">
                            <label for="valor_hora" class="form-label small mb-0">Valor por Hora (MT) *</label>
                            <input type="number" step="0.01" min="0" 
                                   class="form-control form-control-sm <?php $__errorArgs = ['valor_hora'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                   id="valor_hora" name="valor_hora" 
                                   value="<?php echo e(old('valor_hora', $professor->valor_hora)); ?>" 
                                   placeholder="Ex: 500.00">
                            <small class="form-text text-muted" style="font-size: 0.7rem;">Valor por hora para professores do secundário</small>
                            <?php $__errorArgs = ['valor_hora'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <div class="invalid-feedback small"><?php echo e($message); ?></div>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>

                        <div class="col-md-6">
                            <label for="documento_identificacao" class="form-label small mb-0">Documento</label>
                            <?php if($professor->documento_identificacao): ?>
                                <div class="mb-1">
                                    <a href="<?php echo e(asset('storage/' . $professor->documento_identificacao)); ?>" target="_blank" class="btn btn-sm btn-info py-0 px-2" style="font-size: 0.7rem;">
                                        <i class="bi bi-file-earmark-pdf"></i> Ver
                                    </a>
                                </div>
                            <?php endif; ?>
                            <input type="file" class="form-control form-control-sm <?php $__errorArgs = ['documento_identificacao'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                   id="documento_identificacao" name="documento_identificacao" 
                                   accept=".pdf,.jpg,.jpeg,.png">
                            <?php $__errorArgs = ['documento_identificacao'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <div class="invalid-feedback small"><?php echo e($message); ?></div>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>

                        <?php if($anoLetivo): ?>
                        <div class="col-md-6">
                            <label for="turma_id" class="form-label small mb-0">Turma</label>
                            <select class="form-select form-select-sm <?php $__errorArgs = ['turma_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                    id="turma_id" name="turma_id">
                                <option value="">Selecione</option>
                                <?php $__currentLoopData = $turmas ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $turma): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($turma->id); ?>"
                                            data-nivel="<?php echo e($turma->nivel_ensino ?? 'PRIMARIO'); ?>">
                                        <?php echo e($turma->codigo); ?> - Turma <?php echo e($turma->nome); ?>

                                    </option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                            <?php $__errorArgs = ['turma_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <div class="invalid-feedback small"><?php echo e($message); ?></div>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>

                        <div class="col-md-6">
                            <label for="disciplinas" class="form-label small mb-0">Disciplinas</label>
                            <select class="form-select form-select-sm <?php $__errorArgs = ['disciplinas'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                    id="disciplinas" name="disciplinas[]" multiple size="3">
                                <?php $__currentLoopData = $disciplinas ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $disciplina): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($disciplina->id); ?>"
                                            data-nivel="<?php echo e($disciplina->nivel_ensino ?? 'PRIMARIO'); ?>">
                                        <?php echo e($disciplina->nome); ?>

                                    </option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                            <small class="text-muted" style="font-size: 0.7rem;">Ctrl para múltiplas</small>
                            <?php $__errorArgs = ['disciplinas'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <div class="invalid-feedback small"><?php echo e($message); ?></div>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>

                        <?php if($alocacoesAtuais && $alocacoesAtuais->count() > 0): ?>
                        <div class="col-md-12">
                            <label class="form-label small mb-0">Alocações (<?php echo e($anoLetivo->ano_inicial); ?>):</label>
                            <div class="table-responsive" style="max-height: 100px; overflow-y: auto;">
                                <table class="table table-sm table-bordered mb-0" style="font-size: 0.75rem;">
                                    <thead>
                                        <tr>
                                            <th style="padding: 0.2rem;">Turma</th>
                                            <th style="padding: 0.2rem;">Disciplina</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php $__currentLoopData = $alocacoesAtuais; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $alocacao): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <?php
                                                $turmaAloc = \App\Models\Turma::find($alocacao->turma_id);
                                                $disciplinaAloc = \App\Models\Disciplina::find($alocacao->disciplina_id);
                                            ?>
                                            <tr>
                                                <td style="padding: 0.2rem;"><?php echo e($turmaAloc ? $turmaAloc->codigo . ' - ' . $turmaAloc->nome : 'N/A'); ?></td>
                                                <td style="padding: 0.2rem;"><?php echo e($disciplinaAloc ? $disciplinaAloc->nome : 'N/A'); ?></td>
                                            </tr>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                        <?php endif; ?>
                        <?php endif; ?>
                    </div>

                    <div class="mt-1">
                        <button type="submit" class="btn btn-primary-custom btn-sm py-1 px-3">Atualizar</button>
                        <a href="<?php echo e(route('admin.professores.index')); ?>" class="btn btn-secondary btn-sm py-1 px-3">Cancelar</a>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<script>
function initProfessorEditForm() {
    const nivelSelect = document.getElementById('nivel_ensino');
    const disciplinasSelect = document.getElementById('disciplinas');
    const turmasSelect = document.getElementById('turma_id');

    function filtrarDisciplinas() {
        if (!nivelSelect || !disciplinasSelect) return;
        const nivel = nivelSelect.value || 'AMBOS';
        const options = Array.from(disciplinasSelect.options);
        options.forEach(option => {
            const nivelDisciplina = option.getAttribute('data-nivel') || 'PRIMARIO';
            const visivel = (nivel === 'AMBOS') || (nivelDisciplina === nivel);
            option.hidden = !visivel;
            if (!visivel) {
                option.selected = false;
            }
        });
    }

    function filtrarTurmas() {
        if (!nivelSelect || !turmasSelect) return;
        const nivel = nivelSelect.value || 'AMBOS';
        const options = Array.from(turmasSelect.options);
        options.forEach(option => {
            if (!option.value) return;
            const nivelTurma = option.getAttribute('data-nivel') || 'PRIMARIO';
            const visivel = (nivel === 'AMBOS') || (nivelTurma === nivel);
            option.hidden = !visivel;
            if (!visivel && option.selected) {
                option.selected = false;
            }
        });
    }

    // Função para mostrar/ocultar campos de salário baseado no nível
    function atualizarCamposSalario() {
        const nivel = nivelSelect.value;
        const salarioFixoField = document.getElementById('salario_fixo_field');
        const valorHoraField = document.getElementById('valor_hora_field');
        const salarioFixoInput = document.getElementById('salario_fixo');
        const valorHoraInput = document.getElementById('valor_hora');

        if (nivel === 'PRIMARIO' || nivel === 'AMBOS') {
            if (salarioFixoField) salarioFixoField.style.display = 'block';
            if (salarioFixoInput) salarioFixoInput.required = true;
        } else {
            if (salarioFixoField) salarioFixoField.style.display = 'none';
            if (salarioFixoInput) {
                salarioFixoInput.required = false;
                if (nivel === 'SECUNDARIO') salarioFixoInput.value = '';
            }
        }

        if (nivel === 'SECUNDARIO' || nivel === 'AMBOS') {
            if (valorHoraField) valorHoraField.style.display = 'block';
            if (valorHoraInput) valorHoraInput.required = true;
        } else {
            if (valorHoraField) valorHoraField.style.display = 'none';
            if (valorHoraInput) {
                valorHoraInput.required = false;
                if (nivel === 'PRIMARIO') valorHoraInput.value = '';
            }
        }
    }

    // Função para mostrar/ocultar campos de salário baseado no nível
    function atualizarCamposSalario() {
        const nivel = nivelSelect.value;
        const salarioFixoField = document.getElementById('salario_fixo_field');
        const valorHoraField = document.getElementById('valor_hora_field');
        const salarioFixoInput = document.getElementById('salario_fixo');
        const valorHoraInput = document.getElementById('valor_hora');

        if (nivel === 'PRIMARIO' || nivel === 'AMBOS') {
            if (salarioFixoField) salarioFixoField.style.display = 'block';
            if (salarioFixoInput) salarioFixoInput.required = true;
        } else {
            if (salarioFixoField) salarioFixoField.style.display = 'none';
            if (salarioFixoInput) {
                salarioFixoInput.required = false;
                if (nivel === 'SECUNDARIO') salarioFixoInput.value = '';
            }
        }

        if (nivel === 'SECUNDARIO' || nivel === 'AMBOS') {
            if (valorHoraField) valorHoraField.style.display = 'block';
            if (valorHoraInput) valorHoraInput.required = true;
        } else {
            if (valorHoraField) valorHoraField.style.display = 'none';
            if (valorHoraInput) {
                valorHoraInput.required = false;
                if (nivel === 'PRIMARIO') valorHoraInput.value = '';
            }
        }
    }

    if (nivelSelect) {
        nivelSelect.addEventListener('change', function() {
            filtrarDisciplinas();
            filtrarTurmas();
            atualizarCamposSalario();
        });
        filtrarDisciplinas();
        filtrarTurmas();
        atualizarCamposSalario(); // Executar ao carregar
    }
}

window.initProfessorEditForm = initProfessorEditForm;

document.addEventListener('DOMContentLoaded', function() {
    initProfessorEditForm();
});
</script>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\Users\Alcidio\Desktop\escola\resources\views/admin/professores/edit.blade.php ENDPATH**/ ?>