

<?php $__env->startSection('title', 'Processar Pagamento - Estudante'); ?>

<?php $__env->startSection('content'); ?>
<div class="row justify-content-center">
    <div class="col-md-6">
        <div class="card">
            <div class="card-header bg-primary text-white">
                <h5 class="mb-0">Processar Pagamento</h5>
            </div>
            <div class="card-body text-center">
                <div class="mb-4">
                    <i class="bi bi-<?php echo e($payment->metodo === 'MPESA' ? 'phone' : 'wallet2'); ?> display-1 text-primary"></i>
                </div>
                
                <h4>Referência: <?php echo e($payment->reference); ?></h4>
                <p class="text-muted">Valor: <?php echo e(number_format($payment->valor, 2, ',', '.')); ?> MT</p>
                <p class="text-muted">Método: <?php echo e($payment->metodo === 'MPESA' ? 'M-Pesa' : 'Emola'); ?></p>

                <div class="alert alert-info">
                    <i class="bi bi-info-circle me-2"></i>
                    <strong>Nota:</strong> Esta é uma simulação. Em produção, será redireccionado para o gateway de pagamento real.
                </div>

                <form method="POST" action="<?php echo e(route('aluno.payment.confirm', $payment)); ?>">
                    <?php echo csrf_field(); ?>
                    <button type="submit" class="btn btn-success btn-lg">
                        <i class="bi bi-check-circle me-1"></i> Confirmar Pagamento (Simulação)
                    </button>
                </form>

                <div class="mt-3">
                    <a href="<?php echo e(route('aluno.financeiro')); ?>" class="btn btn-secondary">Cancelar</a>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\Users\Alcidio\Desktop\escola\resources\views/aluno/payment/process.blade.php ENDPATH**/ ?>