

<?php $__env->startSection('title', 'Notificações - SIGE'); ?>

<?php $__env->startSection('content'); ?>
<div class="row">
    <div class="col-12">
        <div class="d-flex justify-content-between align-items-center mb-3">
            <h4 class="mb-0">
                <i class="bi bi-bell text-primary me-2"></i>
                Notificações
            </h4>
            <form action="<?php echo e(route('notifications.read-all')); ?>" method="POST" class="d-inline">
                <?php echo csrf_field(); ?>
                <button type="submit" class="btn btn-sm btn-outline-primary">
                    <i class="bi bi-check-all me-1"></i> Marcar todas como lidas
                </button>
            </form>
        </div>
    </div>
</div>

<?php if($notifications->count() > 0): ?>
    <div class="list-group">
        <?php $__currentLoopData = $notifications; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $notification): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <a href="<?php echo e($notification->link ?? '#'); ?>" 
               class="list-group-item list-group-item-action <?php echo e(!$notification->read ? 'list-group-item-primary' : ''); ?>"
               onclick="if(event.target.tagName !== 'BUTTON') { markAsRead(<?php echo e($notification->id); ?>); }">
                <div class="d-flex w-100 justify-content-between">
                    <h6 class="mb-1">
                        <?php if(!$notification->read): ?>
                            <span class="badge bg-primary me-2">Nova</span>
                        <?php endif; ?>
                        <?php echo e($notification->title); ?>

                    </h6>
                    <small><?php echo e($notification->created_at->diffForHumans()); ?></small>
                </div>
                <p class="mb-1"><?php echo e($notification->message); ?></p>
                <form action="<?php echo e(route('notifications.read', $notification)); ?>" method="POST" class="d-inline" onsubmit="event.stopPropagation(); return false;">
                    <?php echo csrf_field(); ?>
                    <button type="submit" class="btn btn-sm btn-outline-secondary" onclick="markAsRead(<?php echo e($notification->id); ?>); return false;">
                        <i class="bi bi-check"></i> Marcar como lida
                    </button>
                </form>
            </a>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </div>

    <div class="mt-3">
        <?php echo e($notifications->links()); ?>

    </div>
<?php else: ?>
    <div class="alert alert-info text-center">
        <i class="bi bi-inbox display-4 d-block mb-3"></i>
        Nenhuma notificação encontrada.
    </div>
<?php endif; ?>

<script>
function markAsRead(notificationId) {
    fetch(`/notifications/${notificationId}/read`, {
        method: 'POST',
        headers: {
            'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').content,
            'Content-Type': 'application/json',
            'Accept': 'application/json'
        }
    })
    .then(response => response.json())
    .then(data => {
        if (data.success) {
            location.reload();
        }
    });
}
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\Users\Alcidio\Desktop\escola\resources\views/notifications/index.blade.php ENDPATH**/ ?>