<?php
    $cargosPadrao = ['ADMINISTRAÇÃO', 'LIMPEZA', 'SEGURANÇA', 'PORTARIA', 'MANUTENÇÃO', 'COZINHA', 'MOTORISTA', 'JARDINAGEM', 'OUTRO'];
    $cargoAtual = old('cargo', $cargoAtual ?? '');
    $cargoUpper = $cargoAtual ? mb_strtoupper(trim($cargoAtual)) : '';
    $cargoEhPadrao = $cargoUpper && in_array($cargoUpper, $cargosPadrao, true) && $cargoUpper !== 'OUTRO';
    $valorSelect = $cargoEhPadrao ? $cargoUpper : ($cargoAtual ? 'OUTRO' : '');
    $valorOutro = $cargoEhPadrao ? '' : $cargoAtual;
?>

<label class="form-label small mb-0">Cargo *</label>
<select class="form-select form-select-sm <?php $__errorArgs = ['cargo'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
        id="cargo_select">
    <option value="">-- Selecione um cargo --</option>
    <?php $__currentLoopData = $cargosPadrao; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $cargo): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <option value="<?php echo e($cargo); ?>" <?php echo e($valorSelect === $cargo ? 'selected' : ''); ?>>
            <?php echo e($cargo); ?>

        </option>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
</select>
<input type="text" 
       class="form-control form-control-sm mt-2 <?php $__errorArgs = ['cargo'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
       id="cargo_outro" 
       value="<?php echo e($valorOutro); ?>" 
       placeholder="Digite o cargo personalizado..." 
       style="<?php echo e($valorSelect === 'OUTRO' ? '' : 'display:none;'); ?>">
<input type="hidden" id="cargo" name="cargo" value="<?php echo e($cargoEhPadrao ? $cargoUpper : ($cargoAtual ?: '')); ?>">
<?php $__errorArgs = ['cargo'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
    <div class="invalid-feedback small d-block"><?php echo e($message); ?></div>
<?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>

<script>
(function() {
    'use strict';
    
    function init() {
        const cargoSelect = document.getElementById('cargo_select');
        const cargoOutro = document.getElementById('cargo_outro');
        const cargoHidden = document.getElementById('cargo');
        
        if (!cargoSelect || !cargoOutro || !cargoHidden) return;
        
        // Inicializar com valor existente (para edição)
        const valorInicial = cargoHidden.value.trim();
        if (valorInicial) {
            const valorUpper = valorInicial.toUpperCase();
            const cargosPadrao = ['ADMINISTRAÇÃO', 'LIMPEZA', 'SEGURANÇA', 'PORTARIA', 'MANUTENÇÃO', 'COZINHA', 'MOTORISTA', 'JARDINAGEM', 'OUTRO'];
            
            if (cargosPadrao.includes(valorUpper) && valorUpper !== 'OUTRO') {
                cargoSelect.value = valorUpper;
                cargoOutro.style.display = 'none';
                cargoHidden.value = valorUpper;
            } else {
                cargoSelect.value = 'OUTRO';
                cargoOutro.style.display = '';
                cargoOutro.value = valorInicial;
                cargoHidden.value = valorInicial;
            }
        }
        
        function atualizarCargo() {
            const valorSelect = cargoSelect.value;
            
            if (valorSelect === 'OUTRO') {
                cargoOutro.style.display = '';
                const valorOutro = cargoOutro.value.trim();
                cargoHidden.value = valorOutro || '';
            } else if (valorSelect) {
                cargoOutro.style.display = 'none';
                cargoHidden.value = valorSelect;
            } else {
                cargoOutro.style.display = 'none';
                cargoHidden.value = '';
            }
        }
        
        cargoSelect.addEventListener('change', function() {
            atualizarCargo();
            if (cargoSelect.value === 'OUTRO') {
                setTimeout(() => cargoOutro.focus(), 50);
            }
        });
        
        cargoOutro.addEventListener('input', atualizarCargo);
        cargoOutro.addEventListener('blur', atualizarCargo);
        
        const form = cargoSelect.closest('form');
        if (form) {
            form.addEventListener('submit', function(e) {
                // Forçar atualização antes do submit
                atualizarCargo();
                
                // Garantir valor final
                const valorFinal = cargoSelect.value === 'OUTRO' 
                    ? cargoOutro.value.trim() 
                    : (cargoSelect.value || '');
                
                cargoHidden.value = valorFinal;
                
                // Validar
                if (!valorFinal) {
                    e.preventDefault();
                    e.stopPropagation();
                    alert('Por favor, selecione ou digite um cargo.');
                    if (cargoSelect.value === 'OUTRO') {
                        cargoOutro.focus();
                    } else {
                        cargoSelect.focus();
                    }
                    return false;
                }
            }, true);
        }
    }
    
    if (document.readyState === 'loading') {
        document.addEventListener('DOMContentLoaded', init);
    } else {
        init();
    }
})();
</script>

<?php /**PATH C:\Users\Alcidio\Desktop\escola\resources\views/admin/funcionarios-servicos/_cargo_fields.blade.php ENDPATH**/ ?>