

<?php $__env->startSection('title', 'Criar Funcionário - SGE'); ?>

<?php $__env->startSection('content'); ?>
<div class="row">
    <div class="col-md-8">
        <div class="card">
            <div class="card-header bg-primary-custom text-white py-2">
                <h5 class="mb-0"><?php echo e(__('common.create_employee')); ?></h5>
            </div>
            <div class="card-body p-3">
                <form method="POST" action="<?php echo e(route('admin.funcionarios.store')); ?>">
                    <?php echo csrf_field(); ?>

                    <div class="row g-2">
                        <div class="col-md-6">
                            <label for="name" class="form-label small mb-0"><?php echo e(__('common.name')); ?> *</label>
                            <input type="text" class="form-control form-control-sm <?php $__errorArgs = ['name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                   id="name" name="name" value="<?php echo e(old('name')); ?>" required>
                            <?php $__errorArgs = ['name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <div class="invalid-feedback small"><?php echo e($message); ?></div>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>

                        <div class="col-md-6">
                            <label for="email" class="form-label small mb-0"><?php echo e(__('common.email')); ?></label>
                            <input type="text" class="form-control form-control-sm" 
                                   id="email" name="email" value="<?php echo e(old('email')); ?>" readonly 
                                   style="background-color: #e9ecef; cursor: not-allowed;">
                            <small class="text-muted" style="font-size: 0.7rem;">Email será gerado automaticamente</small>
                        </div>
                    </div>

                    <hr class="my-3">

                    <div class="row g-2">
                        <div class="col-md-6">
                            <div class="form-check">
                                <input class="form-check-input" type="checkbox" id="gerir_alunos" name="gerir_alunos" value="1" <?php echo e(old('gerir_alunos') ? 'checked' : ''); ?>>
                                <label class="form-check-label small" for="gerir_alunos">Gerir Alunos</label>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-check">
                                <input class="form-check-input" type="checkbox" id="gerir_professores" name="gerir_professores" value="1" <?php echo e(old('gerir_professores') ? 'checked' : ''); ?>>
                                <label class="form-check-label small" for="gerir_professores">Gerir Professores</label>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-check">
                                <input class="form-check-input" type="checkbox" id="gerir_turmas" name="gerir_turmas" value="1" <?php echo e(old('gerir_turmas') ? 'checked' : ''); ?>>
                                <label class="form-check-label small" for="gerir_turmas">Gerir Turmas</label>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-check">
                                <input class="form-check-input" type="checkbox" id="gerir_disciplinas" name="gerir_disciplinas" value="1" <?php echo e(old('gerir_disciplinas') ? 'checked' : ''); ?>>
                                <label class="form-check-label small" for="gerir_disciplinas">Gerir Disciplinas</label>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-check">
                                <input class="form-check-input" type="checkbox" id="gerir_mensalidades" name="gerir_mensalidades" value="1" <?php echo e(old('gerir_mensalidades') ? 'checked' : ''); ?>>
                                <label class="form-check-label small" for="gerir_mensalidades">Gerir Mensalidades</label>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-check">
                                <input class="form-check-input" type="checkbox" id="gerir_horarios" name="gerir_horarios" value="1" <?php echo e(old('gerir_horarios') ? 'checked' : ''); ?>>
                                <label class="form-check-label small" for="gerir_horarios">Gerir Horários</label>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-check">
                                <input class="form-check-input" type="checkbox" id="gerir_eventos" name="gerir_eventos" value="1" <?php echo e(old('gerir_eventos') ? 'checked' : ''); ?>>
                                <label class="form-check-label small" for="gerir_eventos">Gerir Eventos</label>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-check">
                                <input class="form-check-input" type="checkbox" id="gerir_planos" name="gerir_planos" value="1" <?php echo e(old('gerir_planos') ? 'checked' : ''); ?>>
                                <label class="form-check-label small" for="gerir_planos">Gerir Planos</label>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-check">
                                <input class="form-check-input" type="checkbox" id="gerir_avaliacoes" name="gerir_avaliacoes" value="1" <?php echo e(old('gerir_avaliacoes') ? 'checked' : ''); ?>>
                                <label class="form-check-label small" for="gerir_avaliacoes">Gerir Avaliações</label>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-check">
                                <input class="form-check-input" type="checkbox" id="gerir_inscricoes" name="gerir_inscricoes" value="1" <?php echo e(old('gerir_inscricoes') ? 'checked' : ''); ?>>
                                <label class="form-check-label small" for="gerir_inscricoes">Gerir Inscrições</label>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-check">
                                <input class="form-check-input" type="checkbox" id="gerir_recuperacao_senha" name="gerir_recuperacao_senha" value="1" <?php echo e(old('gerir_recuperacao_senha') ? 'checked' : ''); ?>>
                                <label class="form-check-label small" for="gerir_recuperacao_senha">Recuperar Senhas (Alunos/Professores)</label>
                            </div>
                            <div class="form-check">
                                <input class="form-check-input" type="checkbox" id="gerir_pagamentos_professores" name="gerir_pagamentos_professores" value="1" <?php echo e(old('gerir_pagamentos_professores') ? 'checked' : ''); ?>>
                                <label class="form-check-label small" for="gerir_pagamentos_professores">Pagamentos de Professores</label>
                            </div>
                        </div>
                    </div>

                    <div class="mt-3">
                        <button type="submit" class="btn btn-sm btn-primary-custom"><?php echo e(__('common.save')); ?></button>
                        <a href="<?php echo e(route('admin.funcionarios.index')); ?>" class="btn btn-sm btn-secondary"><?php echo e(__('common.cancel')); ?></a>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

<script>
document.addEventListener('DOMContentLoaded', function() {
    const nameInput = document.getElementById('name');
    const emailInput = document.getElementById('email');
    
    if (nameInput && emailInput) {
        // Obter nome do colégio para preview
        const nomeColegio = '<?php echo e(\App\Models\Configuracao::get("escola", "colegio")); ?>';
        let nomeColegioNormalizado = nomeColegio.toLowerCase()
            .normalize('NFD')
            .replace(/[\u0300-\u036f]/g, '')
            .replace(/[^a-z0-9]/g, '');
        
        if (!nomeColegioNormalizado) {
            nomeColegioNormalizado = 'colegio';
        }
        
        nameInput.addEventListener('input', function() {
            // Gerar preview do email (não envia, só mostra)
            const nome = this.value.trim();
            if (nome) {
                // Dividir nome em partes
                const partesNome = nome.split(/\s+/).filter(p => p.length > 0);
                let nomeNormalizado = '';
                
                if (partesNome.length >= 2) {
                    // Tem primeiro nome e sobrenome: primeira letra + sobrenome
                    const primeiraLetra = partesNome[0].charAt(0).toLowerCase()
                        .normalize('NFD')
                        .replace(/[\u0300-\u036f]/g, '')
                        .replace(/[^a-z0-9]/g, '');
                    const sobrenome = partesNome[partesNome.length - 1].toLowerCase()
                        .normalize('NFD')
                        .replace(/[\u0300-\u036f]/g, '')
                        .replace(/[^a-z0-9]/g, '');
                    nomeNormalizado = primeiraLetra + sobrenome;
                } else if (partesNome.length === 1) {
                    // Apenas um nome: primeira letra + resto
                    const nomeCompleto = partesNome[0].toLowerCase()
                        .normalize('NFD')
                        .replace(/[\u0300-\u036f]/g, '')
                        .replace(/[^a-z0-9]/g, '');
                    if (nomeCompleto.length > 0) {
                        nomeNormalizado = nomeCompleto.charAt(0) + nomeCompleto.substring(1);
                    }
                }
                
                if (nomeNormalizado) {
                    emailInput.value = nomeNormalizado + '@' + nomeColegioNormalizado + '.edu.mz';
                } else {
                    emailInput.value = '';
                }
            } else {
                emailInput.value = '';
            }
        });
        
        // Gerar preview inicial se já houver nome
        if (nameInput.value) {
            nameInput.dispatchEvent(new Event('input'));
        }
    }
});
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\Users\Alcidio\Desktop\escola\resources\views/admin/funcionarios/create.blade.php ENDPATH**/ ?>