

<?php $__env->startSection('title', 'Configurar Valores e Modalidades - SIGE'); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid py-3">
    <div class="d-flex justify-content-between align-items-center mb-4">
        <div>
            <h5 class="mb-0" style="font-weight: 500;">Configurar Valores e Modalidades</h5>
            <small class="text-muted">Personalize valores e modalidades de pagamento por aluno</small>
        </div>
        <a href="<?php echo e(route('financeiro.index', ['ano_letivo_id' => $anoLetivoId])); ?>" class="btn btn-sm btn-link text-muted" style="text-decoration: none;">
            ← Voltar
        </a>
    </div>

    <!-- Filtros -->
    <div class="card border-0 mb-4" style="box-shadow: 0 1px 3px rgba(0,0,0,0.05);">
        <div class="card-body p-3">
            <form method="GET" action="<?php echo e(route('financeiro.configurar-mensalidades')); ?>" class="row g-2">
                <div class="col-md-2">
                    <label class="form-label small mb-1 text-muted">Ano Lectivo</label>
                    <select class="form-select form-select-sm" name="ano_letivo_id" style="background: #f8f9fa; border: 1px solid #dee2e6;" onchange="this.form.submit()">
                        <?php $__currentLoopData = $anosLetivos ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $ano): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($ano->id); ?>" <?php echo e($anoLetivoId == $ano->id ? 'selected' : ''); ?>>
                                <?php
                                    $anoRaw = $ano->getRawOriginal('ano');
                                    $anoFinal = strpos($anoRaw, '/') !== false ? explode('/', $anoRaw)[1] : $anoRaw;
                                ?>
                                <?php echo e($anoFinal); ?>

                                <?php if($ano->ativo): ?> (Activo) <?php endif; ?>
                            </option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>
                <div class="col-md-3">
                    <label class="form-label small mb-1 text-muted">Classe</label>
                    <select class="form-select form-select-sm" name="classe" style="background: #f8f9fa; border: 1px solid #dee2e6;">
                        <option value="">Todas</option>
                        <?php $__currentLoopData = $classes ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $classeOption): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($classeOption); ?>" <?php echo e(($classe ?? '') == $classeOption ? 'selected' : ''); ?>>
                                <?php echo e($classeOption); ?>

                            </option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>
                <div class="col-md-4">
                    <label class="form-label small mb-1 text-muted">Pesquisar</label>
                    <input type="text" 
                           class="form-control form-control-sm" 
                           name="pesquisa" 
                           value="<?php echo e($pesquisa ?? ''); ?>" 
                           placeholder="Nome do aluno..."
                           style="background: #f8f9fa; border: 1px solid #dee2e6;">
                </div>
                <div class="col-md-3 d-flex align-items-end gap-2">
                    <button type="submit" class="btn btn-sm px-3" style="background: #0d6efd; color: white; border: none;">
                        Filtrar
                    </button>
                    <a href="<?php echo e(route('financeiro.configurar-mensalidades', ['ano_letivo_id' => $anoLetivoId])); ?>" class="btn btn-sm btn-link text-muted" style="text-decoration: none;">
                        Limpar
                    </a>
                </div>
            </form>
        </div>
    </div>

    <?php if(session('success')): ?>
        <div class="alert alert-success alert-dismissible fade show" role="alert">
            <?php echo e(session('success')); ?>

            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    <?php endif; ?>

    <!-- Formulário -->
    <form method="POST" action="<?php echo e(route('financeiro.configurar-mensalidades.store')); ?>">
        <?php echo csrf_field(); ?>
        <input type="hidden" name="ano_letivo_id" value="<?php echo e($anoLetivoId); ?>">
        
        <!-- Barra de Acções -->
        <div class="d-flex justify-content-between align-items-center mb-3">
            <div class="d-flex align-items-center gap-3">
                <input type="checkbox" id="selectAllConfig" onchange="toggleSelectAllConfig()" class="form-check-input" style="margin-top: 0;">
                <input type="text" 
                       id="filtroNomeConfig" 
                       class="form-control form-control-sm" 
                       style="width: 200px; background: #f8f9fa; font-size: 0.875rem; border: 1px solid #dee2e6;" 
                       placeholder="Buscar...">
                <select id="filtroModalidadeConfig" class="form-select form-select-sm" style="width: 130px; background: #f8f9fa; font-size: 0.875rem; border: 1px solid #dee2e6;">
                    <option value="">Modalidade</option>
                    <option value="MENSAL">Mensal</option>
                    <option value="TRIMESTRAL">Trimestral</option>
                    <option value="SEMESTRAL">Semestral</option>
                    <option value="ANUAL">Anual</option>
                </select>
            </div>
            <div class="d-flex gap-2">
                <button type="submit" class="btn btn-sm px-4" style="background: #0d6efd; color: white; border: none; font-size: 0.875rem;">
                    Salvar
                </button>
            </div>
        </div>

        <!-- Tabela -->
        <div class="card border-0" style="box-shadow: 0 1px 3px rgba(0,0,0,0.05);">
            <div class="table-responsive" style="max-height: 600px; overflow-y: auto;">
                <table class="table table-sm mb-0" id="tabelaConfiguracao" style="border-collapse: separate; border-spacing: 0;">
                    <thead class="sticky-top" style="background: #fff; border-bottom: 1px solid #e9ecef;">
                        <tr>
                            <th style="width: 35px; padding: 12px; font-weight: 500; font-size: 0.8rem; color: #6c757d;"></th>
                            <th style="padding: 12px; font-weight: 500; font-size: 0.8rem; color: #6c757d;">Aluno</th>
                            <th style="padding: 12px; font-weight: 500; font-size: 0.8rem; color: #6c757d;">Código</th>
                            <th style="padding: 12px; font-weight: 500; font-size: 0.8rem; color: #6c757d;">Turma</th>
                            <th style="padding: 12px; width: 150px; font-weight: 500; font-size: 0.8rem; color: #6c757d;">Valor (MT)</th>
                            <th style="padding: 12px; width: 150px; font-weight: 500; font-size: 0.8rem; color: #6c757d;">Modalidade</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__empty_1 = true; $__currentLoopData = $alunos ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $aluno): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <?php
                                $turmaAluno = $aluno->turmas->first();
                            ?>
                            <tr class="linha-config" 
                                data-nome="<?php echo e(strtolower($aluno->user->name ?? '')); ?>" 
                                data-modalidade="<?php echo e($aluno->modalidade_pagamento ?? 'MENSAL'); ?>"
                                data-turma="<?php echo e($turmaAluno->id ?? ''); ?>"
                                style="border-bottom: 1px solid #f8f9fa;">
                                <td style="padding: 12px;">
                                    <input type="checkbox" name="alunos[]" value="<?php echo e($aluno->id); ?>" class="aluno-config-checkbox form-check-input" style="margin-top: 0;">
                                </td>
                                <td style="padding: 12px; font-size: 0.875rem;"><?php echo e($aluno->user->name ?? '-'); ?></td>
                                <td style="padding: 12px; font-size: 0.875rem; color: #6c757d;"><?php echo e($aluno->codigo_estudante ?? '-'); ?></td>
                                <td style="padding: 12px; font-size: 0.875rem; color: #6c757d;"><?php echo e($turmaAluno->codigo ?? '-'); ?></td>
                                <td style="padding: 12px;">
                                    <input type="number" 
                                           step="0.01" 
                                           min="0" 
                                           class="form-control form-control-sm border-0" 
                                           name="valores[<?php echo e($aluno->id); ?>]" 
                                           value="<?php echo e($aluno->valor_mensalidade_personalizado ?? ''); ?>" 
                                           placeholder="—"
                                           style="font-size: 0.875rem; background: #f8f9fa; padding: 6px 10px;">
                                </td>
                                <td style="padding: 12px;">
                                    <select class="form-select form-select-sm border-0" name="modalidades[<?php echo e($aluno->id); ?>]" style="font-size: 0.875rem; background: #f8f9fa; padding: 6px 10px;">
                                        <option value="MENSAL" <?php echo e(($aluno->modalidade_pagamento ?? 'MENSAL') == 'MENSAL' ? 'selected' : ''); ?>>Mensal</option>
                                        <option value="TRIMESTRAL" <?php echo e(($aluno->modalidade_pagamento ?? 'MENSAL') == 'TRIMESTRAL' ? 'selected' : ''); ?>>Trimestral</option>
                                        <option value="SEMESTRAL" <?php echo e(($aluno->modalidade_pagamento ?? 'MENSAL') == 'SEMESTRAL' ? 'selected' : ''); ?>>Semestral</option>
                                        <option value="ANUAL" <?php echo e(($aluno->modalidade_pagamento ?? 'MENSAL') == 'ANUAL' ? 'selected' : ''); ?>>Anual</option>
                                    </select>
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <tr>
                                <td colspan="6" class="text-center py-5 text-muted">
                                    Nenhum aluno encontrado
                                </td>
                            </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </form>
</div>

<script>
    function toggleSelectAllConfig() {
        const selectAll = document.getElementById('selectAllConfig');
        const checkboxes = document.querySelectorAll('.aluno-config-checkbox:not([style*="display: none"])');
        checkboxes.forEach(cb => {
            if (cb.closest('tr').style.display !== 'none') {
                cb.checked = selectAll.checked;
            }
        });
    }

    // Filtros
    let filtrosInicializados = false;
    function inicializarFiltrosConfig() {
        if (filtrosInicializados) return;
        
        const filtroNome = document.getElementById('filtroNomeConfig');
        const filtroModalidade = document.getElementById('filtroModalidadeConfig');
        
        if (!filtroNome || !filtroModalidade) return;
        
        function aplicarFiltros() {
            const nomeFiltro = filtroNome.value.toLowerCase().trim();
            const modalidadeFiltro = filtroModalidade.value;
            
            const linhas = document.querySelectorAll('#tabelaConfiguracao tbody tr.linha-config');
            
            linhas.forEach(linha => {
                const nome = (linha.getAttribute('data-nome') || '').toLowerCase();
                const modalidade = linha.getAttribute('data-modalidade') || '';
                
                const matchNome = !nomeFiltro || nome.includes(nomeFiltro);
                const matchModalidade = !modalidadeFiltro || modalidade === modalidadeFiltro;
                
                if (matchNome && matchModalidade) {
                    linha.style.display = '';
                } else {
                    linha.style.display = 'none';
                }
            });
            
            const selectAll = document.getElementById('selectAllConfig');
            if (selectAll) {
                selectAll.checked = false;
            }
        }
        
        filtroNome.addEventListener('input', aplicarFiltros);
        filtroModalidade.addEventListener('change', aplicarFiltros);
        
        filtrosInicializados = true;
    }

    document.addEventListener('DOMContentLoaded', function() {
        inicializarFiltrosConfig();
    });
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\Users\Alcidio\Desktop\escola\resources\views/financeiro/configurar-mensalidades.blade.php ENDPATH**/ ?>