

<?php $__env->startSection('title', 'Estatísticas de Avaliações'); ?>

<?php $__env->startSection('content'); ?>
<div class="row">
    <div class="col-12">
        <div class="d-flex justify-content-between align-items-center mb-3">
            <h2>Estatísticas de Aprovação/Reprovação</h2>
            <a href="<?php echo e(route('avaliacoes.index')); ?>" class="btn btn-secondary btn-sm">Voltar</a>
        </div>

        <div class="card mb-3">
            <div class="card-body">
                <form method="GET" action="<?php echo e(route('avaliacoes.estatisticas')); ?>" class="row g-3">
                    <div class="col-md-3">
                        <label for="turma_id" class="form-label">Turma</label>
                        <select name="turma_id" id="turma_id" class="form-select" required>
                            <option value="">Selecione a Turma</option>
                            <?php $__currentLoopData = $turmas; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $turma): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($turma->id); ?>" <?php echo e($turmaId == $turma->id ? 'selected' : ''); ?>>
                                    <?php echo e($turma->codigo); ?> - <?php echo e($turma->nome); ?>

                                </option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>
                    <div class="col-md-3">
                        <label for="tipo" class="form-label">Tipo</label>
                        <select name="tipo" id="tipo" class="form-select">
                            <option value="anual" <?php echo e($tipo == 'anual' ? 'selected' : ''); ?>>Anual</option>
                            <option value="trimestral" <?php echo e($tipo == 'trimestral' ? 'selected' : ''); ?>>Por Trimestre</option>
                        </select>
                    </div>
                    <div class="col-md-3" id="trimestre-container" style="display: <?php echo e($tipo == 'trimestral' ? 'block' : 'none'); ?>;">
                        <label for="trimestre_id" class="form-label">Trimestre</label>
                        <select name="trimestre_id" id="trimestre_id" class="form-select">
                            <option value="">Selecione o Trimestre</option>
                            <?php $__currentLoopData = $trimestres; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $trimestre): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($trimestre->id); ?>" <?php echo e($trimestreId == $trimestre->id ? 'selected' : ''); ?>>
                                    <?php echo e($trimestre->numero); ?>° Trimestre
                                </option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>
                    <div class="col-md-3 d-flex align-items-end">
                        <button type="submit" class="btn btn-primary">Buscar</button>
                    </div>
                </form>
            </div>
        </div>

        <?php if($turmaId && !empty($estatisticas)): ?>
            <?php
                $turma = $turmas->firstWhere('id', $turmaId);
            ?>
            <div class="card mb-3">
                <div class="card-header bg-info text-white">
                    <h5 class="mb-0">
                        Estatísticas - <?php echo e($turma->codigo); ?> - <?php echo e($turma->nome); ?>

                        <?php if($tipo == 'trimestral' && $trimestreId): ?>
                            - <?php echo e($trimestres->firstWhere('id', $trimestreId)->numero); ?>° Trimestre
                        <?php else: ?>
                            - Anual
                        <?php endif; ?>
                    </h5>
                </div>
            </div>

            <?php $__currentLoopData = $estatisticas; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $disciplinaId => $stats): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <?php
                    $disciplina = \App\Models\Disciplina::find($disciplinaId);
                ?>
                <div class="card mb-3">
                    <div class="card-header bg-primary text-white">
                        <h5 class="mb-0"><?php echo e($disciplina->nome); ?></h5>
                    </div>
                    <div class="card-body">
                        <div class="row">
                            <div class="col-md-6">
                                <h6 class="text-success">Aprovados</h6>
                                <table class="table table-sm table-bordered">
                                    <thead class="table-light">
                                        <tr>
                                            <th>Gênero</th>
                                            <th>Quantidade</th>
                                            <th>Percentual</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <tr>
                                            <td>Homens</td>
                                            <td><strong><?php echo e($stats['aprovados_homens']); ?></strong></td>
                                            <td><?php echo e($stats['total'] > 0 ? number_format(($stats['aprovados_homens'] / $stats['total']) * 100, 1) : 0); ?>%</td>
                                        </tr>
                                        <tr>
                                            <td>Mulheres</td>
                                            <td><strong><?php echo e($stats['aprovados_mulheres']); ?></strong></td>
                                            <td><?php echo e($stats['total'] > 0 ? number_format(($stats['aprovados_mulheres'] / $stats['total']) * 100, 1) : 0); ?>%</td>
                                        </tr>
                                        <tr class="table-success">
                                            <td><strong>Total</strong></td>
                                            <td><strong><?php echo e($stats['total_aprovados']); ?></strong></td>
                                            <td><strong><?php echo e($stats['total'] > 0 ? number_format(($stats['total_aprovados'] / $stats['total']) * 100, 1) : 0); ?>%</strong></td>
                                        </tr>
                                    </tbody>
                                </table>
                            </div>
                            <div class="col-md-6">
                                <h6 class="text-danger">Reprovados</h6>
                                <table class="table table-sm table-bordered">
                                    <thead class="table-light">
                                        <tr>
                                            <th>Gênero</th>
                                            <th>Quantidade</th>
                                            <th>Percentual</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <tr>
                                            <td>Homens</td>
                                            <td><strong><?php echo e($stats['reprovados_homens']); ?></strong></td>
                                            <td><?php echo e($stats['total'] > 0 ? number_format(($stats['reprovados_homens'] / $stats['total']) * 100, 1) : 0); ?>%</td>
                                        </tr>
                                        <tr>
                                            <td>Mulheres</td>
                                            <td><strong><?php echo e($stats['reprovados_mulheres']); ?></strong></td>
                                            <td><?php echo e($stats['total'] > 0 ? number_format(($stats['reprovados_mulheres'] / $stats['total']) * 100, 1) : 0); ?>%</td>
                                        </tr>
                                        <tr class="table-danger">
                                            <td><strong>Total</strong></td>
                                            <td><strong><?php echo e($stats['total_reprovados']); ?></strong></td>
                                            <td><strong><?php echo e($stats['total'] > 0 ? number_format(($stats['total_reprovados'] / $stats['total']) * 100, 1) : 0); ?>%</strong></td>
                                        </tr>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                        <div class="row mt-3">
                            <div class="col-md-12">
                                <div class="alert alert-warning">
                                    <strong>Desistiram:</strong> <?php echo e($stats['desistiram']); ?> estudante(s)
                                    (<?php echo e($stats['total'] > 0 ? number_format(($stats['desistiram'] / $stats['total']) * 100, 1) : 0); ?>%)
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-12">
                                <div class="progress" style="height: 30px;">
                                    <div class="progress-bar bg-success" role="progressbar" 
                                         style="width: <?php echo e($stats['total'] > 0 ? ($stats['total_aprovados'] / $stats['total']) * 100 : 0); ?>%"
                                         aria-valuenow="<?php echo e($stats['total_aprovados']); ?>" 
                                         aria-valuemin="0" 
                                         aria-valuemax="<?php echo e($stats['total']); ?>">
                                        Aprovados: <?php echo e($stats['total_aprovados']); ?>

                                    </div>
                                    <div class="progress-bar bg-danger" role="progressbar" 
                                         style="width: <?php echo e($stats['total'] > 0 ? ($stats['total_reprovados'] / $stats['total']) * 100 : 0); ?>%"
                                         aria-valuenow="<?php echo e($stats['total_reprovados']); ?>" 
                                         aria-valuemin="0" 
                                         aria-valuemax="<?php echo e($stats['total']); ?>">
                                        Reprovados: <?php echo e($stats['total_reprovados']); ?>

                                    </div>
                                    <div class="progress-bar bg-warning" role="progressbar" 
                                         style="width: <?php echo e($stats['total'] > 0 ? ($stats['desistiram'] / $stats['total']) * 100 : 0); ?>%"
                                         aria-valuenow="<?php echo e($stats['desistiram']); ?>" 
                                         aria-valuemin="0" 
                                         aria-valuemax="<?php echo e($stats['total']); ?>">
                                        Desistiram: <?php echo e($stats['desistiram']); ?>

                                    </div>
                                </div>
                                <p class="mt-2 text-center"><strong>Total de Estudantes:</strong> <?php echo e($stats['total']); ?></p>
                            </div>
                        </div>
                    </div>
                </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        <?php elseif($turmaId): ?>
            <div class="alert alert-info">
                Selecione uma turma e tipo de estatística para visualizar os dados.
            </div>
        <?php endif; ?>
    </div>
</div>

<script>
    document.getElementById('tipo').addEventListener('change', function() {
        const tipo = this.value;
        const trimestreContainer = document.getElementById('trimestre-container');
        const trimestreSelect = document.getElementById('trimestre_id');
        
        if (tipo === 'trimestral') {
            trimestreContainer.style.display = 'block';
            trimestreSelect.required = true;
        } else {
            trimestreContainer.style.display = 'none';
            trimestreSelect.required = false;
            trimestreSelect.value = '';
        }
    });
</script>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\Users\Alcidio\Desktop\escola\resources\views/avaliacoes/estatisticas.blade.php ENDPATH**/ ?>