

<?php $__env->startSection('title', 'Detalhes do Aluno - SGE'); ?>

<?php $__env->startSection('content'); ?>
<div class="row">
    <div class="col-12">
        <div class="d-flex justify-content-between align-items-center mb-2" style="border-bottom: 1px solid #dee2e6; padding-bottom: 8px;">
            <div>
                <h5 class="mb-0" style="font-weight: 600;"><?php echo e($aluno->user->name); ?></h5>
                <small class="text-muted"><?php echo e($aluno->codigo_estudante); ?></small>
            </div>
            <div class="d-flex gap-1">
                <a href="<?php echo e(route('admin.alunos.ficha-inscricao', $aluno)); ?>" class="btn btn-sm btn-primary" target="_blank" title="Ficha de Inscrição">
                    <i class="bi bi-file-earmark-text"></i> Ficha de Inscrição
                </a>
                <a href="<?php echo e(route('admin.alunos.folheto', $aluno)); ?>" class="btn btn-sm btn-warning" target="_blank" title="Folheto">
                    <i class="bi bi-file-text"></i>
                </a>
                <a href="<?php echo e(route('admin.alunos.edit', $aluno)); ?>" class="btn btn-sm btn-primary">
                    <i class="bi bi-pencil"></i> Editar
                </a>
                <a href="<?php echo e(route('admin.alunos.index')); ?>" class="btn btn-sm btn-secondary">
                    <i class="bi bi-arrow-left"></i> Voltar
                </a>
            </div>
        </div>

        <div class="row">
            <div class="col-md-6 mb-3">
                <div class="mb-1">
                    <small class="text-muted" style="font-weight: 600;">Informações Pessoais</small>
                </div>
                <div style="background: #f8f9fa; padding: 10px; border-radius: 4px; font-size: 0.85rem;">
                    <div class="row mb-2">
                        <div class="col-4 text-center">
                            <?php if($aluno->foto): ?>
                                <img src="<?php echo e(asset('storage/' . $aluno->foto)); ?>" 
                                     alt="Foto" 
                                     style="max-width: 80px; max-height: 100px; object-fit: cover; border-radius: 4px;">
                            <?php else: ?>
                                <div style="width: 80px; height: 100px; background-color: #e9ecef; border-radius: 4px; display: flex; align-items: center; justify-content: center; margin: 0 auto;">
                                    <span class="text-muted" style="font-size: 0.7rem;">Sem foto</span>
                                </div>
                            <?php endif; ?>
                        </div>
                        <div class="col-8">
                            <div class="mb-1"><strong>Nome:</strong> <?php echo e($aluno->user->name); ?></div>
                            <div class="mb-1"><strong>Telefone:</strong> <?php echo e($aluno->telefone ?? 'N/A'); ?></div>
                            <div class="mb-1"><strong>Status:</strong> 
                                <?php if($aluno->user && $aluno->user->is_active): ?>
                                    <span style="font-size: 0.75rem; padding: 2px 6px; background: #d4edda; color: #155724; border-radius: 3px;">Activo</span>
                                <?php else: ?>
                                    <span style="font-size: 0.75rem; padding: 2px 6px; background: #f8d7da; color: #721c24; border-radius: 3px;">Bloqueado</span>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-12 mb-1"><strong>Endereço:</strong> <?php echo e($aluno->endereco ?? 'N/A'); ?></div>
                        <div class="col-12 mb-1"><strong>Data de Nascimento:</strong> <?php echo e($aluno->data_nascimento ? $aluno->data_nascimento->format('d/m/Y') : 'N/A'); ?></div>
                        <div class="col-12 mb-1"><strong>Gênero:</strong> 
                            <?php if($aluno->genero == 'M'): ?>
                                Masculino
                            <?php elseif($aluno->genero == 'F'): ?>
                                Feminino
                            <?php elseif($aluno->genero == 'Outro'): ?>
                                Outro
                            <?php else: ?>
                                N/A
                            <?php endif; ?>
                        </div>
                    </div>
                    <div class="d-flex gap-1 mt-2">
                        <a href="<?php echo e(route('admin.alunos.view', $aluno)); ?>" class="btn btn-sm" style="padding: 2px 6px; font-size: 0.75rem; background: #d1ecf1; color: #0c5460; border: none;">
                            <i class="bi bi-eye"></i> Ver Mais
                        </a>
                        <a href="<?php echo e(route('admin.alunos.imprimir-cartao', $aluno)); ?>" class="btn btn-sm" style="padding: 2px 6px; font-size: 0.75rem; background: #d1ecf1; color: #0c5460; border: none;" target="_blank">
                            <i class="bi bi-card-heading"></i> Cartão
                        </a>
                    </div>
                </div>
            </div>

            <div class="col-md-6 mb-3">
                <div class="mb-1">
                    <small class="text-muted" style="font-weight: 600;">Encarregado</small>
                </div>
                <div style="background: #f8f9fa; padding: 10px; border-radius: 4px; font-size: 0.85rem;">
                    <div class="mb-1"><strong>Nome:</strong> <?php echo e($aluno->nome_encarregado ?? 'N/A'); ?></div>
                    <div class="mb-1"><strong>Telefone:</strong> <?php echo e($aluno->telefone_encarregado ?? 'N/A'); ?></div>
                </div>

                <div class="mb-1 mt-2">
                    <small class="text-muted" style="font-weight: 600;">Acções</small>
                </div>
                <div style="background: #f8f9fa; padding: 10px; border-radius: 4px;">
                    <form action="<?php echo e(route('admin.alunos.toggle-status', $aluno)); ?>" method="POST" class="mb-1">
                        <?php echo csrf_field(); ?>
                        <?php echo method_field('PATCH'); ?>
                        <button type="submit" class="btn btn-sm w-100" style="font-size: 0.75rem; background: <?php echo e($aluno->user && $aluno->user->is_active ? '#fff3cd' : '#d4edda'); ?>; color: <?php echo e($aluno->user && $aluno->user->is_active ? '#856404' : '#155724'); ?>; border: none;">
                            <i class="bi bi-<?php echo e($aluno->user && $aluno->user->is_active ? 'lock' : 'unlock'); ?>"></i>
                            <?php echo e($aluno->user && $aluno->user->is_active ? 'Bloquear Acesso' : 'Ativar Acesso'); ?>

                        </button>
                    </form>
                    <form action="<?php echo e(route('admin.alunos.destroy', $aluno)); ?>" method="POST"
                          onsubmit="return confirm('Tem certeza que deseja eliminar este aluno?');">
                        <?php echo csrf_field(); ?>
                        <?php echo method_field('DELETE'); ?>
                        <button type="submit" class="btn btn-sm btn-danger w-100" style="font-size: 0.75rem;">
                            <i class="bi bi-trash"></i> Eliminar
                        </button>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\Users\Alcidio\Desktop\escola\resources\views/admin/alunos/show.blade.php ENDPATH**/ ?>