

<?php $__env->startSection('title', 'Facturas - Estudante'); ?>

<?php $__env->startSection('content'); ?>
<div class="row">
    <div class="col-12">
        <div class="d-flex justify-content-between align-items-center mb-3">
            <h4 class="mb-0">
                <i class="bi bi-receipt text-primary me-2"></i>
                Minhas Facturas
            </h4>
            <a href="<?php echo e(route('aluno.financeiro')); ?>" class="btn btn-secondary btn-sm">
                <i class="bi bi-arrow-left"></i> Voltar
            </a>
        </div>
    </div>
</div>

<?php if($invoices->count() > 0): ?>
    <div class="table-responsive">
        <table class="table table-hover">
            <thead>
                <tr>
                    <th>Número</th>
                    <th>Data Emissão</th>
                    <th>Valor</th>
                    <th>Status</th>
                    <th>Acções</th>
                </tr>
            </thead>
            <tbody>
                <?php $__currentLoopData = $invoices; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $invoice): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <td><?php echo e($invoice->numero_factura); ?></td>
                        <td><?php echo e($invoice->data_emissao->format('d/m/Y')); ?></td>
                        <td><?php echo e(number_format($invoice->valor, 2, ',', '.')); ?> MT</td>
                        <td>
                            <?php if($invoice->status === 'PAGA'): ?>
                                <span class="badge bg-success">Paga</span>
                            <?php else: ?>
                                <span class="badge bg-warning">Pendente</span>
                            <?php endif; ?>
                        </td>
                        <td>
                            <a href="<?php echo e(route('aluno.invoice.show', $invoice)); ?>" class="btn btn-sm btn-primary">
                                <i class="bi bi-eye"></i> Ver
                            </a>
                            <?php if($invoice->status === 'PAGA'): ?>
                                <a href="<?php echo e(route('aluno.invoice.download', $invoice)); ?>" class="btn btn-sm btn-outline-primary">
                                    <i class="bi bi-download"></i> PDF
                                </a>
                            <?php endif; ?>
                        </td>
                    </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </tbody>
        </table>
    </div>
<?php else: ?>
    <div class="alert alert-info text-center">
        <i class="bi bi-inbox display-4 d-block mb-3"></i>
        Nenhuma factura encontrada.
    </div>
<?php endif; ?>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\Users\Alcidio\Desktop\escola\resources\views/aluno/invoice/index.blade.php ENDPATH**/ ?>