<?php $__env->startSection('title', 'Horários - SGE'); ?>

<?php $__env->startSection('content'); ?>
<style>
    .horario-cell {
        padding: 6px 4px;
        text-align: center;
        font-size: 0.75rem;
        vertical-align: middle;
        min-height: 60px;
        border: 1px solid #dee2e6;
        position: relative;
    }
    .horario-cell.empty {
        background-color: #ffffff;
    }
    .horario-header {
        background-color: #e9ecef;
        font-weight: 600;
        text-align: center;
        padding: 10px 6px;
        font-size: 0.85rem;
        border: 1px solid #dee2e6;
    }
    .horario-time {
        background-color: #f8f9fa;
        font-weight: 600;
        text-align: center;
        padding: 10px 6px;
        font-size: 0.85rem;
        width: 90px;
        border: 1px solid #dee2e6;
    }
    .disciplina-badge {
        display: block;
        padding: 3px 5px;
        border-radius: 3px;
        font-weight: 600;
        margin-bottom: 3px;
        font-size: 0.75rem;
    }
    .professor-name {
        font-size: 0.7rem;
        color: #495057;
        font-weight: 500;
        display: block;
        margin-top: 2px;
    }
    .horario-table {
        border-collapse: collapse;
        width: 100%;
    }
    .horario-table td, .horario-table th {
        border: 1px solid #dee2e6;
    }
    .toolbar-fixed {
        position: sticky;
        top: 0;
        z-index: 1000;
        background-color: #fff;
        padding: 12px 0;
        margin-bottom: 20px;
        border-bottom: 2px solid #dee2e6;
        box-shadow: 0 2px 8px rgba(0,0,0,0.15);
    }
    .toolbar-fixed.is-fixed {
        position: fixed;
        top: 0;
        left: 0;
        right: 0;
        margin: 0;
        padding: 12px 0;
        width: 100%;
        box-shadow: 0 2px 8px rgba(0,0,0,0.25);
    }
    .toolbar-placeholder {
        display: none;
    }
</style>

<div class="row">
    <div class="col-12">
        <div id="toolbarPlaceholder" class="toolbar-placeholder"></div>
        <div id="toolbarHorarios" class="toolbar-fixed">
            <div class="d-flex justify-content-between align-items-center" style="flex-wrap: wrap; gap: 10px;">
                <h5 class="mb-0" style="font-weight: 600;">Horários</h5>
                <?php if(auth()->user()->isAdmin() || auth()->user()->isSuperadmin() || auth()->user()->podeGerir('gerir_horarios')): ?>
                    <div style="display: flex; gap: 8px; align-items: center; flex-wrap: wrap;">
                        <form method="GET" action="<?php echo e(route('horarios.index')); ?>" style="display: flex; gap: 8px; align-items: center;">
                            <select name="nivel_ensino" id="nivel_ensino" class="form-select form-select-sm" style="width: auto; min-width: 150px;">
                                <option value="">Todos os Níveis</option>
                                <option value="PRIMARIO" <?php echo e(($nivelEnsinoFiltro ?? '') == 'PRIMARIO' ? 'selected' : ''); ?>>Primário</option>
                                <option value="SECUNDARIO" <?php echo e(($nivelEnsinoFiltro ?? '') == 'SECUNDARIO' ? 'selected' : ''); ?>>Secundário</option>
                            </select>
                            <select name="turma_id" id="turma_id" class="form-select form-select-sm" style="width: auto; min-width: 200px;">
                                <option value="">Todas as Turmas</option>
                                <?php $__currentLoopData = $todasTurmas ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $turma): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($turma->id); ?>" <?php echo e(($turmaFiltro ?? '') == $turma->id ? 'selected' : ''); ?>>
                                        <?php echo e($turma->codigo); ?> - <?php echo e($turma->nome); ?>

                                    </option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                            <button type="submit" class="btn btn-sm btn-primary">
                                <i class="bi bi-search"></i> Filtrar
                            </button>
                            <?php if($turmaFiltro || ($nivelEnsinoFiltro ?? '')): ?>
                                <a href="<?php echo e(route('horarios.index')); ?>" class="btn btn-sm btn-secondary">
                                    <i class="bi bi-x-circle"></i> Limpar
                                </a>
                            <?php endif; ?>
                        </form>
                        <a href="<?php echo e(route('horarios.download-pdf', ['turma_id' => $turmaFiltro])); ?>" class="btn btn-sm btn-danger">
                            <i class="bi bi-file-earmark-pdf"></i> Download PDF
                        </a>
                        <a href="<?php echo e(route('horarios.gerar-automatico')); ?>" class="btn btn-sm btn-success">
                            <i class="bi bi-magic"></i> Gerar Automaticamente
                        </a>
                        <a href="<?php echo e(route('horarios.gerar-todas-turmas')); ?>" class="btn btn-sm btn-info">
                            <i class="bi bi-calendar-check"></i> Gerar Todas as Turmas
                        </a>
                    </div>
                <?php endif; ?>
            </div>
        </div>

<script>
document.addEventListener('DOMContentLoaded', () => {
    const toolbar = document.getElementById('toolbarHorarios');
    const placeholder = document.getElementById('toolbarPlaceholder');
    if (!toolbar || !placeholder) return;

    const updateFixed = () => {
        const rect = toolbar.getBoundingClientRect();
        const initialTop = parseFloat(toolbar.dataset.initialTop || '0');
        const initialLeft = parseFloat(toolbar.dataset.initialLeft || '0');
        const initialWidth = parseFloat(toolbar.dataset.initialWidth || '0');

        const offsetTop = initialTop || (rect.top + window.scrollY);
        const shouldFix = window.scrollY >= offsetTop;

        if (shouldFix) {
            toolbar.classList.add('is-fixed');
            toolbar.style.left = `${initialLeft}px`;
            toolbar.style.width = `${initialWidth}px`;
            toolbar.style.right = 'auto';
            placeholder.style.display = 'block';
            placeholder.style.height = `${toolbar.offsetHeight}px`;
        } else {
            toolbar.classList.remove('is-fixed');
            toolbar.style.left = '';
            toolbar.style.width = '';
            toolbar.style.right = '';
            placeholder.style.display = 'none';
            placeholder.style.height = '0px';
        }
    };

    const storeInitial = () => {
        const rect = toolbar.getBoundingClientRect();
        toolbar.dataset.initialTop = rect.top + window.scrollY;
        toolbar.dataset.initialLeft = rect.left + window.scrollX;
        toolbar.dataset.initialWidth = rect.width;
        placeholder.style.height = `${toolbar.offsetHeight}px`;
    };

    // Guardar offset inicial
    storeInitial();

    window.addEventListener('scroll', updateFixed, { passive: true });
    window.addEventListener('resize', () => {
        storeInitial();
        updateFixed();
    });

    updateFixed();
});
</script>
        <?php if(isset($grades) && count($grades) > 0): ?>
            <div class="js-ajax-pagination">
            <?php $__currentLoopData = $grades; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $turmaId => $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <?php
                    $turma = $data['turma'];
                    $grade = $data['grade'];
                    $horarios = $data['horarios'];
                    $diasAbreviados = ['Segunda' => 'Seg', 'Terça' => 'Ter', 'Quarta' => 'Qua', 'Quinta' => 'Qui', 'Sexta' => 'Sex'];
                    
                    // Cores para disciplinas (gerar baseado no nome)
                    $coresDisciplinas = [];
                    $disciplinasUnicas = [];
                    foreach ($grade as $hora => $dias) {
                        foreach ($dias as $dia => $horario) {
                            if ($horario && $horario->disciplina) {
                                $disciplinasUnicas[$horario->disciplina->id] = $horario->disciplina->nome;
                            }
                        }
                    }
                    $paletaCores = [
                        '#d4edda', '#fff3cd', '#d1ecf1', '#f8d7da', 
                        '#e2e3e5', '#d4edda', '#cce5ff', '#ffe6cc',
                        '#e6f3ff', '#ffe6f0', '#f0e6ff', '#fff0e6'
                    ];
                    $corIndex = 0;
                    foreach ($disciplinasUnicas as $id => $nome) {
                        $coresDisciplinas[$id] = $paletaCores[$corIndex % count($paletaCores)];
                        $corIndex++;
                    }
                ?>
                
                <div style="background: #fff; padding: 15px; border-radius: 4px; margin-bottom: 20px; box-shadow: 0 1px 3px rgba(0,0,0,0.1);">
                    <div class="d-flex justify-content-between align-items-center mb-3">
                        <h6 style="font-weight: 600; margin-bottom: 0; font-size: 0.95rem; color: #495057;">
                            Sala: <?php echo e($turma->codigo ?? ''); ?> - <?php echo e($turma->nome ?? 'Turma #' . $turmaId); ?>

                        </h6>
                        <?php if(auth()->user()->isAdmin() || auth()->user()->isSuperadmin() || auth()->user()->podeGerir('gerir_horarios')): ?>
                            <form action="<?php echo e(route('horarios.destroy-all')); ?>" method="POST" class="d-inline"
                                  onsubmit="return confirm('Tem certeza que deseja eliminar TODOS os horários desta turma? Esta acção não pode ser desfeita.');">
                                <?php echo csrf_field(); ?>
                                <?php echo method_field('DELETE'); ?>
                                <input type="hidden" name="turma_id" value="<?php echo e($turma->id); ?>">
                                <input type="hidden" name="ano_letivo_id" value="<?php echo e($anoLetivo->id); ?>">
                                <button type="submit" class="btn btn-sm" style="padding: 4px 8px; font-size: 0.75rem; background: #f8d7da; color: #721c24; border: none;" title="Eliminar todos os horários">
                                    <i class="bi bi-trash"></i> Eliminar Todos
                                </button>
                            </form>
                        <?php endif; ?>
                    </div>
                    
                    <div class="table-responsive">
                        <table class="horario-table">
                            <thead>
                                <tr>
                                    <th class="horario-time">Horário</th>
                                    <?php $__currentLoopData = $diasSemana; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $dia): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <th class="horario-header"><?php echo e($diasAbreviados[$dia]); ?></th>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__currentLoopData = $horarios; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $horarioInfo): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <?php
                                        $horaInicio = $horarioInfo['inicio'];
                                        $isIntervalo = isset($horarioInfo['tipo']) && $horarioInfo['tipo'] === 'intervalo';
                                    ?>
                                    <tr>
                                        <td class="horario-time" style="<?php echo e($isIntervalo ? 'background-color: #fff3cd; color: #856404;' : ''); ?>">
                                            <?php echo e($horarioInfo['display']); ?>

                                        </td>
                                        <?php if($isIntervalo): ?>
                                            <td colspan="<?php echo e(count($diasSemana)); ?>" class="horario-cell" style="background-color: #fff3cd; text-align: center; font-weight: 600; color: #856404;">
                                                Intervalo para Lanche
                                            </td>
                                        <?php else: ?>
                                            <?php $__currentLoopData = $diasSemana; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $dia): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <?php
                                                    $horario = $grade[$horaInicio][$dia] ?? null;
                                                    $corFundo = $horario && $horario->disciplina ? ($coresDisciplinas[$horario->disciplina->id] ?? '#ffffff') : '#ffffff';
                                                ?>
                                                <td class="horario-cell <?php echo e(!$horario ? 'empty' : ''); ?>" 
                                                    style="background-color: <?php echo e($corFundo); ?>;">
                                                    <?php if($horario): ?>
                                                        <span class="disciplina-badge" style="background-color: rgba(255,255,255,0.85); color: #212529;">
                                                            <?php echo e($horario->disciplina->nome); ?>

                                                        </span>
                                                        <span class="professor-name">
                                                            <?php echo e($horario->professor->user->name); ?>

                                                        </span>
                                                        <?php if(auth()->user()->isAdmin() || auth()->user()->isSuperadmin() || auth()->user()->podeGerir('gerir_horarios')): ?>
                                                            <div style="margin-top: 4px; display: flex; gap: 3px; justify-content: center;">
                                                                <a href="<?php echo e(route('horarios.edit', $horario)); ?>" class="btn btn-sm" style="padding: 1px 4px; font-size: 0.65rem; background: #fff3cd; color: #856404; border: none;" title="Editar">
                                                                    <i class="bi bi-pencil"></i>
                                                                </a>
                                                                <form action="<?php echo e(route('horarios.destroy', $horario)); ?>" method="POST" class="d-inline"
                                                                      onsubmit="return confirm('Tem certeza que deseja eliminar este horário?');">
                                                                    <?php echo csrf_field(); ?>
                                                                    <?php echo method_field('DELETE'); ?>
                                                                    <button type="submit" class="btn btn-sm" style="padding: 1px 4px; font-size: 0.65rem; background: #f8d7da; color: #721c24; border: none;" title="Eliminar">
                                                                        <i class="bi bi-trash"></i>
                                                                    </button>
                                                                </form>
                                                            </div>
                                                        <?php endif; ?>
                                                    <?php else: ?>
                                                        <span style="color: #adb5bd; font-size: 0.9rem;">-</span>
                                                    <?php endif; ?>
                                                </td>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        <?php endif; ?>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            
            <?php if(method_exists($turmasComHorarios, 'links')): ?>
                <div class="mt-3">
                    <?php echo e($turmasComHorarios->appends(request()->query())->links()); ?>

                </div>
            <?php endif; ?>
            </div>
        <?php else: ?>
            <div style="background: #f8f9fa; padding: 20px; border-radius: 4px; text-align: center; font-size: 0.85rem;">
                Nenhum horário registrado
            </div>
        <?php endif; ?>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\Users\Alcidio\Desktop\escola\resources\views/horarios/index.blade.php ENDPATH**/ ?>