<?php $__env->startSection('title', 'Pagamentos de Professores - SIGE'); ?>

<?php $__env->startSection('content'); ?>
<div class="row">
    <div class="col-12">
        <div class="d-flex justify-content-between align-items-center mb-3">
            <h4 class="mb-0">
                <i class="bi bi-cash-coin text-primary me-2"></i>
                Pagamentos de Professores
            </h4>
            <div class="btn-group">
                <form action="<?php echo e(route('admin.professor-payments.gerar-mes-seguinte')); ?>" method="POST" class="d-inline" onsubmit="return confirm('Deseja gerar os pagamentos do mês seguinte baseado nos pagamentos do mês atual?');">
                    <?php echo csrf_field(); ?>
                    <input type="hidden" name="mes" value="<?php echo e(request('mes', date('m'))); ?>">
                    <input type="hidden" name="ano" value="<?php echo e(request('ano', date('Y'))); ?>">
                    <button type="submit" class="btn btn-warning btn-sm" title="Gerar Pagamentos do Mês Seguinte">
                        <i class="bi bi-calendar-plus me-1"></i> Gerar Mês Seguinte
                    </button>
                </form>
                <button type="button" class="btn btn-success btn-sm" data-bs-toggle="modal" data-bs-target="#modalFolhaSalario" title="Download Folha de Salário">
                    <i class="bi bi-download me-1"></i> Download Folha
                </button>
                <button type="button" class="btn btn-info btn-sm" data-bs-toggle="modal" data-bs-target="#modalFolhaSalarioImprimir" title="Visualizar Folha de Salário">
                    <i class="bi bi-printer me-1"></i> Imprimir
                </button>
                <button type="button" class="btn btn-primary btn-sm" id="btn-novo-pagamento">
                    <i class="bi bi-plus-circle me-1"></i> Novo Pagamento
                </button>
                <form action="<?php echo e(route('admin.professor-payments.marcar-todos-pago')); ?>" method="POST" class="d-inline" id="form-marcar-todos-pago" style="display: none;">
                    <?php echo csrf_field(); ?>
                    <input type="hidden" name="mes" value="<?php echo e(request('mes', '')); ?>">
                    <input type="hidden" name="ano" value="<?php echo e(request('ano', '')); ?>">
                    <input type="hidden" name="professor_id" value="<?php echo e(request('professor_id', '')); ?>">
                    <input type="hidden" name="status" value="<?php echo e(request('status', '')); ?>">
                </form>
                <button type="button" class="btn btn-success btn-sm" id="btn-marcar-todos-pago" title="Marcar todos os pagamentos pendentes como pagos">
                    <i class="bi bi-check-all me-1"></i> Marcar Todos como Pago
                </button>
            </div>
        </div>
    </div>
</div>

<!-- Filtros -->
<div class="card mb-3">
    <div class="card-body">
        <form method="GET" action="<?php echo e(route('admin.professor-payments.index')); ?>" class="row g-2" id="filtros-form">
            <div class="col-md-3">
                <label for="professor_id" class="form-label small">Professor</label>
                <select name="professor_id" id="professor_id" class="form-select form-select-sm">
                    <option value="">Todos</option>
                    <?php $__currentLoopData = $professores; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $prof): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($prof->id); ?>" <?php echo e(request('professor_id') == $prof->id ? 'selected' : ''); ?>>
                            <?php echo e($prof->user->name); ?> (<?php echo e($prof->numero_funcionario); ?>)
                        </option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
            </div>
            <div class="col-md-2">
                <label for="mes" class="form-label small">Mês</label>
                <select name="mes" id="mes" class="form-select form-select-sm">
                    <option value="">Todos</option>
                    <?php for($i = 1; $i <= 12; $i++): ?>
                        <option value="<?php echo e($i); ?>" <?php echo e(request('mes') == $i ? 'selected' : ''); ?>>
                            <?php echo e(['', 'Janeiro', 'Fevereiro', 'Março', 'Abril', 'Maio', 'Junho', 'Julho', 'Agosto', 'Setembro', 'Outubro', 'Novembro', 'Dezembro'][$i]); ?>

                        </option>
                    <?php endfor; ?>
                </select>
            </div>
            <div class="col-md-2">
                <label for="ano" class="form-label small">Ano</label>
                <input type="number" name="ano" id="ano" class="form-control form-control-sm" 
                       value="<?php echo e(request('ano', date('Y'))); ?>" min="2020" max="2100">
            </div>
            <div class="col-md-2">
                <label for="status" class="form-label small">Status</label>
                <select name="status" id="status" class="form-select form-select-sm">
                    <option value="">Todos</option>
                    <option value="PENDENTE" <?php echo e(request('status') == 'PENDENTE' ? 'selected' : ''); ?>>Pendente</option>
                    <option value="PAGO" <?php echo e(request('status') == 'PAGO' ? 'selected' : ''); ?>>Pago</option>
                    <option value="CANCELADO" <?php echo e(request('status') == 'CANCELADO' ? 'selected' : ''); ?>>Cancelado</option>
                </select>
            </div>
            <div class="col-md-3 d-flex align-items-end gap-2">
                <button type="button" class="btn btn-primary btn-sm" id="btn-filtrar">
                    <i class="bi bi-search me-1"></i> Filtrar
                </button>
                <a href="<?php echo e(route('admin.professor-payments.index')); ?>" class="btn btn-secondary btn-sm" id="btn-limpar">
                    <i class="bi bi-x-circle me-1"></i> Limpar
                </a>
            </div>
        </form>
    </div>
</div>

<!-- Tabela de Pagamentos -->
<div class="card">
    <div class="card-body">
        <div id="loading-payments" class="text-center py-4" style="display: none;">
            <div class="spinner-border text-primary" role="status">
                <span class="visually-hidden">Carregando...</span>
            </div>
            <p class="mt-2">Carregando pagamentos...</p>
        </div>
        <div id="payments-table-container">
        <?php if($payments->count() > 0): ?>
            <div class="table-responsive">
                <table class="table table-sm table-hover" style="font-size: 0.85rem;" id="payments-table">
                    <thead>
                        <tr>
                            <th style="padding: 6px;">Professor</th>
                            <th style="padding: 6px;">Mês/Ano</th>
                            <th style="padding: 6px;">Horas</th>
                            <th style="padding: 6px;">Valor/Hora</th>
                            <th style="padding: 6px;">Dep.</th>
                            <th style="padding: 6px;">Bruto</th>
                            <th style="padding: 6px;">INSS</th>
                            <th style="padding: 6px;">IRPS</th>
                            <th style="padding: 6px;">Líquido</th>
                            <th style="padding: 6px;">Status</th>
                            <th style="padding: 6px;">Data</th>
                            <th style="padding: 6px;">Ações</th>
                        </tr>
                    </thead>
                    <tbody>
                        <!-- Linha para criar novo pagamento -->
                        <tr class="table-info" id="linha-novo-pagamento" style="display: none;">
                            <td>
                                <select class="form-select form-select-sm novo-pagamento-professor" style="width: 150px; font-size: 0.85rem;">
                                    <option value="">Selecione...</option>
                                    <?php $__currentLoopData = $professores; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $prof): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <?php if($prof->user): ?>
                                            <option value="<?php echo e($prof->id); ?>" 
                                                    data-nivel="<?php echo e($prof->nivel_ensino ?? 'AMBOS'); ?>"
                                                    data-salario-fixo="<?php echo e($prof->salario_fixo ?? 0); ?>"
                                                    data-valor-hora="<?php echo e($prof->valor_hora ?? 0); ?>"
                                                    data-dependentes="<?php echo e($prof->numero_dependentes ?? 0); ?>">
                                                <?php echo e($prof->user->name); ?> (<?php echo e($prof->numero_funcionario); ?>)
                                            </option>
                                    <?php endif; ?>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                                </td>
                                <td>
                                <div style="display: flex; gap: 4px;">
                                    <select class="form-select form-select-sm novo-pagamento-mes" style="width: 100px; font-size: 0.85rem;">
                                        <?php for($i = 1; $i <= 12; $i++): ?>
                                            <option value="<?php echo e($i); ?>" <?php echo e(date('m') == $i ? 'selected' : ''); ?>>
                                                <?php echo e(['', 'Jan', 'Fev', 'Mar', 'Abr', 'Mai', 'Jun', 'Jul', 'Ago', 'Set', 'Out', 'Nov', 'Dez'][$i]); ?>

                                            </option>
                                        <?php endfor; ?>
                                    </select>
                                    <input type="number" class="form-control form-control-sm novo-pagamento-ano" 
                                           value="<?php echo e(date('Y')); ?>" min="2020" max="2100" 
                                           style="width: 80px; font-size: 0.85rem;">
                                </div>
                                </td>
                                <td>
                                <input type="number" 
                                       class="form-control form-control-sm novo-pagamento-horas" 
                                       min="0" 
                                       step="0.5" 
                                       placeholder="0"
                                       style="width: 80px; font-size: 0.85rem; padding: 2px 6px;">
                                </td>
                                <td>
                                <input type="number" 
                                       class="form-control form-control-sm novo-pagamento-valor-hora" 
                                       min="0" 
                                       step="0.01" 
                                       placeholder="0.00"
                                       style="width: 100px; font-size: 0.85rem; padding: 2px 6px;">
                                </td>
                                <td>
                                <span class="badge bg-secondary novo-pagamento-dependentes">0</span>
                                </td>
                                <td>
                                <input type="number" 
                                       class="form-control form-control-sm novo-pagamento-valor-bruto" 
                                       min="0" 
                                       step="0.01" 
                                       placeholder="0.00"
                                       style="width: 120px; font-size: 0.85rem; padding: 2px 6px; font-weight: 600;">
                                </td>
                                <td>
                                <span class="text-info novo-pagamento-inss">0,00 MT</span>
                                </td>
                                <td>
                                <span class="text-warning novo-pagamento-irps">0,00 MT</span>
                                </td>
                                <td>
                                <strong class="text-success novo-pagamento-liquido">0,00 MT</strong>
                            </td>
                            <td>
                                <span class="badge bg-warning">Novo</span>
                            </td>
                            <td>
                                <span class="text-muted">-</span>
                            </td>
                            <td>
                                <div class="btn-group btn-group-sm">
                                    <button type="button" class="btn btn-success btn-sm salvar-novo-pagamento" title="Salvar">
                                        <i class="bi bi-check-circle"></i>
                                    </button>
                                    <button type="button" class="btn btn-secondary btn-sm cancelar-novo-pagamento" title="Cancelar">
                                        <i class="bi bi-x-circle"></i>
                                    </button>
                                </div>
                            </td>
                        </tr>
                        <?php $__currentLoopData = $payments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $payment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr data-professor-id="<?php echo e($payment->professor_id); ?>"
                                data-salario-fixo="<?php echo e($payment->professor ? ($payment->professor->salario_fixo ?? 0) : 0); ?>"
                                data-nivel="<?php echo e($payment->professor ? ($payment->professor->nivel_ensino ?? 'AMBOS') : 'AMBOS'); ?>"
                                style="font-size: 0.85rem;">
                                <td style="padding: 5px;">
                                    <?php if($payment->professor && $payment->professor->user): ?>
                                        <div style="font-size: 0.85rem;"><?php echo e($payment->professor->user->name); ?></div>
                                        <small class="text-muted" style="font-size: 0.75rem;"><?php echo e($payment->professor->numero_funcionario); ?></small>
                                    <?php else: ?>
                                        <div class="text-danger" style="font-size: 0.85rem;">Professor eliminado</div>
                                        <small class="text-muted" style="font-size: 0.75rem;">ID: <?php echo e($payment->professor_id); ?></small>
                                    <?php endif; ?>
                                </td>
                                <td style="padding: 5px;">
                                    <?php
                                        $mesesAbrev = ['', 'Jan', 'Fev', 'Mar', 'Abr', 'Mai', 'Jun', 'Jul', 'Ago', 'Set', 'Out', 'Nov', 'Dez'];
                                        $anoAbrev = substr($payment->ano, -2);
                                    ?>
                                    <?php echo e($mesesAbrev[$payment->mes]); ?>/<?php echo e($anoAbrev); ?>

                                </td>
                                <td style="padding: 5px;">
                                    <?php if($payment->status !== 'PAGO'): ?>
                                        <?php
                                            $temSalarioFixo = $payment->professor && ($payment->professor->salario_fixo ?? 0) > 0;
                                        ?>
                                        <input type="number" 
                                               class="form-control form-control-sm editar-horas" 
                                               data-payment-id="<?php echo e($payment->id); ?>"
                                               value="<?php echo e($payment->horas_trabalhadas ?? ''); ?>"
                                               min="0" 
                                               step="0.5" 
                                               style="width: 70px; font-size: 0.8rem; padding: 2px 4px;<?php echo e($temSalarioFixo ? ' background-color: #e9ecef;' : ''); ?>"
                                               placeholder="0"
                                               <?php echo e($temSalarioFixo ? 'disabled' : ''); ?>>
                                    <?php else: ?>
                                        <?php if($payment->horas_trabalhadas): ?>
                                            <span style="font-size: 0.85rem;"><?php echo e(number_format($payment->horas_trabalhadas, 1)); ?>h</span>
                                        <?php else: ?>
                                            <span class="text-muted" style="font-size: 0.85rem;">-</span>
                                        <?php endif; ?>
                                    <?php endif; ?>
                                </td>
                                <td style="padding: 5px;">
                                    <?php if($payment->professor && $payment->status !== 'PAGO'): ?>
                                        <?php
                                            $valorHora = $payment->professor->valor_hora ?? 0;
                                            $nivel = $payment->professor->nivel_ensino ?? 'AMBOS';
                                            $temSalarioFixo = ($payment->professor->salario_fixo ?? 0) > 0;
                                        ?>
                                        <?php if($nivel === 'SECUNDARIO' || $nivel === 'AMBOS'): ?>
                                            <input type="number" 
                                                   class="form-control form-control-sm editar-valor-hora" 
                                                   data-payment-id="<?php echo e($payment->id); ?>"
                                                   data-professor-id="<?php echo e($payment->professor->id); ?>"
                                                   value="<?php echo e(number_format($valorHora, 2, '.', '')); ?>"
                                                   min="0" 
                                                   step="0.01" 
                                                   style="width: 90px; font-size: 0.8rem; padding: 2px 4px;<?php echo e($temSalarioFixo ? ' background-color: #e9ecef;' : ''); ?>"
                                                   placeholder="0.00"
                                                   <?php echo e($temSalarioFixo ? 'disabled' : ''); ?>>
                                        <?php else: ?>
                                            <span class="text-muted" style="font-size: 0.85rem;">-</span>
                                        <?php endif; ?>
                                    <?php else: ?>
                                        <?php if($payment->professor && ($payment->professor->valor_hora ?? 0) > 0): ?>
                                            <span style="font-size: 0.85rem;"><?php echo e(number_format($payment->professor->valor_hora, 2, ',', '.')); ?></span>
                                        <?php else: ?>
                                            <span class="text-muted" style="font-size: 0.85rem;">-</span>
                                        <?php endif; ?>
                                    <?php endif; ?>
                                </td>
                                <td style="padding: 5px; text-align: center;">
                                    <?php if($payment->professor): ?>
                                        <span class="badge bg-secondary" style="font-size: 0.75rem;"><?php echo e($payment->professor->numero_dependentes ?? 0); ?></span>
                                    <?php else: ?>
                                        <span class="text-muted" style="font-size: 0.85rem;">-</span>
                                    <?php endif; ?>
                                </td>
                                <td style="padding: 5px;">
                                    <?php if($payment->status !== 'PAGO'): ?>
                                        <input type="number" 
                                               class="form-control form-control-sm editar-valor-bruto" 
                                               data-payment-id="<?php echo e($payment->id); ?>"
                                               value="<?php echo e(number_format($payment->valor_total, 2, '.', '')); ?>"
                                               min="0" 
                                               step="0.01" 
                                               style="width: 100px; font-size: 0.8rem; padding: 2px 4px; font-weight: 600;"
                                               placeholder="0.00">
                                    <?php else: ?>
                                        <strong style="font-size: 0.85rem;"><?php echo e(number_format($payment->valor_total, 2, ',', '.')); ?></strong>
                                    <?php endif; ?>
                                </td>
                                <td style="padding: 5px;">
                                    <span class="text-info valor-inss" data-payment-id="<?php echo e($payment->id); ?>" style="font-size: 0.85rem;">
                                        <?php echo e(number_format($payment->inss ?? 0, 2, ',', '.')); ?>

                                    </span>
                                </td>
                                <td style="padding: 5px;">
                                    <span class="text-warning valor-irps" data-payment-id="<?php echo e($payment->id); ?>" style="font-size: 0.85rem;">
                                        <?php echo e(number_format($payment->irps ?? 0, 2, ',', '.')); ?>

                                    </span>
                                </td>
                                <td style="padding: 5px;">
                                    <strong class="text-success valor-liquido" data-payment-id="<?php echo e($payment->id); ?>" style="font-size: 0.85rem;">
                                        <?php echo e(number_format($payment->valor_liquido ?? $payment->valor_total, 2, ',', '.')); ?>

                                    </strong>
                                </td>
                                <td style="padding: 5px;">
                                    <?php if($payment->status === 'PAGO'): ?>
                                        <span class="badge bg-success" style="font-size: 0.75rem;">Pago</span>
                                    <?php elseif($payment->status === 'CANCELADO'): ?>
                                        <span class="badge bg-danger" style="font-size: 0.75rem;">Cancelado</span>
                                    <?php else: ?>
                                        <span class="badge bg-warning" style="font-size: 0.75rem;">Pendente</span>
                                    <?php endif; ?>
                                </td>
                                <td style="padding: 5px; font-size: 0.85rem;">
                                    <?php if($payment->data_pagamento): ?>
                                        <?php echo e(\Carbon\Carbon::parse($payment->data_pagamento)->format('d/m/y')); ?>

                                    <?php else: ?>
                                        <span class="text-muted">-</span>
                                    <?php endif; ?>
                                </td>
                                <td style="padding: 5px;">
                                    <div class="btn-group btn-group-sm">
                                        <?php if($payment->status === 'PAGO'): ?>
                                            <a href="<?php echo e(route('admin.professor-payments.folha-salario', ['professor_id' => $payment->professor_id, 'mes' => $payment->mes, 'ano' => $payment->ano])); ?>" 
                                               class="btn btn-success btn-sm" 
                                               title="Download"
                                               style="padding: 2px 5px; font-size: 0.7rem;">
                                                <i class="bi bi-download"></i>
                                            </a>
                                            <a href="<?php echo e(route('admin.professor-payments.folha-salario.visualizar', ['professor_id' => $payment->professor_id, 'mes' => $payment->mes, 'ano' => $payment->ano])); ?>" 
                                               class="btn btn-info btn-sm" 
                                               target="_blank"
                                               title="Imprimir"
                                               style="padding: 2px 5px; font-size: 0.7rem;">
                                                <i class="bi bi-printer"></i>
                                            </a>
                                        <?php endif; ?>
                                        <?php if($payment->status === 'PENDENTE'): ?>
                                            <form action="<?php echo e(route('admin.professor-payments.marcar-pago', $payment)); ?>" method="POST" class="d-inline">
                                                <?php echo csrf_field(); ?>
                                                <button type="submit" class="btn btn-success btn-sm" title="Marcar como pago" style="padding: 2px 5px; font-size: 0.7rem;">
                                                    <i class="bi bi-check-circle"></i>
                                                </button>
                                            </form>
                                        <?php endif; ?>
                                    </div>
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                    <tfoot>
                        <tr style="background-color: #f8f9fa; font-size: 0.85rem;">
                            <th colspan="5" class="text-end" style="padding: 6px;"><strong>Totais:</strong></th>
                            <th style="padding: 6px;"><strong><?php echo e(number_format($payments->sum('valor_total'), 2, ',', '.')); ?></strong></th>
                            <th style="padding: 6px;"><strong><?php echo e(number_format($payments->sum('inss'), 2, ',', '.')); ?></strong></th>
                            <th style="padding: 6px;"><strong><?php echo e(number_format($payments->sum('irps'), 2, ',', '.')); ?></strong></th>
                            <th style="padding: 6px;"><strong class="text-success"><?php echo e(number_format($payments->sum(function($p) { return $p->valor_liquido ?? ($p->valor_total - ($p->inss ?? 0) - ($p->irps ?? 0)); }), 2, ',', '.')); ?></strong></th>
                            <th colspan="3" style="padding: 6px;"></th>
                        </tr>
                    </tfoot>
                </table>
            </div>
        <?php else: ?>
            <div class="alert alert-info text-center">
                <i class="bi bi-info-circle me-2"></i>
                Nenhum pagamento encontrado.
            </div>
        <?php endif; ?>
        </div>

        
        <div class="mt-3" id="pagination-container">
            <?php if($payments->hasPages()): ?>
                <?php echo e($payments->appends(request()->query())->links()); ?>

            <?php endif; ?>
        </div>
    </div>
</div>

<?php $__env->startPush('scripts'); ?>
<script>
document.addEventListener('DOMContentLoaded', function() {
    // Prevenir submit padrão do formulário de filtros (IMPORTANTE - fazer primeiro!)
    const formFiltrosSubmit = document.getElementById('filtros-form');
    if (formFiltrosSubmit) {
        formFiltrosSubmit.addEventListener('submit', function(e) {
            e.preventDefault();
            e.stopPropagation();
            e.stopImmediatePropagation();
            carregarPagamentos(1);
            return false;
        }, true); // Usar capture phase para interceptar antes
    }
    
    // Função para carregar pagamentos via AJAX
    function carregarPagamentos(page = null) {
        const loading = document.getElementById('loading-payments');
        const container = document.getElementById('payments-table-container');
        const paginationContainer = document.getElementById('pagination-container');
        
        if (!container) {
            console.error('Container de pagamentos não encontrado');
            return;
        }
        
        // Se page não foi fornecido, obter da URL ou usar 1
        if (page === null) {
            const urlParams = new URLSearchParams(window.location.search);
            page = parseInt(urlParams.get('page')) || 1;
        }
        
        // Coletar valores dos filtros manualmente para garantir que funcionem
        const params = new URLSearchParams();
        
        // Coletar professor_id
        const professorId = document.getElementById('professor_id');
        if (professorId && professorId.value && professorId.value !== '') {
            params.append('professor_id', professorId.value);
        }
        
        // Coletar mês
        const mes = document.getElementById('mes');
        if (mes && mes.value && mes.value !== '') {
            params.append('mes', mes.value);
        }
        
        // Coletar ano (sempre incluir se tiver valor, mesmo que seja o padrão)
        const ano = document.getElementById('ano');
        if (ano && ano.value && ano.value !== '') {
            params.append('ano', ano.value);
        }
        
        // Coletar status
        const status = document.getElementById('status');
        if (status && status.value && status.value !== '') {
            params.append('status', status.value);
        }
        
        // Adicionar página
        if (page && page > 1) {
            params.append('page', page);
        }
        
        // Mostrar loading e esconder container
        if (loading) {
            loading.style.display = 'block';
        }
        if (container) {
            container.style.display = 'none';
            container.style.opacity = '0.5';
        }
        if (paginationContainer) {
            paginationContainer.style.display = 'none';
        }
        
        const url = '<?php echo e(route("admin.professor-payments.index")); ?>?' + params.toString();
        
        fetch(url, {
            headers: {
                'X-Requested-With': 'XMLHttpRequest',
                'Accept': 'application/json'
            }
        })
        .then(response => {
            if (!response.ok) {
                throw new Error('Erro na resposta do servidor: ' + response.status);
            }
            const contentType = response.headers.get('content-type');
            if (!contentType || !contentType.includes('application/json')) {
                throw new Error('Resposta não é JSON');
            }
            return response.json();
        })
        .then(data => {
            if (data.success) {
                // Esconder loading
                if (loading) {
                    loading.style.display = 'none';
                }
                
                // Renderizar tabela
                renderizarTabela(data.payments, data.professores);
                
                // Atualizar paginação
                if (data.pagination) {
                    atualizarPaginacao(data.pagination, params);
                }
                
                // Mostrar container após carregar dados
                if (container) {
                    container.style.display = 'block';
                    container.style.opacity = '1';
                }
                if (paginationContainer) {
                    paginationContainer.style.display = 'block';
                }
            } else {
                throw new Error(data.message || 'Erro ao carregar dados');
            }
        })
        .catch(error => {
            console.error('Erro ao carregar pagamentos:', error);
            // Se for erro de JSON ou não for AJAX, mostrar tabela inicial ou recarregar página
            if (error.message.includes('JSON') || error.message.includes('Unexpected') || error.message.includes('Resposta não é')) {
                // Tentar mostrar tabela inicial se existir
                const tabelaInicial = container ? container.querySelector('table') : null;
                if (tabelaInicial) {
                    container.style.display = 'block';
                    if (loading) loading.style.display = 'none';
                } else {
                    // Se não houver tabela inicial, recarregar página
                    window.location.href = '<?php echo e(route("admin.professor-payments.index")); ?>?' + params.toString();
                }
            } else {
                console.error('Erro detalhado:', error);
                // Mostrar tabela inicial se existir
                const tabelaInicial = container ? container.querySelector('table') : null;
                if (tabelaInicial) {
                    container.style.display = 'block';
                } else {
                    alert('Erro ao carregar pagamentos: ' + error.message);
                }
                if (loading) loading.style.display = 'none';
                if (container) container.style.opacity = '1';
            }
        })
        .finally(() => {
            // O loading já é escondido no .then() quando há sucesso
            // Aqui só escondemos se houver erro
            if (loading && loading.style.display !== 'none') {
                loading.style.display = 'none';
            }
        });
    }
    
    // Função para renderizar a tabela
    function renderizarTabela(payments, professores) {
        const container = document.getElementById('payments-table-container');
        if (!container) return;
        
        if (payments.length === 0) {
            container.innerHTML = '<div class="alert alert-info text-center"><i class="bi bi-info-circle me-2"></i>Nenhum pagamento encontrado.</div>';
            container.style.display = 'block';
            return;
        }
        
        const mesesAbrev = ['', 'Jan', 'Fev', 'Mar', 'Abr', 'Mai', 'Jun', 'Jul', 'Ago', 'Set', 'Out', 'Nov', 'Dez'];
        
        let html = '<div class="table-responsive"><table class="table table-sm table-hover" style="font-size: 0.85rem;" id="payments-table">';
        html += '<thead><tr>';
        html += '<th style="padding: 6px;">Professor</th>';
        html += '<th style="padding: 6px;">Mês/Ano</th>';
        html += '<th style="padding: 6px;">Horas</th>';
        html += '<th style="padding: 6px;">Valor/Hora</th>';
        html += '<th style="padding: 6px;">Dep.</th>';
        html += '<th style="padding: 6px;">Bruto</th>';
        html += '<th style="padding: 6px;">INSS</th>';
        html += '<th style="padding: 6px;">IRPS</th>';
        html += '<th style="padding: 6px;">Líquido</th>';
        html += '<th style="padding: 6px;">Status</th>';
        html += '<th style="padding: 6px;">Data</th>';
        html += '<th style="padding: 6px;">Ações</th>';
        html += '</tr></thead><tbody>';
        
        payments.forEach(function(payment) {
            const temSalarioFixo = payment.salario_fixo > 0 && payment.nivel_ensino === 'PRIMARIO';
            const podeEditar = payment.status !== 'PAGO';
            
            html += `<tr data-professor-id="${payment.professor_id}" data-salario-fixo="${payment.salario_fixo}" data-nivel="${payment.nivel_ensino}" style="font-size: 0.85rem;">`;
            
            // Professor
            html += `<td style="padding: 5px;"><div style="font-size: 0.85rem;">${payment.professor_nome}</div><small class="text-muted" style="font-size: 0.75rem;">${payment.professor_codigo}</small></td>`;
            
            // Mês/Ano
            html += `<td style="padding: 5px;">${payment.mes_abrev}/${payment.ano_abrev}</td>`;
            
            // Horas
            html += '<td style="padding: 5px;">';
            if (podeEditar) {
                html += `<input type="number" class="form-control form-control-sm editar-horas" data-payment-id="${payment.id}" value="${payment.horas_trabalhadas || ''}" min="0" step="0.5" style="width: 70px; font-size: 0.8rem; padding: 2px 4px;${temSalarioFixo ? ' background-color: #e9ecef;' : ''}" placeholder="0" ${temSalarioFixo ? 'disabled' : ''}>`;
            } else {
                html += payment.horas_trabalhadas ? `<span style="font-size: 0.85rem;">${parseFloat(payment.horas_trabalhadas).toFixed(1)}h</span>` : '<span class="text-muted" style="font-size: 0.85rem;">-</span>';
            }
            html += '</td>';
            
            // Valor/Hora
            html += '<td style="padding: 5px;">';
            if (podeEditar && (payment.nivel_ensino === 'SECUNDARIO' || payment.nivel_ensino === 'AMBOS')) {
                html += `<input type="number" class="form-control form-control-sm editar-valor-hora" data-payment-id="${payment.id}" data-professor-id="${payment.professor_id}" value="${parseFloat(payment.valor_hora).toFixed(2)}" min="0" step="0.01" style="width: 90px; font-size: 0.8rem; padding: 2px 4px;${temSalarioFixo ? ' background-color: #e9ecef;' : ''}" placeholder="0.00" ${temSalarioFixo ? 'disabled' : ''}>`;
            } else {
                html += payment.valor_hora > 0 ? `<span style="font-size: 0.85rem;">${parseFloat(payment.valor_hora).toFixed(2).replace('.', ',')}</span>` : '<span class="text-muted" style="font-size: 0.85rem;">-</span>';
            }
            html += '</td>';
            
            // Dependentes
            html += `<td style="padding: 5px; text-align: center;"><span class="badge bg-secondary" style="font-size: 0.75rem;">${payment.numero_dependentes}</span></td>`;
            
            // Valor Bruto
            html += '<td style="padding: 5px;">';
            if (podeEditar) {
                html += `<input type="number" class="form-control form-control-sm editar-valor-bruto" data-payment-id="${payment.id}" value="${parseFloat(payment.valor_total).toFixed(2)}" min="0" step="0.01" style="width: 100px; font-size: 0.8rem; padding: 2px 4px; font-weight: 600;" placeholder="0.00">`;
            } else {
                html += `<strong style="font-size: 0.85rem;">${parseFloat(payment.valor_total).toFixed(2).replace('.', ',')}</strong>`;
            }
            html += '</td>';
            
            // INSS
            html += `<td style="padding: 5px;"><span class="text-info valor-inss" data-payment-id="${payment.id}" style="font-size: 0.85rem;">${parseFloat(payment.inss).toFixed(2).replace('.', ',')}</span></td>`;
            
            // IRPS
            html += `<td style="padding: 5px;"><span class="text-warning valor-irps" data-payment-id="${payment.id}" style="font-size: 0.85rem;">${parseFloat(payment.irps).toFixed(2).replace('.', ',')}</span></td>`;
            
            // Valor Líquido
            html += `<td style="padding: 5px;"><strong class="text-success valor-liquido" data-payment-id="${payment.id}" style="font-size: 0.85rem;">${parseFloat(payment.valor_liquido).toFixed(2).replace('.', ',')}</strong></td>`;
            
            // Status
            const statusClass = payment.status === 'PAGO' ? 'bg-success' : (payment.status === 'CANCELADO' ? 'bg-danger' : 'bg-warning');
            const statusText = payment.status === 'PAGO' ? 'Pago' : (payment.status === 'CANCELADO' ? 'Cancelado' : 'Pendente');
            html += `<td style="padding: 5px;"><span class="badge ${statusClass}" style="font-size: 0.75rem;">${statusText}</span></td>`;
            
            // Data
            html += `<td style="padding: 5px; font-size: 0.85rem;">${payment.data_pagamento || '<span class="text-muted">-</span>'}</td>`;
            
            // Ações
            html += '<td style="padding: 5px;"><div class="btn-group btn-group-sm">';
            if (payment.status === 'PAGO') {
                const urlFolha = '<?php echo e(route("admin.professor-payments.folha-salario", ["professor_id" => ":prof_id", "mes" => ":mes", "ano" => ":ano"])); ?>'.replace(':prof_id', payment.professor_id).replace(':mes', payment.mes).replace(':ano', payment.ano);
                const urlVisualizar = '<?php echo e(route("admin.professor-payments.folha-salario.visualizar", ["professor_id" => ":prof_id", "mes" => ":mes", "ano" => ":ano"])); ?>'.replace(':prof_id', payment.professor_id).replace(':mes', payment.mes).replace(':ano', payment.ano);
                html += `<a href="${urlFolha}" class="btn btn-success btn-sm" title="Download" style="padding: 2px 5px; font-size: 0.7rem;"><i class="bi bi-download"></i></a>`;
                html += `<a href="${urlVisualizar}" class="btn btn-info btn-sm" target="_blank" title="Imprimir" style="padding: 2px 5px; font-size: 0.7rem;"><i class="bi bi-printer"></i></a>`;
            } else if (payment.status === 'PENDENTE') {
                const urlMarcarPago = '<?php echo e(route("admin.professor-payments.marcar-pago", ":id")); ?>'.replace(':id', payment.id);
                html += `<form action="${urlMarcarPago}" method="POST" class="d-inline marcar-pago-form"><input type="hidden" name="_token" value="<?php echo e(csrf_token()); ?>"><button type="submit" class="btn btn-success btn-sm" title="Marcar como pago" style="padding: 2px 5px; font-size: 0.7rem;"><i class="bi bi-check-circle"></i></button></form>`;
            }
            html += '</div></td>';
            
            html += '</tr>';
        });
        
        html += '</tbody><tfoot><tr style="background-color: #f8f9fa; font-size: 0.85rem;">';
        const totalBruto = payments.reduce((sum, p) => sum + parseFloat(p.valor_total), 0);
        const totalInss = payments.reduce((sum, p) => sum + parseFloat(p.inss), 0);
        const totalIrps = payments.reduce((sum, p) => sum + parseFloat(p.irps), 0);
        const totalLiquido = payments.reduce((sum, p) => sum + parseFloat(p.valor_liquido), 0);
        html += `<th colspan="5" class="text-end" style="padding: 6px;"><strong>Totais:</strong></th>`;
        html += `<th style="padding: 6px;"><strong>${totalBruto.toFixed(2).replace('.', ',')}</strong></th>`;
        html += `<th style="padding: 6px;"><strong>${totalInss.toFixed(2).replace('.', ',')}</strong></th>`;
        html += `<th style="padding: 6px;"><strong>${totalIrps.toFixed(2).replace('.', ',')}</strong></th>`;
        html += `<th style="padding: 6px;"><strong class="text-success">${totalLiquido.toFixed(2).replace('.', ',')}</strong></th>`;
        html += '<th colspan="3" style="padding: 6px;"></th></tr></tfoot></table></div>';
        
        container.innerHTML = html;
        container.style.display = 'block';
    }
    
    // Função para atualizar paginação
    function atualizarPaginacao(pagination, params) {
        const paginationContainer = document.getElementById('pagination-container');
        if (!paginationContainer || !pagination) return;
        
        if (pagination.last_page <= 1) {
            paginationContainer.innerHTML = '';
            return;
        }
        
        let html = '<nav><ul class="pagination pagination-sm justify-content-center mb-0">';
        
        // Botão Anterior
        if (pagination.current_page > 1) {
            html += `<li class="page-item"><a class="page-link pagination-link" href="#" data-page="${pagination.current_page - 1}">Anterior</a></li>`;
        } else {
            html += '<li class="page-item disabled"><span class="page-link">Anterior</span></li>';
        }
        
        // Números de página
        const startPage = Math.max(1, pagination.current_page - 2);
        const endPage = Math.min(pagination.last_page, pagination.current_page + 2);
        
        if (startPage > 1) {
            html += `<li class="page-item"><a class="page-link pagination-link" href="#" data-page="1">1</a></li>`;
            if (startPage > 2) {
                html += '<li class="page-item disabled"><span class="page-link">...</span></li>';
            }
        }
        
        for (let i = startPage; i <= endPage; i++) {
            if (i === pagination.current_page) {
                html += `<li class="page-item active"><span class="page-link">${i}</span></li>`;
            } else {
                html += `<li class="page-item"><a class="page-link pagination-link" href="#" data-page="${i}">${i}</a></li>`;
            }
        }
        
        if (endPage < pagination.last_page) {
            if (endPage < pagination.last_page - 1) {
                html += '<li class="page-item disabled"><span class="page-link">...</span></li>';
            }
            html += `<li class="page-item"><a class="page-link pagination-link" href="#" data-page="${pagination.last_page}">${pagination.last_page}</a></li>`;
        }
        
        // Botão Próximo
        if (pagination.current_page < pagination.last_page) {
            html += `<li class="page-item"><a class="page-link pagination-link" href="#" data-page="${pagination.current_page + 1}">Próximo</a></li>`;
        } else {
            html += '<li class="page-item disabled"><span class="page-link">Próximo</span></li>';
        }
        
        html += '</ul></nav>';
        html += `<div class="text-center mt-2" style="font-size: 0.85rem; color: #666;">Mostrando ${((pagination.current_page - 1) * pagination.per_page) + 1} a ${Math.min(pagination.current_page * pagination.per_page, pagination.total)} de ${pagination.total} registros</div>`;
        
        paginationContainer.innerHTML = html;
        
        // Os event listeners já estão configurados via event delegation no document
        // Não precisa adicionar listeners individuais aqui
    }
    
    // Variável para timeouts de atualização (declarada no escopo global da função DOMContentLoaded)
    let updateTimeouts = {};
    
    // Função auxiliar para obter página atual
    function obterPaginaAtual() {
        const paginationContainer = document.getElementById('pagination-container');
        if (paginationContainer) {
            // Tentar obter da paginação customizada
            const activePage = paginationContainer.querySelector('.page-item.active .page-link');
            if (activePage) {
                const pageText = activePage.textContent.trim();
                const page = parseInt(pageText);
                if (page && !isNaN(page)) {
                    return page;
                }
            }
            // Tentar obter dos links do Laravel
            const laravelActive = paginationContainer.querySelector('.pagination .active');
            if (laravelActive) {
                const pageText = laravelActive.textContent.trim();
                const page = parseInt(pageText);
                if (page && !isNaN(page)) {
                    return page;
                }
            }
        }
        // Tentar obter da URL
        const urlParams = new URLSearchParams(window.location.search);
        const page = parseInt(urlParams.get('page')) || 1;
        return page;
    }
    
    // Configurar event delegation (apenas uma vez, funciona para elementos dinâmicos)
    function configurarEventDelegation() {
        const container = document.getElementById('payments-table-container');
        if (!container) return;
        
        // Event delegation para editar valor bruto
        container.addEventListener('input', function(e) {
            if (e.target.classList.contains('editar-valor-bruto')) {
                const paymentId = e.target.getAttribute('data-payment-id');
                const valorBruto = parseFloat(e.target.value) || 0;
                
                // Calcular INSS e IRPS localmente (aproximado)
                const inss = valorBruto * 0.03;
                const irpsAprox = 0;
                const valorLiquidoAprox = valorBruto - inss - irpsAprox;
                
                // Atualizar visualmente
                const inssElement = document.querySelector('.valor-inss[data-payment-id="' + paymentId + '"]');
                const liquidoElement = document.querySelector('.valor-liquido[data-payment-id="' + paymentId + '"]');
                
                if (inssElement) {
                    inssElement.textContent = inss.toFixed(2).replace('.', ',').replace(/\B(?=(\d{3})+(?!\d))/g, '.');
                }
                if (liquidoElement) {
                    liquidoElement.textContent = valorLiquidoAprox.toFixed(2).replace('.', ',').replace(/\B(?=(\d{3})+(?!\d))/g, '.');
                }
                
                // Limpar timeout anterior
                if (updateTimeouts[paymentId]) {
                    clearTimeout(updateTimeouts[paymentId]);
                }
                
                // Salvar após 1.5 segundos sem digitar
                updateTimeouts[paymentId] = setTimeout(function() {
                    atualizarPagamento(paymentId);
                }, 1500);
            }
        });
        
        // Event delegation para editar horas
        container.addEventListener('input', function(e) {
            if (e.target.classList.contains('editar-horas')) {
                const paymentId = e.target.getAttribute('data-payment-id');
                const horas = parseFloat(e.target.value) || 0;
                
                // Recalcular valor bruto se houver valor/hora
                const valorHoraInput = document.querySelector('.editar-valor-hora[data-payment-id="' + paymentId + '"]');
                const valorBrutoInput = document.querySelector('.editar-valor-bruto[data-payment-id="' + paymentId + '"]');
                
                if (valorBrutoInput) {
                    let novoValorBruto = 0;
                    const row = e.target.closest('tr');
                    const nivel = row ? row.getAttribute('data-nivel') : 'AMBOS';
                    const salarioFixo = row ? parseFloat(row.getAttribute('data-salario-fixo')) || 0 : 0;
                    
                    if (valorHoraInput && !valorHoraInput.disabled) {
                        const valorHora = parseFloat(valorHoraInput.value) || 0;
                        if (horas > 0 && valorHora > 0) {
                            novoValorBruto = horas * valorHora;
                            if (nivel === 'AMBOS' && salarioFixo > 0) {
                                novoValorBruto += salarioFixo;
                            }
                        }
                    }
                    
                    if (novoValorBruto > 0) {
                        valorBrutoInput.value = novoValorBruto.toFixed(2);
                        valorBrutoInput.dispatchEvent(new Event('input'));
                    }
                }
                
                // Limpar timeout anterior
                if (updateTimeouts[paymentId]) {
                    clearTimeout(updateTimeouts[paymentId]);
                }
                
                // Salvar após 1.5 segundos sem digitar
                updateTimeouts[paymentId] = setTimeout(function() {
                    atualizarPagamento(paymentId);
                }, 1500);
            }
        });
        
        // Event delegation para editar valor/hora
        container.addEventListener('input', function(e) {
            if (e.target.classList.contains('editar-valor-hora')) {
                const paymentId = e.target.getAttribute('data-payment-id');
                const professorId = e.target.getAttribute('data-professor-id');
                const valorHora = parseFloat(e.target.value) || 0;
                
                // Recalcular valor bruto imediatamente se houver horas
                const horasInput = document.querySelector('.editar-horas[data-payment-id="' + paymentId + '"]');
                const valorBrutoInput = document.querySelector('.editar-valor-bruto[data-payment-id="' + paymentId + '"]');
                
                if (horasInput && valorBrutoInput && !horasInput.disabled) {
                    const horas = parseFloat(horasInput.value) || 0;
                    if (horas > 0 && valorHora > 0) {
                        valorBrutoInput.value = (horas * valorHora).toFixed(2);
                        valorBrutoInput.dispatchEvent(new Event('input'));
                    }
                }
                
                // Salvar valor/hora no professor
                if (professorId && valorHora > 0) {
        fetch('<?php echo e(route("admin.professores.update-valor-hora", ":id")); ?>'.replace(':id', professorId), {
            method: 'PATCH',
            headers: {
                'Content-Type': 'application/json',
                'X-CSRF-TOKEN': '<?php echo e(csrf_token()); ?>',
                'Accept': 'application/json'
            },
            body: JSON.stringify({
                            valor_hora: valorHora
                        })
                    })
                    .catch(error => {
                        console.error('Erro ao salvar valor/hora:', error);
                    });
                }
            }
        });
        
        // Event delegation para marcar como pago
        container.addEventListener('submit', function(e) {
            if (e.target.classList.contains('marcar-pago-form')) {
                e.preventDefault();
                const form = e.target;
                const paymentId = form.action.split('/').pop();
                
                fetch(form.action, {
                    method: 'POST',
                    headers: {
                        'Content-Type': 'application/json',
                        'X-CSRF-TOKEN': '<?php echo e(csrf_token()); ?>',
                        'Accept': 'application/json',
                        'X-Requested-With': 'XMLHttpRequest'
                    },
                    body: JSON.stringify({})
        })
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                        carregarPagamentos(obterPaginaAtual());
                    } else {
                        alert('Erro: ' + (data.message || 'Não foi possível marcar como pago.'));
                    }
                })
                .catch(error => {
                    console.error('Erro:', error);
                    alert('Erro ao marcar como pago. Tente novamente.');
                });
            }
        });
    }
    
    // Event listeners para filtros
    const btnFiltrar = document.getElementById('btn-filtrar');
    const btnLimpar = document.getElementById('btn-limpar');
    
    if (btnFiltrar) {
        btnFiltrar.addEventListener('click', function(e) {
            e.preventDefault();
            e.stopPropagation();
            e.stopImmediatePropagation();
            carregarPagamentos(1); // Sempre voltar para página 1 ao filtrar
            return false;
        }, true); // Usar capture phase para interceptar antes
    }
    
    if (btnLimpar) {
        btnLimpar.addEventListener('click', function(e) {
            e.preventDefault();
            e.stopPropagation();
            e.stopImmediatePropagation();
            // Limpar campos do formulário
            const professorId = document.getElementById('professor_id');
            const mes = document.getElementById('mes');
            const ano = document.getElementById('ano');
            const status = document.getElementById('status');
            
            if (professorId) professorId.value = '';
            if (mes) mes.value = '';
            if (ano) ano.value = '';
            if (status) status.value = '';
            
            // Recarregar sem filtros
            carregarPagamentos(1);
            return false;
        }, true); // Usar capture phase
    }
    
    // Carregar pagamentos quando os filtros mudarem
    ['professor_id', 'mes', 'ano', 'status'].forEach(function(id) {
        const element = document.getElementById(id);
        if (element) {
            element.addEventListener('change', function() {
                // Sempre voltar para página 1 ao filtrar
                carregarPagamentos(1);
            });
        }
    });
    
    // Botão marcar todos como pago (via AJAX)
    const btnMarcarTodos = document.getElementById('btn-marcar-todos-pago');
    
    if (btnMarcarTodos) {
        btnMarcarTodos.addEventListener('click', function() {
            const formFiltros = document.getElementById('filtros-form');
            const formData = new FormData(formFiltros);
            const params = new URLSearchParams();
            for (const [key, value] of formData.entries()) {
                if (value) params.append(key, value);
            }
            
            if (!confirm('Deseja marcar todos os pagamentos pendentes como pagos?\n\nEsta ação não pode ser desfeita.')) {
                return;
            }
            
            this.disabled = true;
            const originalHtml = this.innerHTML;
            this.innerHTML = '<i class="bi bi-hourglass-split me-1"></i> Processando...';
            
            fetch('<?php echo e(route("admin.professor-payments.marcar-todos-pago")); ?>?' + params.toString(), {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json',
                    'X-CSRF-TOKEN': '<?php echo e(csrf_token()); ?>',
                    'Accept': 'application/json',
                    'X-Requested-With': 'XMLHttpRequest'
                },
                body: JSON.stringify({})
            })
            .then(response => response.json())
            .then(data => {
                if (data.success) {
                    alert(data.message);
                    carregarPagamentos(obterPaginaAtual());
                } else {
                    alert(data.message || 'Erro ao marcar pagamentos.');
            }
        })
        .catch(error => {
                console.error('Erro:', error);
                alert('Erro ao marcar pagamentos. Tente novamente.');
            })
            .finally(() => {
                this.disabled = false;
                this.innerHTML = originalHtml;
            });
        });
    }
    
    // Mostrar/esconder linha de novo pagamento
    const btnNovoPagamento = document.getElementById('btn-novo-pagamento');
    const linhaNovoPagamento = document.getElementById('linha-novo-pagamento');
    const btnCancelarNovo = document.querySelector('.cancelar-novo-pagamento');
    
    if (btnNovoPagamento && linhaNovoPagamento) {
        btnNovoPagamento.addEventListener('click', function() {
            linhaNovoPagamento.style.display = '';
            linhaNovoPagamento.scrollIntoView({ behavior: 'smooth', block: 'nearest' });
        });
    }
    
    if (btnCancelarNovo) {
        btnCancelarNovo.addEventListener('click', function() {
            linhaNovoPagamento.style.display = 'none';
            // Limpar campos
            document.querySelector('.novo-pagamento-professor').value = '';
            document.querySelector('.novo-pagamento-horas').value = '';
            document.querySelector('.novo-pagamento-valor-hora').value = '';
            document.querySelector('.novo-pagamento-valor-bruto').value = '';
            document.querySelector('.novo-pagamento-inss').textContent = '0,00 MT';
            document.querySelector('.novo-pagamento-irps').textContent = '0,00 MT';
            document.querySelector('.novo-pagamento-liquido').textContent = '0,00 MT';
            document.querySelector('.novo-pagamento-dependentes').textContent = '0';
        });
    }
    
    // Quando selecionar professor, preencher dados
    const selectProfessor = document.querySelector('.novo-pagamento-professor');
    if (selectProfessor) {
        selectProfessor.addEventListener('change', function() {
            const option = this.options[this.selectedIndex];
            if (option.value) {
                const nivel = option.getAttribute('data-nivel');
                const salarioFixo = parseFloat(option.getAttribute('data-salario-fixo')) || 0;
                const valorHora = parseFloat(option.getAttribute('data-valor-hora')) || 0;
                const dependentes = parseInt(option.getAttribute('data-dependentes')) || 0;
                
                document.querySelector('.novo-pagamento-dependentes').textContent = dependentes;
                
                const valorHoraInput = document.querySelector('.novo-pagamento-valor-hora');
                const horasInput = document.querySelector('.novo-pagamento-horas');
                
                if (nivel === 'PRIMARIO' && salarioFixo > 0) {
                    // Desabilitar horas e valor/hora para primário com salário fixo
                    if (horasInput) horasInput.disabled = true;
                    if (valorHoraInput) valorHoraInput.disabled = true;
                    document.querySelector('.novo-pagamento-valor-bruto').value = salarioFixo.toFixed(2);
                    calcularImpostosNovoPagamento();
                } else {
                    // Habilitar para secundário/ambos
                    if (horasInput) horasInput.disabled = false;
                    if (valorHoraInput) {
                        valorHoraInput.disabled = false;
                        valorHoraInput.value = valorHora > 0 ? valorHora.toFixed(2) : '';
                    }
                }
            }
        });
    }
    
    // Calcular valor bruto quando horas ou valor/hora mudarem
    const horasNovoInput = document.querySelector('.novo-pagamento-horas');
    const valorHoraNovoInput = document.querySelector('.novo-pagamento-valor-hora');
    const valorBrutoNovoInput = document.querySelector('.novo-pagamento-valor-bruto');
    
    function calcularValorBrutoNovoPagamento() {
        if (!valorBrutoNovoInput) return;
        
        const horas = horasNovoInput ? (parseFloat(horasNovoInput.value) || 0) : 0;
        const valorHora = valorHoraNovoInput ? (parseFloat(valorHoraNovoInput.value) || 0) : 0;
        const selectProf = document.querySelector('.novo-pagamento-professor');
        
        if (selectProf && selectProf.value) {
            const option = selectProf.options[selectProf.selectedIndex];
            const nivel = option.getAttribute('data-nivel');
            const salarioFixo = parseFloat(option.getAttribute('data-salario-fixo')) || 0;
            
            let valorBruto = 0;
            if (nivel === 'PRIMARIO' && salarioFixo > 0) {
                valorBruto = salarioFixo;
        } else if (nivel === 'SECUNDARIO') {
            if (horas > 0 && valorHora > 0) {
                    valorBruto = horas * valorHora;
            }
        } else if (nivel === 'AMBOS') {
                valorBruto = salarioFixo || 0;
            if (horas > 0 && valorHora > 0) {
                    valorBruto += (horas * valorHora);
                }
            }
            
            valorBrutoNovoInput.value = valorBruto > 0 ? valorBruto.toFixed(2) : '';
            calcularImpostosNovoPagamento();
        }
    }
    
    function calcularImpostosNovoPagamento() {
        const valorBruto = parseFloat(valorBrutoNovoInput.value) || 0;
        const selectProf = document.querySelector('.novo-pagamento-professor');
        
        if (valorBruto > 0 && selectProf && selectProf.value) {
            const option = selectProf.options[selectProf.selectedIndex];
            const dependentes = parseInt(option.getAttribute('data-dependentes')) || 0;
            
            // Calcular INSS (3%)
            const inss = valorBruto * 0.03;
            
            // IRPS será calculado no servidor, mas mostramos aproximação
            const irpsAprox = 0;
            
            document.querySelector('.novo-pagamento-inss').textContent = 
                inss.toFixed(2).replace('.', ',').replace(/\B(?=(\d{3})+(?!\d))/g, '.') + ' MT';
            document.querySelector('.novo-pagamento-irps').textContent = 
                irpsAprox.toFixed(2).replace('.', ',').replace(/\B(?=(\d{3})+(?!\d))/g, '.') + ' MT';
            document.querySelector('.novo-pagamento-liquido').textContent = 
                (valorBruto - inss - irpsAprox).toFixed(2).replace('.', ',').replace(/\B(?=(\d{3})+(?!\d))/g, '.') + ' MT';
        } else {
            document.querySelector('.novo-pagamento-inss').textContent = '0,00 MT';
            document.querySelector('.novo-pagamento-irps').textContent = '0,00 MT';
            document.querySelector('.novo-pagamento-liquido').textContent = '0,00 MT';
        }
    }
    
    if (horasNovoInput) {
        horasNovoInput.addEventListener('input', calcularValorBrutoNovoPagamento);
    }
    if (valorHoraNovoInput) {
        valorHoraNovoInput.addEventListener('input', calcularValorBrutoNovoPagamento);
    }
    if (valorBrutoNovoInput) {
        valorBrutoNovoInput.addEventListener('input', calcularImpostosNovoPagamento);
    }
    
    // Salvar novo pagamento
    const btnSalvarNovo = document.querySelector('.salvar-novo-pagamento');
    if (btnSalvarNovo) {
        btnSalvarNovo.addEventListener('click', function() {
            const professorId = document.querySelector('.novo-pagamento-professor').value;
            const mes = document.querySelector('.novo-pagamento-mes').value;
            const ano = document.querySelector('.novo-pagamento-ano').value;
            const horas = document.querySelector('.novo-pagamento-horas').value;
            const valorBruto = document.querySelector('.novo-pagamento-valor-bruto').value;
            
            if (!professorId) {
                alert('Selecione um professor.');
                return;
            }
            
            if (!valorBruto || parseFloat(valorBruto) <= 0) {
                alert('O valor bruto deve ser maior que zero.');
                return;
            }
            
            this.disabled = true;
            const originalHtml = this.innerHTML;
            this.innerHTML = '<i class="bi bi-hourglass-split"></i>';
            
            fetch('<?php echo e(route("admin.professor-payments.store")); ?>', {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json',
                    'X-CSRF-TOKEN': '<?php echo e(csrf_token()); ?>',
                    'Accept': 'application/json'
                },
                body: JSON.stringify({
                    professor_id: professorId,
                    mes: parseInt(mes),
                    ano: parseInt(ano),
                    horas_trabalhadas: horas ? parseFloat(horas) : null,
                    valor_total: parseFloat(valorBruto),
                    observacoes: 'Criado diretamente da tabela de pagamentos'
                })
            })
            .then(response => response.json())
            .then(data => {
                if (data.success) {
                    // Esconder linha de novo pagamento
                    if (linhaNovoPagamento) {
                        linhaNovoPagamento.style.display = 'none';
                        // Limpar campos
                        document.querySelector('.novo-pagamento-professor').value = '';
                        document.querySelector('.novo-pagamento-horas').value = '';
                        document.querySelector('.novo-pagamento-valor-hora').value = '';
                        document.querySelector('.novo-pagamento-valor-bruto').value = '';
                        document.querySelector('.novo-pagamento-inss').textContent = '0,00 MT';
                        document.querySelector('.novo-pagamento-irps').textContent = '0,00 MT';
                        document.querySelector('.novo-pagamento-liquido').textContent = '0,00 MT';
                        document.querySelector('.novo-pagamento-dependentes').textContent = '0';
                    }
                    // Recarregar tabela via AJAX (voltar para página 1 ao criar novo)
                    carregarPagamentos(1);
                } else {
                    alert('Erro: ' + (data.message || 'Não foi possível criar o pagamento.'));
                    this.disabled = false;
                    this.innerHTML = originalHtml;
                }
            })
            .catch(error => {
                console.error('Erro:', error);
                alert('Erro ao criar pagamento. Tente novamente.');
                this.disabled = false;
                this.innerHTML = originalHtml;
            });
        });
    }
    
    // Função para persistir atualização (usa `updateTimeouts` declarado acima)
    function atualizarPagamento(paymentId) {
        const valorBrutoInput = document.querySelector('.editar-valor-bruto[data-payment-id="' + paymentId + '"]');
        const horasInput = document.querySelector('.editar-horas[data-payment-id="' + paymentId + '"]');
        const valorHoraInput = document.querySelector('.editar-valor-hora[data-payment-id="' + paymentId + '"]');
        
        if (!valorBrutoInput) return;
        
        // Se houver horas e valor/hora, recalcular valor bruto
        if (horasInput && valorHoraInput && !horasInput.disabled && !valorHoraInput.disabled) {
            const horas = parseFloat(horasInput.value) || 0;
            const valorHora = parseFloat(valorHoraInput.value) || 0;
            const row = horasInput.closest('tr');
            const nivel = row ? row.getAttribute('data-nivel') : 'AMBOS';
            const salarioFixo = row ? parseFloat(row.getAttribute('data-salario-fixo')) || 0 : 0;
            
            let novoValorBruto = 0;
            if (nivel === 'PRIMARIO' && salarioFixo > 0) {
                novoValorBruto = salarioFixo;
            } else if (horas > 0 && valorHora > 0) {
                novoValorBruto = horas * valorHora;
                if (nivel === 'AMBOS' && salarioFixo > 0) {
                    novoValorBruto += salarioFixo;
                }
            }
            
            if (novoValorBruto > 0) {
                valorBrutoInput.value = novoValorBruto.toFixed(2);
            }
        }
        
        const valorTotal = parseFloat(valorBrutoInput.value) || 0;
        const horasTrabalhadas = horasInput ? (parseFloat(horasInput.value) || null) : null;
        
        if (valorTotal <= 0) {
            alert('O valor bruto deve ser maior que zero.');
            return;
        }
        
        // Desabilitar inputs durante atualização
        if (valorBrutoInput) valorBrutoInput.disabled = true;
        if (horasInput) horasInput.disabled = true;
        
        fetch('<?php echo e(route("admin.professor-payments.update", ":id")); ?>'.replace(':id', paymentId), {
            method: 'PUT',
            headers: {
                'Content-Type': 'application/json',
                'X-CSRF-TOKEN': '<?php echo e(csrf_token()); ?>',
                'Accept': 'application/json'
            },
            body: JSON.stringify({
                valor_total: valorTotal,
                horas_trabalhadas: horasTrabalhadas
            })
        })
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                // Recarregar tabela via AJAX para garantir sincronização
                carregarPagamentos(obterPaginaAtual());
            } else {
                alert('Erro: ' + (data.message || 'Não foi possível atualizar o pagamento.'));
                // Recarregar tabela para restaurar valores
                carregarPagamentos(obterPaginaAtual());
            }
        })
        .catch(error => {
            console.error('Erro:', error);
            alert('Erro ao atualizar pagamento. Tente novamente.');
            // Recarregar tabela para restaurar valores
            carregarPagamentos(obterPaginaAtual());
        });
    }
    
    // Reativar event listeners após renderizar tabela (usando event delegation)
    function reativarEventListeners() {
        const container = document.getElementById('payments-table-container');
        if (!container) return;
        
        // Event delegation para editar valor bruto
        container.addEventListener('input', function(e) {
            if (e.target.classList.contains('editar-valor-bruto')) {
                const paymentId = e.target.getAttribute('data-payment-id');
                const valorBruto = parseFloat(e.target.value) || 0;
                
                // Calcular INSS e IRPS localmente (aproximado)
                const inss = valorBruto * 0.03;
                const irpsAprox = 0;
                const valorLiquidoAprox = valorBruto - inss - irpsAprox;
                
                // Atualizar visualmente
                const inssElement = document.querySelector('.valor-inss[data-payment-id="' + paymentId + '"]');
                const liquidoElement = document.querySelector('.valor-liquido[data-payment-id="' + paymentId + '"]');
                
                if (inssElement) {
                    inssElement.textContent = inss.toFixed(2).replace('.', ',').replace(/\B(?=(\d{3})+(?!\d))/g, '.');
                }
                if (liquidoElement) {
                    liquidoElement.textContent = valorLiquidoAprox.toFixed(2).replace('.', ',').replace(/\B(?=(\d{3})+(?!\d))/g, '.');
                }
                
                // Limpar timeout anterior
                if (updateTimeouts[paymentId]) {
                    clearTimeout(updateTimeouts[paymentId]);
                }
                
                // Salvar após 1.5 segundos sem digitar
                updateTimeouts[paymentId] = setTimeout(function() {
                    atualizarPagamento(paymentId);
                }, 1500);
            }
        });
        
        // Event delegation para editar horas
        container.addEventListener('input', function(e) {
            if (e.target.classList.contains('editar-horas')) {
                const paymentId = e.target.getAttribute('data-payment-id');
                const horas = parseFloat(e.target.value) || 0;
                
                // Recalcular valor bruto se houver valor/hora
                const valorHoraInput = document.querySelector('.editar-valor-hora[data-payment-id="' + paymentId + '"]');
                const valorBrutoInput = document.querySelector('.editar-valor-bruto[data-payment-id="' + paymentId + '"]');
                
                if (valorBrutoInput) {
                    let novoValorBruto = 0;
                    const row = e.target.closest('tr');
                    const nivel = row ? row.getAttribute('data-nivel') : 'AMBOS';
                    const salarioFixo = row ? parseFloat(row.getAttribute('data-salario-fixo')) || 0 : 0;
                    
                    if (valorHoraInput && !valorHoraInput.disabled) {
                        const valorHora = parseFloat(valorHoraInput.value) || 0;
                        if (horas > 0 && valorHora > 0) {
                            novoValorBruto = horas * valorHora;
                            if (nivel === 'AMBOS' && salarioFixo > 0) {
                                novoValorBruto += salarioFixo;
                            }
                        }
                    }
                    
                    if (novoValorBruto > 0) {
                        valorBrutoInput.value = novoValorBruto.toFixed(2);
                        valorBrutoInput.dispatchEvent(new Event('input'));
                    }
                }
                
                // Limpar timeout anterior
                if (updateTimeouts[paymentId]) {
                    clearTimeout(updateTimeouts[paymentId]);
                }
                
                // Salvar após 1.5 segundos sem digitar
                updateTimeouts[paymentId] = setTimeout(function() {
                    atualizarPagamento(paymentId);
                }, 1500);
            }
        });
        
        // Event delegation para editar valor/hora
        container.addEventListener('input', function(e) {
            if (e.target.classList.contains('editar-valor-hora')) {
                const paymentId = e.target.getAttribute('data-payment-id');
                const professorId = e.target.getAttribute('data-professor-id');
                const valorHora = parseFloat(e.target.value) || 0;
                
                // Recalcular valor bruto imediatamente se houver horas
                const horasInput = document.querySelector('.editar-horas[data-payment-id="' + paymentId + '"]');
                const valorBrutoInput = document.querySelector('.editar-valor-bruto[data-payment-id="' + paymentId + '"]');
                
                if (horasInput && valorBrutoInput && !horasInput.disabled) {
                    const horas = parseFloat(horasInput.value) || 0;
                    if (horas > 0 && valorHora > 0) {
                        valorBrutoInput.value = (horas * valorHora).toFixed(2);
                        valorBrutoInput.dispatchEvent(new Event('input'));
                    }
                }
                
                // Salvar valor/hora no professor
                if (professorId && valorHora > 0) {
                    fetch('<?php echo e(route("admin.professores.update-valor-hora", ":id")); ?>'.replace(':id', professorId), {
                        method: 'PATCH',
                        headers: {
                            'Content-Type': 'application/json',
                            'X-CSRF-TOKEN': '<?php echo e(csrf_token()); ?>',
                            'Accept': 'application/json'
                        },
                        body: JSON.stringify({
                            valor_hora: valorHora
                        })
                    })
                    .catch(error => {
                        console.error('Erro ao salvar valor/hora:', error);
                    });
                }
            }
        });
        
        // Event delegation para marcar como pago
        container.addEventListener('submit', function(e) {
            if (e.target.classList.contains('marcar-pago-form')) {
                e.preventDefault();
                const form = e.target;
                const paymentId = form.action.split('/').pop();
                
                fetch(form.action, {
                    method: 'POST',
                    headers: {
                        'Content-Type': 'application/json',
                        'X-CSRF-TOKEN': '<?php echo e(csrf_token()); ?>',
                        'Accept': 'application/json',
                        'X-Requested-With': 'XMLHttpRequest'
                    },
                    body: JSON.stringify({})
                })
                .then(response => response.json())
                .then(data => {
                    if (data.success) {
                        carregarPagamentos(obterPaginaAtual());
                    } else {
                        alert('Erro: ' + (data.message || 'Não foi possível marcar como pago.'));
                    }
                })
                .catch(error => {
                    console.error('Erro:', error);
                    alert('Erro ao marcar como pago. Tente novamente.');
                });
            }
        });
    }
    
    // Configurar event delegation uma vez no início (funciona para elementos dinâmicos)
    configurarEventDelegation();
    
    // Verificar se há dados na tabela inicial (renderizados pelo Blade)
    const container = document.getElementById('payments-table-container');
    const tabelaInicial = container ? container.querySelector('table tbody') : null;
    const temDadosIniciais = tabelaInicial && tabelaInicial.querySelectorAll('tr').length > 0;
    
    // Se não houver dados iniciais ou se houver parâmetros na URL, carregar via AJAX
    const urlParams = new URLSearchParams(window.location.search);
    const temParametros = urlParams.has('page') || urlParams.has('professor_id') || 
                          urlParams.has('mes') || urlParams.has('ano') || urlParams.has('status');
    
    // Se houver parâmetros na URL, sempre carregar via AJAX para aplicar filtros
    if (temParametros) {
        // Esconder tabela inicial e mostrar loading
        if (container && temDadosIniciais) {
            container.style.display = 'none';
        }
        const loading = document.getElementById('loading-payments');
        if (loading) {
            loading.style.display = 'block';
        }
        // Carregar via AJAX
        setTimeout(function() {
            carregarPagamentos();
        }, 100);
    }
    // Se não houver dados iniciais e não houver parâmetros, também carregar via AJAX
    else if (!temDadosIniciais) {
        const loading = document.getElementById('loading-payments');
        if (loading) {
            loading.style.display = 'block';
        }
        if (container) {
            container.style.display = 'none';
        }
        setTimeout(function() {
            carregarPagamentos();
        }, 100);
    }
    
    // Adicionar event delegation para links de paginação (funciona para elementos dinâmicos)
    document.addEventListener('click', function(e) {
        // Links de paginação customizados
        if (e.target.classList.contains('pagination-link')) {
            e.preventDefault();
            e.stopPropagation();
            const page = parseInt(e.target.getAttribute('data-page'));
            if (page) {
                carregarPagamentos(page);
                // Scroll para o topo da tabela
                const container = document.getElementById('payments-table-container');
                if (container) {
                    container.scrollIntoView({ behavior: 'smooth', block: 'start' });
                }
            }
            return false;
        }
        
        // Links de paginação do Laravel (pagination) - verificar se é um link dentro de .pagination
        const link = e.target.closest('.pagination a');
        if (link && link.href) {
            // Ignorar se já é um link customizado
            if (link.classList.contains('pagination-link')) {
                return;
            }
            
            try {
                // Verificar se o href contém 'page=' ou é um link de paginação
                if (link.href.includes('page=') || (link.href.includes('admin/professor-payments') && link.closest('.pagination'))) {
                    e.preventDefault();
                    e.stopPropagation();
                    
                    let page = 1;
                    try {
                        const url = new URL(link.href);
                        page = parseInt(url.searchParams.get('page')) || 1;
                    } catch (err) {
                        // Tentar extrair da URL manualmente
                        const match = link.href.match(/[?&]page=(\d+)/);
                        if (match) {
                            page = parseInt(match[1]);
                        }
                    }
                    
                    carregarPagamentos(page);
                    // Scroll para o topo da tabela
                    const container = document.getElementById('payments-table-container');
                    if (container) {
                        container.scrollIntoView({ behavior: 'smooth', block: 'start' });
                    }
                    return false;
                }
            } catch (err) {
                // Se não conseguir fazer parse da URL, deixar o comportamento padrão
                console.error('Erro ao processar link de paginação:', err);
            }
        }
    }, true); // Usar capture phase para interceptar antes que outros handlers
    
});
</script>

<!-- Modal para Download Folha de Salário -->
<div class="modal fade" id="modalFolhaSalario" tabindex="-1" aria-labelledby="modalFolhaSalarioLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="modalFolhaSalarioLabel">
                    <i class="bi bi-download me-2"></i>Download Folha de Salário
                </h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <form action="<?php echo e(route('admin.professor-payments.folha-salario')); ?>" method="GET" id="form-download-folha">
                <div class="modal-body">
                    <div class="mb-3">
                        <label for="folha_mes" class="form-label">Mês</label>
                        <select name="mes" id="folha_mes" class="form-select" required>
                            <?php for($i = 1; $i <= 12; $i++): ?>
                                <option value="<?php echo e($i); ?>" <?php echo e((int)request('mes', date('m')) === $i ? 'selected' : ''); ?>>
                                    <?php echo e(['', 'Janeiro', 'Fevereiro', 'Março', 'Abril', 'Maio', 'Junho', 'Julho', 'Agosto', 'Setembro', 'Outubro', 'Novembro', 'Dezembro'][$i]); ?>

                                </option>
                            <?php endfor; ?>
                        </select>
                    </div>
                    <div class="mb-3">
                        <label for="folha_ano" class="form-label">Ano</label>
                        <input type="number" name="ano" id="folha_ano" class="form-control" 
                               value="<?php echo e(request('ano', date('Y'))); ?>" min="2020" max="2100" required>
                    </div>
                    <div class="mb-3">
                        <label for="folha_professor_id" class="form-label">Professor</label>
                        <select name="professor_id" id="folha_professor_id" class="form-select">
                            <option value="">Todos os Professores</option>
                            <?php $__currentLoopData = $professores; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $prof): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($prof->id); ?>" <?php echo e(request('professor_id') == $prof->id ? 'selected' : ''); ?>>
                                    <?php echo e($prof->user->name); ?> (<?php echo e($prof->numero_funcionario); ?>)
                                </option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                        <small class="text-muted">Deixe em branco para gerar folha de todos os professores</small>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancelar</button>
                    <button type="submit" class="btn btn-success">
                        <i class="bi bi-download me-1"></i> Download
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- Modal para Imprimir Folha de Salário -->
<div class="modal fade" id="modalFolhaSalarioImprimir" tabindex="-1" aria-labelledby="modalFolhaSalarioImprimirLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="modalFolhaSalarioImprimirLabel">
                    <i class="bi bi-printer me-2"></i>Imprimir Folha de Salário
                </h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <form action="<?php echo e(route('admin.professor-payments.folha-salario.visualizar')); ?>" method="GET" target="_blank" id="form-imprimir-folha">
                <div class="modal-body">
                    <div class="mb-3">
                        <label for="imprimir_mes" class="form-label">Mês</label>
                        <select name="mes" id="imprimir_mes" class="form-select" required>
                            <?php for($i = 1; $i <= 12; $i++): ?>
                                <option value="<?php echo e($i); ?>" <?php echo e((int)request('mes', date('m')) === $i ? 'selected' : ''); ?>>
                                    <?php echo e(['', 'Janeiro', 'Fevereiro', 'Março', 'Abril', 'Maio', 'Junho', 'Julho', 'Agosto', 'Setembro', 'Outubro', 'Novembro', 'Dezembro'][$i]); ?>

                                </option>
                            <?php endfor; ?>
                        </select>
                    </div>
                    <div class="mb-3">
                        <label for="imprimir_ano" class="form-label">Ano</label>
                        <input type="number" name="ano" id="imprimir_ano" class="form-control" 
                               value="<?php echo e(request('ano', date('Y'))); ?>" min="2020" max="2100" required>
                    </div>
                    <div class="mb-3">
                        <label for="imprimir_professor_id" class="form-label">Professor</label>
                        <select name="professor_id" id="imprimir_professor_id" class="form-select">
                            <option value="">Todos os Professores</option>
                            <?php $__currentLoopData = $professores; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $prof): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($prof->id); ?>" <?php echo e(request('professor_id') == $prof->id ? 'selected' : ''); ?>>
                                    <?php echo e($prof->user->name); ?> (<?php echo e($prof->numero_funcionario); ?>)
                                </option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                        <small class="text-muted">Deixe em branco para imprimir folha de todos os professores</small>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancelar</button>
                    <button type="submit" class="btn btn-info">
                        <i class="bi bi-printer me-1"></i> Imprimir
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>
<?php $__env->stopPush(); ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\Users\Alcidio\Desktop\escola\resources\views/admin/professor-payments/index.blade.php ENDPATH**/ ?>