

<?php $__env->startSection('title', 'Notas por Estudante - Avaliações'); ?>

<?php $__env->startSection('content'); ?>
<div class="row">
    <div class="col-12">
        <div class="d-flex justify-content-between align-items-center mb-3">
            <h2>Notas por Estudante</h2>
            <a href="<?php echo e(route('avaliacoes.index')); ?>" class="btn btn-secondary btn-sm">Voltar</a>
        </div>

        <div class="card mb-3">
            <div class="card-body">
                <form method="GET" action="<?php echo e(route('avaliacoes.notas-por-estudante')); ?>" class="row g-3">
                    <div class="col-md-4">
                        <label for="turma_id" class="form-label">Turma</label>
                        <select name="turma_id" id="turma_id" class="form-select" required>
                            <option value="">Selecione a Turma</option>
                            <?php $__currentLoopData = $turmas; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $turma): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($turma->id); ?>" <?php echo e($turmaId == $turma->id ? 'selected' : ''); ?>>
                                    <?php echo e($turma->codigo); ?> - <?php echo e($turma->nome); ?>

                                </option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>
                    <div class="col-md-4">
                        <label for="aluno_id" class="form-label">Estudante (opcional)</label>
                        <select name="aluno_id" id="aluno_id" class="form-select">
                            <option value="">Todos os Estudantes</option>
                            <?php if($turmaId): ?>
                                <?php $__currentLoopData = $alunos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $aluno): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($aluno->id); ?>" <?php echo e($alunoId == $aluno->id ? 'selected' : ''); ?>>
                                        <?php echo e($aluno->user->name); ?>

                                    </option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <?php endif; ?>
                        </select>
                    </div>
                    <div class="col-md-4 d-flex align-items-end">
                        <button type="submit" class="btn btn-primary">Buscar</button>
                    </div>
                </form>
            </div>
        </div>

        <?php if($turmaId && $alunos->count() > 0): ?>
            <?php
                $isSecundario = ($turma->nivel_ensino ?? 'PRIMARIO') === 'SECUNDARIO';
            ?>
            <div class="d-flex justify-content-end gap-2 mb-3">
                <a href="<?php echo e(route('avaliacoes.imprimir-notas-por-estudante', ['turma_id' => $turmaId, 'aluno_id' => $alunoId])); ?>" 
                   target="_blank" class="btn btn-sm btn-outline-primary">
                    <i class="bi bi-printer"></i> Imprimir
                </a>
                <a href="<?php echo e(route('avaliacoes.download-pdf-notas-por-estudante', ['turma_id' => $turmaId, 'aluno_id' => $alunoId])); ?>" 
                   class="btn btn-sm btn-outline-danger">
                    <i class="bi bi-file-earmark-pdf"></i> Download PDF
                </a>
            </div>
            <?php $__currentLoopData = $alunos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $aluno): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="mb-3">
                    <h6 class="mb-2"><?php echo e($aluno->user->name); ?></h6>
                    <div class="table-responsive">
                        <table class="table table-bordered table-sm" style="font-size: 0.7rem;">
                            <style>
                                .table-bordered th, .table-bordered td {
                                    padding: 0.25rem 0.35rem !important;
                                }
                            </style>
                            <thead>
                                    <?php if($isSecundario): ?>
                                        <tr>
                                            <th rowspan="2" style="vertical-align: middle;">Disciplina</th>
                                            <?php $__currentLoopData = $trimestres; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $trimestre): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <th colspan="4" class="text-center"><?php echo e($trimestre->numero); ?>° Trimestre</th>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            <th rowspan="2" style="vertical-align: middle;">MFrD</th>
                                            <th rowspan="2" style="vertical-align: middle;">Classificação</th>
                                        </tr>
                                        <tr>
                                            <?php $__currentLoopData = $trimestres; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $trimestre): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <th>Teste 1</th>
                                                <th>Teste 2</th>
                                                <th>Av. Final</th>
                                                <th>Média</th>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </tr>
                                    <?php else: ?>
                                        <tr>
                                            <th rowspan="3" style="vertical-align: middle;">Disciplina</th>
                                            <?php $__currentLoopData = $trimestres; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $trimestre): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <th colspan="8" class="text-center"><?php echo e($trimestre->numero); ?>° Trimestre</th>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            <th rowspan="3" style="vertical-align: middle;">MFrD</th>
                                            <th rowspan="3" style="vertical-align: middle;">Classificação</th>
                                        </tr>
                                        <tr>
                                            <?php $__currentLoopData = $trimestres; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $trimestre): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <th colspan="3">A.Prática</th>
                                                <th colspan="2">ACS</th>
                                                <th rowspan="2" style="vertical-align: middle;">MACS</th>
                                                <th rowspan="2" style="vertical-align: middle;">AT</th>
                                                <th rowspan="2" style="vertical-align: middle;">MT</th>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </tr>
                                        <tr>
                                            <?php $__currentLoopData = $trimestres; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $trimestre): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <th>1ª</th>
                                                <th>2ª</th>
                                                <th>MAP</th>
                                                <th>1ª</th>
                                                <th>2ª</th>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </tr>
                                    <?php endif; ?>
                                </thead>
                                <tbody>
                                    <?php $__currentLoopData = $disciplinas; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $disciplina): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <?php
                                            $primeiraAvaliacao = null;
                                            $mfrd = null;
                                            foreach ($trimestres as $trimestre) {
                                                $av = $avaliacoesPorAluno[$aluno->id][$disciplina->id][$trimestre->id] ?? null;
                                                if ($av && $av->mfrd !== null) {
                                                    $primeiraAvaliacao = $av;
                                                    $mfrd = $av->mfrd;
                                                    break;
                                                }
                                            }
                                            // Aprovado se MFrD >= 10 (com arredondamento por excesso de 9.5-9.99 para 10)
                                            $aprovado = \App\Models\Avaliacao::isAprovado($mfrd);
                                        ?>
                                        <tr>
                                            <td><?php echo e($disciplina->nome); ?></td>
                                            <?php $__currentLoopData = $trimestres; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $trimestre): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <?php
                                                    $avaliacao = $avaliacoesPorAluno[$aluno->id][$disciplina->id][$trimestre->id] ?? null;
                                                ?>
                                                <?php if($isSecundario): ?>
                                                    <td class="text-center <?php echo e($avaliacao && $avaliacao->teste1 !== null && $avaliacao->teste1 < 10 ? 'text-danger' : ''); ?>"><?php echo e($avaliacao && $avaliacao->teste1 !== null ? number_format($avaliacao->teste1, 1, '.', '') : ''); ?></td>
                                                    <td class="text-center <?php echo e($avaliacao && $avaliacao->teste2 !== null && $avaliacao->teste2 < 10 ? 'text-danger' : ''); ?>"><?php echo e($avaliacao && $avaliacao->teste2 !== null ? number_format($avaliacao->teste2, 1, '.', '') : ''); ?></td>
                                                    <td class="text-center <?php echo e($avaliacao && $avaliacao->avaliacao_final !== null && $avaliacao->avaliacao_final < 10 ? 'text-danger' : ''); ?>"><?php echo e($avaliacao && $avaliacao->avaliacao_final !== null ? number_format($avaliacao->avaliacao_final, 1, '.', '') : ''); ?></td>
                                                    <td class="text-center fw-bold <?php echo e($avaliacao && $avaliacao->media_nacional !== null && $avaliacao->media_nacional < 10 ? 'text-danger' : ''); ?>"><?php echo e($avaliacao && $avaliacao->media_nacional !== null ? number_format($avaliacao->media_nacional, 1, '.', '') : ''); ?></td>
                                                <?php else: ?>
                                                    <td class="text-center <?php echo e($avaliacao && $avaliacao->a_pratica_1 !== null && $avaliacao->a_pratica_1 < 10 ? 'text-danger' : ''); ?>"><?php echo e($avaliacao && $avaliacao->a_pratica_1 !== null ? number_format($avaliacao->a_pratica_1, 1, '.', '') : ''); ?></td>
                                                    <td class="text-center <?php echo e($avaliacao && $avaliacao->a_pratica_2 !== null && $avaliacao->a_pratica_2 < 10 ? 'text-danger' : ''); ?>"><?php echo e($avaliacao && $avaliacao->a_pratica_2 !== null ? number_format($avaliacao->a_pratica_2, 1, '.', '') : ''); ?></td>
                                                    <td class="text-center fw-bold <?php echo e($avaliacao && $avaliacao->map !== null && $avaliacao->map < 10 ? 'text-danger' : ''); ?>"><?php echo e($avaliacao && $avaliacao->map !== null ? number_format($avaliacao->map, 1, '.', '') : ''); ?></td>
                                                    <td class="text-center <?php echo e($avaliacao && $avaliacao->acs_1 !== null && $avaliacao->acs_1 < 10 ? 'text-danger' : ''); ?>"><?php echo e($avaliacao && $avaliacao->acs_1 !== null ? number_format($avaliacao->acs_1, 1, '.', '') : ''); ?></td>
                                                    <td class="text-center <?php echo e($avaliacao && $avaliacao->acs_2 !== null && $avaliacao->acs_2 < 10 ? 'text-danger' : ''); ?>"><?php echo e($avaliacao && $avaliacao->acs_2 !== null ? number_format($avaliacao->acs_2, 1, '.', '') : ''); ?></td>
                                                    <td class="text-center fw-bold <?php echo e($avaliacao && $avaliacao->macs !== null && $avaliacao->macs < 10 ? 'text-danger' : ''); ?>"><?php echo e($avaliacao && $avaliacao->macs !== null ? number_format($avaliacao->macs, 1, '.', '') : ''); ?></td>
                                                    <td class="text-center <?php echo e($avaliacao && $avaliacao->at !== null && $avaliacao->at < 10 ? 'text-danger' : ''); ?>"><?php echo e($avaliacao && $avaliacao->at !== null ? number_format($avaliacao->at, 1, '.', '') : ''); ?></td>
                                                    <td class="text-center fw-bold <?php echo e($avaliacao && $avaliacao->mt !== null && $avaliacao->mt < 10 ? 'text-danger' : ''); ?>"><?php echo e($avaliacao && $avaliacao->mt !== null ? number_format($avaliacao->mt, 0, '.', '') : ''); ?></td>
                                                <?php endif; ?>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            <td class="text-center fw-bold <?php echo e($mfrd !== null && $mfrd < 10 ? 'text-danger' : ''); ?>"><?php echo e($mfrd !== null ? number_format($mfrd, 0, '.', '') : ''); ?></td>
                                            <td class="text-center <?php echo e($aprovado ? 'text-success' : ($mfrd !== null ? 'text-danger' : '')); ?>"><?php echo e($mfrd !== null ? ($aprovado ? 'APROVADO' : 'REPROVADO') : ''); ?></td>
                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>
                            </table>
                        </div>
                </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        <?php elseif($turmaId): ?>
            <div class="alert alert-info">
                Nenhum estudante encontrado para esta turma.
            </div>
        <?php endif; ?>
    </div>
</div>

<script>
    document.addEventListener('DOMContentLoaded', function() {
        const turmaSelect = document.getElementById('turma_id');
        if (turmaSelect) {
            turmaSelect.addEventListener('change', function() {
                const turmaId = this.value;
                if (turmaId) {
                    // Recarregar a página com a turma selecionada para carregar os alunos
                    window.location.href = '<?php echo e(route("avaliacoes.notas-por-estudante")); ?>?turma_id=' + turmaId;
                } else {
                    window.location.href = '<?php echo e(route("avaliacoes.notas-por-estudante")); ?>';
                }
            });
        }
    });
</script>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\Users\Alcidio\Desktop\escola\resources\views/avaliacoes/notas-por-estudante.blade.php ENDPATH**/ ?>