

<?php $__env->startSection('title', 'Pagamento Registrado - SIGE'); ?>

<?php $__env->startSection('content'); ?>
<div class="row">
    <div class="col-12">
        <div class="d-flex justify-content-between align-items-center mb-3">
            <h5 class="mb-0">Pagamento Registrado</h5>
            <div class="d-flex gap-2">
                <a href="<?php echo e(route('financeiro.factura.download', $invoice)); ?>" class="btn btn-sm btn-primary">
                    <i class="bi bi-download"></i> PDF
                </a>
                <button onclick="window.print()" class="btn btn-sm btn-outline-primary">
                    <i class="bi bi-printer"></i>
                </button>
                <a href="<?php echo e(route('financeiro.index')); ?>" class="btn btn-sm btn-secondary">
                    <i class="bi bi-arrow-left"></i> Voltar
                </a>
            </div>
        </div>
    </div>
</div>

<div class="border rounded p-3 mb-3">
    <div class="row mb-3">
        <div class="col-md-6">
            <?php if(isset($logotipoUrl) && $logotipoUrl): ?>
                <img src="<?php echo e($logotipoUrl); ?>" alt="Logotipo" style="max-height: 60px; margin-bottom: 8px;">
            <?php endif; ?>
            <div class="small text-muted"><?php echo e(\App\Models\Configuracao::get('escola', 'ESCOLA PRIMARIA E COMPLETA SGE')); ?></div>
        </div>
        <div class="col-md-6 text-end">
            <div class="fw-bold mb-1">FACTURA Nº <?php echo e($invoice->numero_factura); ?></div>
            <div class="small text-muted"><?php echo e($invoice->data_emissao->format('d/m/Y')); ?></div>
            <span class="badge bg-<?php echo e($invoice->status === 'PAGA' ? 'success' : 'warning'); ?>">
                <?php echo e($invoice->status === 'PAGA' ? 'Paga' : 'Pendente'); ?>

            </span>
        </div>
    </div>

    <hr class="my-2">

    <div class="mb-2 small">
        <strong>Aluno:</strong> <?php echo e($invoice->aluno->user->name); ?><br>
        <strong>Código:</strong> <?php echo e($invoice->aluno->codigo_estudante); ?>

    </div>

    <hr class="my-2">

    <div class="table-responsive">
        <table class="table table-sm table-bordered mb-0">
            <thead>
                <tr>
                    <th>Descrição</th>
                    <th class="text-end" style="width: 120px;">Valor</th>
                </tr>
            </thead>
            <tbody>
                <?php if($invoice->itens): ?>
                    <?php $__currentLoopData = $invoice->itens; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <td><?php echo e($item['descricao'] ?? 'Mensalidade'); ?></td>
                            <td class="text-end"><?php echo e(number_format($item['valor'] ?? $invoice->valor, 0, ',', '.')); ?> MT</td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                <?php else: ?>
                    <tr>
                        <td><?php echo e($invoice->descricao ?? 'Mensalidade'); ?></td>
                        <td class="text-end"><?php echo e(number_format($invoice->valor, 0, ',', '.')); ?> MT</td>
                    </tr>
                <?php endif; ?>
            </tbody>
            <tfoot>
                <tr>
                    <th class="text-end">Total</th>
                    <th class="text-end"><?php echo e(number_format($invoice->valor, 0, ',', '.')); ?> MT</th>
                </tr>
            </tfoot>
        </table>
    </div>

    <?php if($invoice->payment): ?>
        <div class="mt-3 pt-2 border-top small">
            <strong>Pagamento:</strong> <?php echo e($invoice->payment->metodo === 'MPESA' ? 'M-Pesa' : ($invoice->payment->metodo === 'EMOLA' ? 'Emola' : 'Presencial')); ?><br>
            <strong>Referência:</strong> <?php echo e($invoice->payment->reference); ?><br>
            <?php if($invoice->payment->data_pagamento): ?>
                <strong>Data:</strong> <?php echo e($invoice->payment->data_pagamento->format('d/m/Y H:i')); ?>

            <?php endif; ?>
        </div>
    <?php endif; ?>

    <?php if($invoice->codigo_verificacao): ?>
        <div class="mt-2 pt-2 border-top text-center small">
            <span class="text-muted">Código:</span> <span class="badge bg-secondary"><?php echo e($invoice->codigo_verificacao); ?></span>
        </div>
    <?php endif; ?>
</div>

<style>
    @media print {
        .btn, .d-flex.justify-content-between {
            display: none !important;
        }
        .border {
            border: 1px solid #000 !important;
        }
    }
</style>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\Users\Alcidio\Desktop\escola\resources\views/financeiro/pagamento-sucesso.blade.php ENDPATH**/ ?>