<?php $__env->startSection('title', 'Mensalidades - Estudante'); ?>

<?php
    $turma = $aluno->turmas()->wherePivot('ano_letivo_id', $anoLetivoAtivo->id ?? null)->first();
?>

<?php $__env->startSection('content'); ?>
<style>
    /* Estilos Mobile para Mensalidades */
    @media (max-width: 768px) {
        .financeiro-mobile-header {
            background: linear-gradient(135deg, #4a90e2 0%, #357abd 100%);
            color: white;
            padding: 1rem;
            margin: -1rem -1rem 1.5rem -1rem;
            position: relative;
        }
        
        .financeiro-mobile-header .back-btn {
            position: absolute;
            top: 1rem;
            left: 1rem;
            color: white;
            font-size: 1.5rem;
            text-decoration: none;
            z-index: 10;
        }
        
        .financeiro-mobile-header .profile-btn {
            position: absolute;
            top: 1rem;
            right: 1rem;
            color: white;
            font-size: 1.5rem;
            text-decoration: none;
            z-index: 10;
        }
        
        .financeiro-mobile-header h1 {
            font-size: 1.1rem;
            font-weight: bold;
            margin: 0.5rem 0;
            text-align: center;
        }
        
        .financeiro-mobile-student-info {
            background: white;
            padding: 1rem;
            margin: 0 -1rem 1rem -1rem;
            border-bottom: 1px solid #e0e0e0;
        }
        
        .financeiro-mobile-student-info .info-row {
            display: flex;
            justify-content: space-between;
            margin-bottom: 0.5rem;
        }
        
        .financeiro-mobile-student-info .info-label {
            font-weight: 600;
            color: #333;
        }
        
        .financeiro-mobile-student-info .info-value {
            color: #666;
        }
        
        .financeiro-mobile-summary-cards {
            display: grid;
            grid-template-columns: repeat(3, 1fr);
            gap: 0.75rem;
            margin: 0 -1rem 1rem -1rem;
            padding: 0 1rem;
        }
        
        .financeiro-mobile-summary-card {
            background: white;
            border: 1px solid #e0e0e0;
            border-radius: 8px;
            padding: 0.75rem;
            text-align: center;
        }
        
        .financeiro-mobile-summary-card .card-label {
            font-size: 0.75rem;
            color: #666;
            margin-bottom: 0.25rem;
        }
        
        .financeiro-mobile-summary-card .card-value {
            font-size: 0.9rem;
            font-weight: bold;
            color: #333;
        }
        
        .financeiro-mobile-total-bar {
            background: linear-gradient(135deg, #4a90e2 0%, #357abd 100%);
            color: white;
            padding: 1rem;
            margin: 0 -1rem 1rem -1rem;
            text-align: center;
        }
        
        .financeiro-mobile-total-bar .total-label {
            font-size: 0.85rem;
            margin-bottom: 0.25rem;
        }
        
        .financeiro-mobile-total-bar .total-value {
            font-size: 1.5rem;
            font-weight: bold;
        }
        
        .financeiro-mobile-situation {
            background: white;
            padding: 0.75rem 1rem;
            margin: 0 -1rem 1rem -1rem;
            border-bottom: 1px solid #e0e0e0;
            display: flex;
            align-items: center;
            gap: 0.5rem;
        }
        
        .financeiro-mobile-situation .situation-label {
            font-size: 0.85rem;
            font-weight: 600;
            color: #333;
        }
        
        .financeiro-mobile-situation .situation-badge {
            padding: 0.25rem 0.75rem;
            border-radius: 20px;
            font-size: 0.8rem;
            font-weight: 600;
        }
        
        .financeiro-mobile-situation .situation-badge.regular {
            background: #2ecc71;
            color: white;
        }
        
        .financeiro-mobile-situation .situation-check {
            color: #2ecc71;
            font-size: 1.2rem;
        }
        
        /* Estilos para lista de mensalidades em cards */
        .financeiro-mobile-mensalidades-list {
            margin: 0 -1rem;
            padding: 0 1rem 1rem 1rem;
        }
        
        .financeiro-mobile-mensalidade-card {
            background: white;
            border: 1px solid #e0e0e0;
            border-radius: 12px;
            margin-bottom: 1rem;
            padding: 1rem;
            box-shadow: 0 2px 4px rgba(0,0,0,0.05);
            overflow: hidden;
        }
        
        .mensalidade-card-header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 1rem;
            padding-bottom: 0.75rem;
            border-bottom: 1px solid #f0f0f0;
        }
        
        .mensalidade-mes {
            display: flex;
            align-items: center;
            gap: 0.5rem;
            flex: 1;
        }
        
        .mensalidade-mes i {
            font-size: 1.2rem;
            color: #4a90e2;
        }
        
        .mensalidade-mes .mes-texto {
            font-size: 1rem;
            font-weight: 600;
            color: #333;
        }
        
        .mensalidade-status {
            flex-shrink: 0;
        }
        
        .mensalidade-badge {
            font-size: 0.75rem !important;
            padding: 0.4rem 0.75rem !important;
            font-weight: 600;
            border-radius: 20px;
        }
        
        .mensalidade-card-body {
            display: flex;
            justify-content: center;
            align-items: center;
        }
        
        .btn-pagar-mensalidade {
            width: 100%;
            padding: 0.75rem 1rem !important;
            font-size: 0.9rem !important;
            font-weight: 600;
            border-radius: 8px;
            display: flex;
            align-items: center;
            justify-content: center;
            gap: 0.5rem;
            box-shadow: 0 2px 4px rgba(0,0,0,0.1);
        }
        
        .mensalidade-paga {
            display: flex;
            align-items: center;
            justify-content: center;
            gap: 0.5rem;
            padding: 0.5rem;
            font-size: 0.9rem;
            font-weight: 500;
        }
        
        .mensalidade-paga i {
            font-size: 1.2rem;
        }
    }
    
    /* Desktop - manter layout atual */
    @media (min-width: 769px) {
        .financeiro-mobile-header,
        .financeiro-mobile-student-info,
        .financeiro-mobile-summary-cards,
        .financeiro-mobile-total-bar,
        .financeiro-mobile-situation,
        .financeiro-mobile-mensalidades-list {
            display: none;
        }
    }
</style>

<?php
    $meses = ['Jan', 'Fev', 'Mar', 'Abr', 'Mai', 'Jun', 'Jul', 'Ago', 'Set', 'Out', 'Nov', 'Dez'];
?>

<!-- Layout Mobile -->
<div class="d-md-none" style="overflow-x: hidden !important; max-width: 100vw; width: 100%; box-sizing: border-box;">
    <div class="financeiro-mobile-header">
        <a href="<?php echo e(route('aluno.dashboard')); ?>" class="back-btn">
            <i class="bi bi-arrow-left"></i>
        </a>
        <h1>Mensalidades</h1>
        <a href="#" class="profile-btn">
            <i class="bi bi-person-circle"></i>
        </a>
    </div>
    
    <div class="financeiro-mobile-student-info">
        <div class="info-row">
            <span class="info-label">Aluno(a):</span>
            <span class="info-value"><?php echo e($aluno->user->name); ?></span>
        </div>
        <div class="info-row">
            <span class="info-label">Turma:</span>
            <span class="info-value"><?php echo e($turma ? $turma->nome : 'N/A'); ?></span>
        </div>
    </div>
    
    <div class="financeiro-mobile-summary-cards">
        <div class="financeiro-mobile-summary-card">
            <div class="card-label">Pendente</div>
            <div class="card-value"><?php echo e(number_format($totalPendente, 0, ',', '.')); ?> MT</div>
        </div>
        <div class="financeiro-mobile-summary-card">
            <div class="card-label">Total com Multas</div>
            <div class="card-value"><?php echo e(number_format($totalComMultas ?? $totalPendente, 0, ',', '.')); ?> MT</div>
        </div>
        <div class="financeiro-mobile-summary-card">
            <div class="card-label">Multas</div>
            <div class="card-value text-danger"><?php echo e(number_format($totalMultas ?? 0, 0, ',', '.')); ?> MT</div>
        </div>
    </div>
    
    <div class="financeiro-mobile-total-bar">
        <div class="total-label">Total a Pagar</div>
        <div class="total-value"><?php echo e(number_format($totalComMultas ?? $totalPendente, 0, ',', '.')); ?> MT</div>
    </div>
    
    <div class="financeiro-mobile-situation">
        <span class="situation-label">Situação:</span>
        <span class="situation-badge <?php echo e($situacaoFinanceira === 'REGULAR' ? 'regular' : 'danger'); ?>">
            <?php echo e($situacaoFinanceira === 'REGULAR' ? 'Regular' : 'Em Dívida'); ?>

        </span>
        <?php if($situacaoFinanceira === 'REGULAR'): ?>
            <i class="bi bi-check-circle-fill situation-check"></i>
        <?php endif; ?>
    </div>
    
    <?php if($financeiros->count() > 0): ?>
        <div class="financeiro-mobile-mensalidades-list">
            <?php $__currentLoopData = $financeiros->where('tipo', 'Mensalidade'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $financeiro): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <?php
                    $mesNumero = (int) $financeiro->data_vencimento->format('m');
                    $ano = $financeiro->data_vencimento->format('Y');
                    $mesAbrev = $meses[$mesNumero - 1] ?? $financeiro->data_vencimento->format('M');
                ?>
                <div class="financeiro-mobile-mensalidade-card">
                    <div class="mensalidade-card-header">
                        <div class="mensalidade-mes">
                            <i class="bi bi-calendar3"></i>
                            <span class="mes-texto"><?php echo e($mesAbrev); ?>/<?php echo e($ano); ?></span>
                        </div>
                        <div class="mensalidade-status">
                            <?php if($financeiro->status === 'PAGO'): ?>
                                <span class="badge bg-success mensalidade-badge">PAGO</span>
                            <?php elseif($financeiro->status === 'VENCIDO'): ?>
                                <span class="badge bg-danger mensalidade-badge">VENCIDO</span>
                            <?php else: ?>
                                <span class="badge bg-warning mensalidade-badge">PENDENTE</span>
                            <?php endif; ?>
                        </div>
                    </div>
                    <div class="mensalidade-card-body">
                        <?php if($financeiro->status !== 'PAGO' && $financeiro->status !== 'CANCELADO'): ?>
                            <a href="<?php echo e(route('aluno.payment.create', ['financeiro_id' => $financeiro->id])); ?>" class="btn btn-primary btn-pagar-mensalidade">
                                <i class="bi bi-credit-card"></i> Pagar Mensalidade
                            </a>
                        <?php else: ?>
                            <div class="mensalidade-paga">
                                <i class="bi bi-check-circle-fill text-success"></i>
                                <span class="text-success">Mensalidade Paga</span>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
    <?php endif; ?>
</div>

<!-- Layout Desktop -->
<div class="d-none d-md-block">
    <div class="row">
        <div class="col-12">
            <div class="d-flex justify-content-between align-items-center mb-3">
                <h5 class="mb-0">Mensalidades</h5>
                <select name="ano_letivo_id" id="ano_letivo_id" class="form-select form-select-sm" style="width: auto;" onchange="window.location.href='<?php echo e(route('aluno.financeiro')); ?>?ano_letivo_id='+this.value">
                    <?php $__currentLoopData = $anosLetivos ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $ano): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php
                            $anoRaw = $ano->getRawOriginal('ano');
                            $anoFinal = strpos($anoRaw, '/') !== false ? explode('/', $anoRaw)[1] : $anoRaw;
                        ?>
                        <option value="<?php echo e($ano->id); ?>" <?php echo e($anoLetivoAtivo && $anoLetivoAtivo->id == $ano->id ? 'selected' : ''); ?>>
                            <?php echo e($anoFinal); ?>

                        </option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
            </div>
        </div>
    </div>

<?php
    $meses = ['Jan', 'Fev', 'Mar', 'Abr', 'Mai', 'Jun', 'Jul', 'Ago', 'Set', 'Out', 'Nov', 'Dez'];
    $mesesCompletos = [
        1 => 'Janeiro', 2 => 'Fevereiro', 3 => 'Março', 4 => 'Abril',
        5 => 'Maio', 6 => 'Junho', 7 => 'Julho', 8 => 'Agosto',
        9 => 'Setembro', 10 => 'Outubro', 11 => 'Novembro', 12 => 'Dezembro'
    ];
    $mensalidadesPorMes = [];
    $financeiroService = app(\App\Services\FinanceiroService::class);
    
    // Inicializar todos os meses como pendentes
    for ($i = 1; $i <= 12; $i++) {
        $mensalidadesPorMes[$i] = ['status' => 'PENDENTE', 'valor' => 0, 'multa' => 0, 'valor_com_multa' => 0, 'financeiro_id' => null];
    }
    
    // Preencher com dados reais das mensalidades (incluindo pagas)
    foreach ($financeiros->where('tipo', 'Mensalidade') as $financeiro) {
        $mesVencimento = (int) $financeiro->data_vencimento->format('m');
        if ($mesVencimento >= 1 && $mesVencimento <= 12) {
            $multa = isset($multasPorFinanceiro[$financeiro->id]) ? $multasPorFinanceiro[$financeiro->id]['multa'] : 0;
            $valorComMulta = isset($multasPorFinanceiro[$financeiro->id]) ? $multasPorFinanceiro[$financeiro->id]['valor_com_multa'] : $financeiro->valor;
            
            $mensalidadesPorMes[$mesVencimento] = [
                'status' => $financeiro->status,
                'valor' => $financeiro->valor,
                'multa' => $multa,
                'valor_com_multa' => $valorComMulta,
                'financeiro_id' => $financeiro->id,
            ];
        }
    }
?>

<?php if($financeiros->count() > 0): ?>
    <div class="table-responsive mb-3">
        <table class="table table-sm table-bordered mb-0">
            <thead>
                <tr>
                    <th style="width: 80px;">Mês</th>
                    <?php $__currentLoopData = $meses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $mes): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <th class="text-center" style="min-width: 70px;"><?php echo e($mes); ?></th>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tr>
            </thead>
            <tbody>
                <tr>
                    <td class="fw-bold small">Status</td>
                    <?php $__currentLoopData = $mensalidadesPorMes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $mes => $dados): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <td class="text-center">
                            <?php if($dados['status'] === 'PAGO'): ?>
                                <span class="badge bg-success">✓</span>
                            <?php else: ?>
                                <span class="badge bg-warning">○</span>
                            <?php endif; ?>
                        </td>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tr>
            </tbody>
        </table>
    </div>
<?php endif; ?>

<div class="row g-2 mb-3">
    <div class="col-md-3">
        <div class="border rounded p-2 text-center">
            <div class="small text-muted">Pendente</div>
            <div class="fw-bold"><?php echo e(number_format($totalPendente, 0, ',', '.')); ?> MT</div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="border rounded p-2 text-center">
            <div class="small text-muted">Multas</div>
            <div class="fw-bold text-danger"><?php echo e(number_format($totalMultas ?? 0, 0, ',', '.')); ?> MT</div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="border rounded p-2 text-center">
            <div class="small text-muted">Total com Multas</div>
            <div class="fw-bold text-warning"><?php echo e(number_format($totalComMultas ?? $totalPendente, 0, ',', '.')); ?> MT</div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="border rounded p-2 text-center">
            <div class="small text-muted">Pago</div>
            <div class="fw-bold text-success"><?php echo e(number_format($totalPago ?? 0, 0, ',', '.')); ?> MT</div>
        </div>
    </div>
</div>

<div class="row mb-3">
    <div class="col-12">
        <div class="border rounded p-2">
            <div class="small text-muted mb-1">Situação</div>
            <div class="d-flex align-items-center gap-2">
                <span class="badge bg-<?php echo e($situacaoFinanceira === 'REGULAR' ? 'success' : 'danger'); ?>">
                    <?php echo e($situacaoFinanceira === 'REGULAR' ? 'Regular' : 'Em Dívida'); ?>

                </span>
                <?php if($situacaoFinanceira === 'EM_DÍVIDA'): ?>
                    <a href="<?php echo e(route('aluno.payment.create')); ?>" class="btn btn-sm btn-primary">Pagar</a>
                <?php endif; ?>
            </div>
        </div>
    </div>
</div>

<?php if($financeiros->count() > 0): ?>
    <div class="table-responsive mb-3">
        <table class="table table-sm table-bordered">
            <thead>
                <tr>
                    <th>Mês</th>
                    <th>Valor</th>
                    <th>Multa</th>
                    <th>Total</th>
                    <th>Status</th>
                    <th>Vencimento</th>
                    <th>Acções</th>
                </tr>
            </thead>
            <tbody>
                <?php $__currentLoopData = $financeiros->where('tipo', 'Mensalidade'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $financeiro): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <?php
                        $multa = $multasPorFinanceiro[$financeiro->id]['multa'] ?? 0;
                        $valorComMulta = $multasPorFinanceiro[$financeiro->id]['valor_com_multa'] ?? $financeiro->valor;
                        $diasAtraso = $multasPorFinanceiro[$financeiro->id]['dias_atraso'] ?? 0;
                    ?>
                    <tr>
                        <td>
                            <?php
                                $mesNumero = (int) $financeiro->data_vencimento->format('m');
                                $ano = $financeiro->data_vencimento->format('Y');
                                $mesNome = $mesesCompletos[$mesNumero] ?? $financeiro->data_vencimento->format('F');
                            ?>
                            <?php echo e($mesNome); ?>/<?php echo e($ano); ?>

                        </td>
                        <td><?php echo e(number_format($financeiro->valor, 0, ',', '.')); ?> MT</td>
                        <td class="<?php echo e($multa > 0 ? 'text-danger' : ''); ?>">
                            <?php if($multa > 0): ?>
                                +<?php echo e(number_format($multa, 0, ',', '.')); ?> MT
                                <small class="d-block text-muted">(<?php echo e($diasAtraso); ?> dias de atraso)</small>
                            <?php else: ?>
                                -
                            <?php endif; ?>
                        </td>
                        <td class="fw-bold"><?php echo e(number_format($valorComMulta, 0, ',', '.')); ?> MT</td>
                        <td>
                            <span class="badge bg-<?php echo e($financeiro->status === 'PAGO' ? 'success' : ($financeiro->status === 'VENCIDO' ? 'danger' : 'warning')); ?>">
                                <?php echo e($financeiro->status); ?>

                            </span>
                        </td>
                        <td><?php echo e($financeiro->data_vencimento->format('d/m/Y')); ?></td>
                        <td>
                            <?php if($financeiro->status !== 'PAGO' && $financeiro->status !== 'CANCELADO'): ?>
                                <?php
                                    $isFutura = $financeiro->data_vencimento > now();
                                    $badgeClass = $isFutura ? 'info' : ($financeiro->status === 'VENCIDO' ? 'danger' : 'warning');
                                    $badgeText = $isFutura ? 'Adiantado' : ($financeiro->status === 'VENCIDO' ? 'Vencido' : 'Pendente');
                                ?>
                                <a href="<?php echo e(route('aluno.payment.create', ['financeiro_id' => $financeiro->id])); ?>" class="btn btn-sm btn-primary" title="<?php echo e($isFutura ? 'Pagar mensalidade adiantada' : 'Pagar mensalidade'); ?>">
                                    <i class="bi bi-credit-card"></i> Pagar
                                </a>
                                <small class="d-block text-muted mt-1">
                                    <span class="badge bg-<?php echo e($badgeClass); ?>"><?php echo e($badgeText); ?></span>
                                </small>
                            <?php elseif($financeiro->status === 'PAGO'): ?>
                                <span class="badge bg-success">Pago</span>
                            <?php endif; ?>
                        </td>
                    </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </tbody>
        </table>
    </div>
<?php endif; ?>

<?php if($invoices->count() > 0): ?>
    <div class="border-top pt-3">
        <div class="d-flex justify-content-between align-items-center mb-2">
            <h6 class="mb-0">Facturas</h6>
            <a href="<?php echo e(route('aluno.invoice.index')); ?>" class="btn btn-sm btn-link p-0">Ver todas</a>
        </div>
        <div class="table-responsive">
            <table class="table table-sm table-hover mb-0">
                <thead>
                    <tr>
                        <th>Nº</th>
                        <th>Data</th>
                        <th class="text-end">Valor</th>
                        <th class="text-center">Status</th>
                        <th class="text-center">Acções</th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__currentLoopData = $invoices->take(5); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $invoice): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <td class="small"><?php echo e($invoice->numero_factura); ?></td>
                            <td class="small"><?php echo e($invoice->data_emissao->format('d/m/Y')); ?></td>
                            <td class="text-end small"><?php echo e(number_format($invoice->valor, 0, ',', '.')); ?> MT</td>
                            <td class="text-center">
                                <span class="badge bg-<?php echo e($invoice->status === 'PAGA' ? 'success' : 'warning'); ?>">
                                    <?php echo e($invoice->status === 'PAGA' ? 'Paga' : 'Pendente'); ?>

                                </span>
                            </td>
                            <td class="text-center">
                                <a href="<?php echo e(route('aluno.invoice.show', $invoice)); ?>" class="btn btn-sm btn-link p-0" title="Ver">
                                    <i class="bi bi-eye"></i>
                                </a>
                                <?php if($invoice->status === 'PAGA'): ?>
                                    <a href="<?php echo e(route('aluno.invoice.download', $invoice)); ?>" class="btn btn-sm btn-link p-0" title="PDF">
                                        <i class="bi bi-download"></i>
                                    </a>
                                <?php endif; ?>
                            </td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
            </table>
        </div>
    </div>
<?php endif; ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\Users\Alcidio\Desktop\escola\resources\views/aluno/financeiro.blade.php ENDPATH**/ ?>